/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.cip;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.ClaimInformationPointProvider;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.PlaceHolders;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClaimsInformationPointProvider
implements ClaimInformationPointProvider {
    private final Map<String, Object> config;

    public ClaimsInformationPointProvider(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public Map<String, List<String>> resolve(HttpFacade httpFacade) {
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> configEntry : this.config.entrySet()) {
            String claimName = configEntry.getKey();
            Object claimValue = configEntry.getValue();
            List<Object> values = new ArrayList();
            if (claimValue instanceof String) {
                values = this.getValues(claimValue.toString(), httpFacade);
            } else if (claimValue instanceof Collection) {
                for (Object value : (Collection)Collection.class.cast(claimValue)) {
                    List<String> resolvedValues = this.getValues(value.toString(), httpFacade);
                    if (resolvedValues.isEmpty()) continue;
                    values.addAll(resolvedValues);
                }
            }
            if (values.isEmpty()) continue;
            claims.put(claimName, values);
        }
        return claims;
    }

    private List<String> getValues(String value, HttpFacade httpFacade) {
        return PlaceHolders.resolve(value, httpFacade);
    }
}

