/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util;

import com.fasterxml.jackson.databind.JsonNode;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.KeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.OIDCHttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.JsonUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.PlaceHolderResolver;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.PlaceHolders;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.util.JsonSerialization;
import java.util.Arrays;
import java.util.List;

public class KeycloakSecurityContextPlaceHolderResolver
implements PlaceHolderResolver {
    public static final String NAME = "keycloak";

    @Override
    public List<String> resolve(String placeHolder, HttpFacade httpFacade) {
        JsonNode jsonNode;
        String source = placeHolder.substring(placeHolder.indexOf(46) + 1);
        OIDCHttpFacade oidcHttpFacade = (OIDCHttpFacade)OIDCHttpFacade.class.cast(httpFacade);
        KeycloakSecurityContext securityContext = oidcHttpFacade.getSecurityContext();
        if (securityContext == null) {
            return null;
        }
        if (source.endsWith("access_token")) {
            return Arrays.asList(securityContext.getTokenString());
        }
        if (source.endsWith("id_token")) {
            return Arrays.asList(securityContext.getIdTokenString());
        }
        if (source.startsWith("access_token[")) {
            jsonNode = JsonSerialization.mapper.valueToTree((Object)securityContext.getToken());
        } else if (source.startsWith("id_token[")) {
            jsonNode = JsonSerialization.mapper.valueToTree((Object)securityContext.getIdToken());
        } else {
            throw new RuntimeException("Invalid placeholder [" + placeHolder + "]");
        }
        return JsonUtils.getValues(jsonNode, PlaceHolders.getParameter(source, "Invalid placeholder [" + placeHolder + "]"));
    }
}

