/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util;

import com.fasterxml.jackson.databind.JsonNode;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.JsonUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.PlaceHolderResolver;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authorization.util.PlaceHolders;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.util.JsonSerialization;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RequestPlaceHolderResolver
implements PlaceHolderResolver {
    static String NAME = "request";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> resolve(String placeHolder, HttpFacade httpFacade) {
        String source = placeHolder.substring(placeHolder.indexOf(46) + 1);
        HttpFacade.Request request = httpFacade.getRequest();
        if (source.startsWith("parameter")) {
            String parameterName = PlaceHolders.getParameter(source, "Could not obtain parameter name from placeholder [" + source + "]");
            String parameterValue = request.getQueryParamValue(parameterName);
            if (parameterValue == null) {
                parameterValue = request.getFirstParam(parameterName);
            }
            if (parameterValue == null) return Collections.emptyList();
            return Arrays.asList(parameterValue);
        }
        if (source.startsWith("header")) {
            String headerName = PlaceHolders.getParameter(source, "Could not obtain header name from placeholder [" + source + "]");
            List<String> headerValue = request.getHeaders(headerName);
            if (headerValue == null) return Collections.emptyList();
            return headerValue;
        }
        if (source.startsWith("cookie")) {
            String cookieName = PlaceHolders.getParameter(source, "Could not obtain cookie name from placeholder [" + source + "]");
            HttpFacade.Cookie cookieValue = request.getCookie(cookieName);
            if (cookieValue == null) return Collections.emptyList();
            return Arrays.asList(cookieValue.getValue());
        }
        if (source.startsWith("remoteAddr")) {
            String value = request.getRemoteAddr();
            if (value == null) return Collections.emptyList();
            return Arrays.asList(value);
        }
        if (source.startsWith("method")) {
            String value = request.getMethod();
            if (value == null) return Collections.emptyList();
            return Arrays.asList(value);
        }
        if (source.startsWith("uri")) {
            String value = request.getURI();
            if (value == null) return Collections.emptyList();
            return Arrays.asList(value);
        }
        if (source.startsWith("relativePath")) {
            String value = request.getRelativePath();
            if (value == null) return Collections.emptyList();
            return Arrays.asList(value);
        }
        if (source.startsWith("secure")) {
            return Arrays.asList(String.valueOf(request.isSecure()));
        }
        if (!source.startsWith("body")) return Collections.emptyList();
        String contentType = request.getHeader("Content-Type");
        if (contentType == null) {
            contentType = "";
        }
        InputStream body = request.getInputStream(true);
        try {
            if (body == null || body.available() == 0) {
                return Collections.emptyList();
            }
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to check available bytes in request input stream", cause);
        }
        if (body.markSupported()) {
            body.mark(0);
        }
        ArrayList<String> values = new ArrayList<String>();
        try {
            switch (contentType) {
                case "application/json": {
                    try {
                        JsonNode jsonNode = JsonSerialization.mapper.readTree((InputStream)new BufferedInputStream(body){

                            @Override
                            public void close() {
                            }
                        });
                        String path = PlaceHolders.getParameter(source, null);
                        if (path == null) {
                            values.addAll(JsonUtils.getValues(jsonNode));
                            return values;
                        } else {
                            values.addAll(JsonUtils.getValues(jsonNode, path));
                            return values;
                        }
                    }
                    catch (IOException cause) {
                        throw new RuntimeException("Could not extract claim from request JSON body", cause);
                    }
                }
                default: {
                    StringBuilder value = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(body));
                    try {
                        int ch;
                        while ((ch = reader.read()) != -1) {
                            value.append((char)ch);
                        }
                    }
                    catch (IOException cause) {
                        throw new RuntimeException("Could not extract claim from request body", cause);
                    }
                    values.add(value.toString());
                    return values;
                }
            }
        }
        finally {
            if (body.markSupported()) {
                try {
                    body.reset();
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to reset request input stream", cause);
                }
            }
        }
    }
}

