/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.rotation;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.TokenVerifier;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.rotation.PublicKeyLocator;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.VerificationException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.AccessToken;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.IDToken;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.JsonWebToken;
import java.security.PublicKey;

public class AdapterTokenVerifier {
    private static final Logger log = Logger.getLogger(AdapterTokenVerifier.class);

    public static AccessToken verifyToken(String tokenString, KeycloakDeployment deployment) throws VerificationException {
        TokenVerifier<AccessToken> tokenVerifier = AdapterTokenVerifier.createVerifier(tokenString, deployment, true, AccessToken.class);
        if (deployment.isVerifyTokenAudience()) {
            tokenVerifier.audience(deployment.getResourceName());
        }
        return tokenVerifier.verify().getToken();
    }

    public static VerifiedTokens verifyTokens(String accessTokenString, String idTokenString, KeycloakDeployment deployment) throws VerificationException {
        TokenVerifier<AccessToken> tokenVerifier = AdapterTokenVerifier.createVerifier(accessTokenString, deployment, true, AccessToken.class);
        AccessToken accessToken = tokenVerifier.verify().getToken();
        if (idTokenString != null) {
            IDToken idToken = TokenVerifier.create(idTokenString, IDToken.class).getToken();
            TokenVerifier<IDToken> idTokenVerifier = TokenVerifier.createWithoutSignature(idToken);
            idTokenVerifier.audience(deployment.getResourceName());
            idTokenVerifier.issuedFor(deployment.getResourceName());
            idTokenVerifier.verify();
            return new VerifiedTokens(accessToken, idToken);
        }
        return new VerifiedTokens(accessToken, null);
    }

    public static <T extends JsonWebToken> TokenVerifier<T> createVerifier(String tokenString, KeycloakDeployment deployment, boolean withDefaultChecks, Class<T> tokenClass) throws VerificationException {
        TokenVerifier<T> tokenVerifier = TokenVerifier.create(tokenString, tokenClass);
        if (withDefaultChecks) {
            tokenVerifier.withDefaultChecks().realmUrl(deployment.getRealmInfoUrl());
        }
        String kid = tokenVerifier.getHeader().getKeyId();
        PublicKey publicKey = AdapterTokenVerifier.getPublicKey(kid, deployment);
        tokenVerifier.publicKey(publicKey);
        return tokenVerifier;
    }

    private static PublicKey getPublicKey(String kid, KeycloakDeployment deployment) throws VerificationException {
        PublicKeyLocator pkLocator = deployment.getPublicKeyLocator();
        PublicKey publicKey = pkLocator.getPublicKey(kid, deployment);
        if (publicKey == null) {
            log.errorf("Didn't find publicKey for kid: %s", (Object)kid);
            throw new VerificationException("Didn't find publicKey for specified kid");
        }
        return publicKey;
    }

    public static class VerifiedTokens {
        private final AccessToken accessToken;
        private final IDToken idToken;

        public VerifiedTokens(AccessToken accessToken, IDToken idToken) {
            this.accessToken = accessToken;
            this.idToken = idToken;
        }

        public AccessToken getAccessToken() {
            return this.accessToken;
        }

        public IDToken getIdToken() {
            return this.idToken;
        }
    }
}

