/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.KeycloakPrincipal;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.KeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterTokenStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.OAuthRequestAuthenticator;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.OIDCHttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.OidcKeycloakAccount;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.RefreshableKeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.RequestAuthenticator;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.KeycloakAccount;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FilterRequestAuthenticator
extends RequestAuthenticator {
    private static final Logger log = Logger.getLogger("" + FilterRequestAuthenticator.class);
    protected HttpServletRequest request;

    public FilterRequestAuthenticator(KeycloakDeployment deployment, AdapterTokenStore tokenStore, OIDCHttpFacade facade, HttpServletRequest request, int sslRedirectPort) {
        super(facade, deployment, tokenStore, sslRedirectPort);
        this.request = request;
    }

    @Override
    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator(this, this.facade, this.deployment, this.sslRedirectPort, this.tokenStore);
    }

    @Override
    protected void completeOAuthAuthentication(final KeycloakPrincipal<RefreshableKeycloakSecurityContext> skp) {
        final RefreshableKeycloakSecurityContext securityContext = skp.getKeycloakSecurityContext();
        final Set<String> roles = AdapterUtils.getRolesFromSecurityContext(securityContext);
        OidcKeycloakAccount account = new OidcKeycloakAccount(){

            @Override
            public Principal getPrincipal() {
                return skp;
            }

            @Override
            public Set<String> getRoles() {
                return roles;
            }

            @Override
            public KeycloakSecurityContext getKeycloakSecurityContext() {
                return securityContext;
            }
        };
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        this.tokenStore.saveAccountInfo(account);
    }

    @Override
    protected void completeBearerAuthentication(final KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, String method) {
        final RefreshableKeycloakSecurityContext securityContext = principal.getKeycloakSecurityContext();
        final Set<String> roles = AdapterUtils.getRolesFromSecurityContext(securityContext);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Completing bearer authentication. Bearer roles: " + roles);
        }
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        OidcKeycloakAccount account = new OidcKeycloakAccount(){

            @Override
            public Principal getPrincipal() {
                return principal;
            }

            @Override
            public Set<String> getRoles() {
                return roles;
            }

            @Override
            public KeycloakSecurityContext getKeycloakSecurityContext() {
                return securityContext;
            }
        };
        this.request.setAttribute(KeycloakAccount.class.getName(), (Object)account);
    }

    @Override
    protected String changeHttpSessionId(boolean create) {
        HttpSession session = this.request.getSession(create);
        return session != null ? session.getId() : null;
    }
}

