/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.AdapterSessionStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.KeycloakAccount;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.Encode;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.MultivaluedHashMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class FilterSessionStore
implements AdapterSessionStore {
    public static final String REDIRECT_URI = "__REDIRECT_URI";
    public static final String SAVED_METHOD = "__SAVED_METHOD";
    public static final String SAVED_HEADERS = "__SAVED_HEADERS";
    public static final String SAVED_BODY = "__SAVED_BODY";
    protected final HttpServletRequest request;
    protected final HttpFacade facade;
    protected final int maxBuffer;
    protected byte[] restoredBuffer = null;
    protected boolean needRequestRestore;

    public FilterSessionStore(HttpServletRequest request, HttpFacade facade, int maxBuffer) {
        this.request = request;
        this.facade = facade;
        this.maxBuffer = maxBuffer;
    }

    public void clearSavedRequest(HttpSession session) {
        session.removeAttribute(REDIRECT_URI);
        session.removeAttribute(SAVED_METHOD);
        session.removeAttribute(SAVED_HEADERS);
        session.removeAttribute(SAVED_BODY);
    }

    public void servletRequestLogout() {
    }

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public HttpServletRequestWrapper buildWrapper(HttpSession session, final KeycloakAccount account) {
        if (this.needRequestRestore) {
            final String method = (String)session.getAttribute(SAVED_METHOD);
            final byte[] body = (byte[])session.getAttribute(SAVED_BODY);
            final MultivaluedHashMap headers = (MultivaluedHashMap)session.getAttribute(SAVED_HEADERS);
            this.clearSavedRequest(session);
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request){
                protected MultivaluedHashMap<String, String> parameters;

                MultivaluedHashMap<String, String> getParams() {
                    if (this.parameters != null) {
                        return this.parameters;
                    }
                    if (body == null) {
                        return new MultivaluedHashMap<String, String>();
                    }
                    String contentType = this.getContentType();
                    if (contentType != null && contentType.toLowerCase().startsWith("application/x-www-form-urlencoded")) {
                        ByteArrayInputStream is = new ByteArrayInputStream(body);
                        try {
                            this.parameters = FilterSessionStore.parseForm(is);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.parameters;
                }

                public boolean isUserInRole(String role) {
                    return account.getRoles().contains(role);
                }

                public Principal getUserPrincipal() {
                    return account.getPrincipal();
                }

                public String getMethod() {
                    if (FilterSessionStore.this.needRequestRestore) {
                        return method;
                    }
                    return super.getMethod();
                }

                public String getHeader(String name) {
                    if (FilterSessionStore.this.needRequestRestore && headers != null) {
                        return (String)headers.getFirst(name.toLowerCase());
                    }
                    return super.getHeader(name);
                }

                public Enumeration<String> getHeaders(String name) {
                    if (FilterSessionStore.this.needRequestRestore && headers != null) {
                        List values = headers.getList(name.toLowerCase());
                        if (values == null) {
                            return Collections.emptyEnumeration();
                        }
                        return Collections.enumeration(values);
                    }
                    return super.getHeaders(name);
                }

                public Enumeration<String> getHeaderNames() {
                    if (FilterSessionStore.this.needRequestRestore && headers != null) {
                        return Collections.enumeration(headers.keySet());
                    }
                    return super.getHeaderNames();
                }

                public ServletInputStream getInputStream() throws IOException {
                    if (FilterSessionStore.this.needRequestRestore && body != null) {
                        final ByteArrayInputStream is = new ByteArrayInputStream(body);
                        return new ServletInputStream(){

                            public int read() throws IOException {
                                return is.read();
                            }
                        };
                    }
                    return super.getInputStream();
                }

                public void logout() throws ServletException {
                    FilterSessionStore.this.servletRequestLogout();
                }

                public long getDateHeader(String name) {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getDateHeader(name);
                    }
                    return -1L;
                }

                public int getIntHeader(String name) {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getIntHeader(name);
                    }
                    String value = this.getHeader(name);
                    if (value == null) {
                        return -1;
                    }
                    return Integer.valueOf(value);
                }

                public String[] getParameterValues(String name) {
                    List vals;
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getParameterValues(name);
                    }
                    MultivaluedHashMap<String, String> formParams = this.getParams();
                    if (formParams == null) {
                        return super.getParameterValues(name);
                    }
                    String[] values = FilterSessionStore.this.request.getParameterValues(name);
                    LinkedList<String> list = new LinkedList<String>();
                    if (values != null) {
                        for (String val : values) {
                            list.add(val);
                        }
                    }
                    if ((vals = (List)formParams.get(name)) != null) {
                        list.addAll(vals);
                    }
                    return list.toArray(new String[list.size()]);
                }

                public Enumeration<String> getParameterNames() {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getParameterNames();
                    }
                    MultivaluedHashMap<String, String> formParams = this.getParams();
                    if (formParams == null) {
                        return super.getParameterNames();
                    }
                    HashSet<Object> names = new HashSet<Object>();
                    Enumeration qnames = super.getParameterNames();
                    while (qnames.hasMoreElements()) {
                        names.add(qnames.nextElement());
                    }
                    names.addAll(formParams.keySet());
                    return Collections.enumeration(names);
                }

                public Map<String, String[]> getParameterMap() {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getParameterMap();
                    }
                    MultivaluedHashMap<String, String> formParams = this.getParams();
                    if (formParams == null) {
                        return super.getParameterMap();
                    }
                    HashMap<String, String[]> map = new HashMap<String, String[]>();
                    Enumeration<String> names = this.getParameterNames();
                    while (names.hasMoreElements()) {
                        String name = names.nextElement();
                        String[] values = this.getParameterValues(name);
                        if (values == null) continue;
                        map.put(name, values);
                    }
                    return map;
                }

                public String getParameter(String name) {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getParameter(name);
                    }
                    String param = super.getParameter(name);
                    if (param != null) {
                        return param;
                    }
                    MultivaluedHashMap<String, String> formParams = this.getParams();
                    if (formParams == null) {
                        return null;
                    }
                    return formParams.getFirst(name);
                }

                public BufferedReader getReader() throws IOException {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getReader();
                    }
                    return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
                }

                public int getContentLength() {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getContentLength();
                    }
                    String header = this.getHeader("content-length");
                    if (header == null) {
                        return -1;
                    }
                    return Integer.valueOf(header);
                }

                public String getContentType() {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getContentType();
                    }
                    return this.getHeader("content-type");
                }

                public String getCharacterEncoding() {
                    if (!FilterSessionStore.this.needRequestRestore) {
                        return super.getCharacterEncoding();
                    }
                    return FilterSessionStore.getCharsetFromContentType(this.getContentType());
                }
            };
            return wrapper;
        }
        return new HttpServletRequestWrapper(this.request){

            public boolean isUserInRole(String role) {
                return account.getRoles().contains(role);
            }

            public Principal getUserPrincipal() {
                if (account == null) {
                    return null;
                }
                return account.getPrincipal();
            }

            public void logout() throws ServletException {
                FilterSessionStore.this.servletRequestLogout();
            }
        };
    }

    public String getRedirectUri() {
        HttpSession session = this.request.getSession(true);
        return (String)session.getAttribute(REDIRECT_URI);
    }

    @Override
    public boolean restoreRequest() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        return session.getAttribute(REDIRECT_URI) != null;
    }

    public static MultivaluedHashMap<String, String> parseForm(InputStream entityStream) throws IOException {
        String[] params;
        char[] buffer = new char[100];
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 100)) <= 0) continue;
            buf.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        String form = buf.toString();
        MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
        if ("".equals(form)) {
            return formData;
        }
        for (String param : params = form.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=");
                String val = nv.length > 1 ? nv[1] : "";
                formData.add(Encode.decode(nv[0]), Encode.decode(val));
                continue;
            }
            formData.add(Encode.decode(param), "");
        }
        return formData;
    }

    @Override
    public void saveRequest() {
        HttpSession session = this.request.getSession(true);
        session.setAttribute(REDIRECT_URI, (Object)this.facade.getRequest().getURI());
        session.setAttribute(SAVED_METHOD, (Object)this.request.getMethod());
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = this.request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.add(name.toLowerCase(), values.nextElement());
            }
        }
        session.setAttribute(SAVED_HEADERS, headers);
        if (this.request.getMethod().equalsIgnoreCase("GET")) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int totalRead = 0;
        try {
            int bytesRead;
            ServletInputStream is = this.request.getInputStream();
            while ((bytesRead = is.read(buffer)) >= 0) {
                os.write(buffer);
                if ((totalRead += bytesRead) <= this.maxBuffer) continue;
                throw new RuntimeException("max buffer reached on a saved request");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] body = os.toByteArray();
        if (body.length > 0) {
            session.setAttribute(SAVED_BODY, (Object)body);
        }
    }
}

