/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterDeploymentContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AuthenticatedActionsHandler;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakConfigResolver;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeploymentBuilder;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.NodesRegistrationManagement;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.PreAuthActionsHandler;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet.FilterRequestAuthenticator;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet.OIDCFilterSessionStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet.OIDCServletHttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.AuthChallenge;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.AuthOutcome;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.InMemorySessionIdMapper;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.SessionIdMapper;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.UserSessionManagement;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class KeycloakOIDCFilter
implements Filter {
    private static final Logger log = Logger.getLogger("" + KeycloakOIDCFilter.class);
    public static final String SKIP_PATTERN_PARAM = "keycloak.config.skipPattern";
    public static final String CONFIG_RESOLVER_PARAM = "keycloak.config.resolver";
    public static final String CONFIG_FILE_PARAM = "keycloak.config.file";
    public static final String CONFIG_PATH_PARAM = "keycloak.config.path";
    protected AdapterDeploymentContext deploymentContext;
    protected SessionIdMapper idMapper = new InMemorySessionIdMapper();
    protected NodesRegistrationManagement nodesRegistrationManagement;
    protected Pattern skipPattern;
    private final KeycloakConfigResolver definedconfigResolver;

    public KeycloakOIDCFilter(KeycloakConfigResolver definedconfigResolver) {
        this.definedconfigResolver = definedconfigResolver;
    }

    public KeycloakOIDCFilter() {
        this(null);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String skipPatternDefinition = filterConfig.getInitParameter(SKIP_PATTERN_PARAM);
        if (skipPatternDefinition != null) {
            this.skipPattern = Pattern.compile(skipPatternDefinition, 32);
        }
        if (this.definedconfigResolver != null) {
            this.deploymentContext = new AdapterDeploymentContext(this.definedconfigResolver);
            log.log(Level.INFO, "Using {0} to resolve Keycloak configuration on a per-request basis.", this.definedconfigResolver.getClass());
        } else {
            String configResolverClass = filterConfig.getInitParameter(CONFIG_RESOLVER_PARAM);
            if (configResolverClass != null) {
                try {
                    KeycloakConfigResolver configResolver = (KeycloakConfigResolver)this.getClass().getClassLoader().loadClass(configResolverClass).newInstance();
                    this.deploymentContext = new AdapterDeploymentContext(configResolver);
                    log.log(Level.INFO, "Using {0} to resolve Keycloak configuration on a per-request basis.", configResolverClass);
                }
                catch (Exception ex) {
                    log.log(Level.FINE, "The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
                    this.deploymentContext = new AdapterDeploymentContext(new KeycloakDeployment());
                }
            } else {
                String fp = filterConfig.getInitParameter(CONFIG_FILE_PARAM);
                InputStream is = null;
                if (fp != null) {
                    try {
                        is = new FileInputStream(fp);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    String path = "/WEB-INF/keycloak.json";
                    String pathParam = filterConfig.getInitParameter(CONFIG_PATH_PARAM);
                    if (pathParam != null) {
                        path = pathParam;
                    }
                    is = filterConfig.getServletContext().getResourceAsStream(path);
                }
                KeycloakDeployment kd = this.createKeycloakDeploymentFrom(is);
                this.deploymentContext = new AdapterDeploymentContext(kd);
                log.fine("Keycloak is using a per-deployment configuration.");
            }
        }
        filterConfig.getServletContext().setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        this.nodesRegistrationManagement = new NodesRegistrationManagement();
    }

    private KeycloakDeployment createKeycloakDeploymentFrom(InputStream is) {
        if (is == null) {
            log.fine("No adapter configuration. Keycloak is unconfigured and will deny all requests.");
            return new KeycloakDeployment();
        }
        return KeycloakDeploymentBuilder.build(is);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        log.fine("Keycloak OIDC Filter");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.shouldSkip(request)) {
            chain.doFilter(req, res);
            return;
        }
        OIDCServletHttpFacade facade = new OIDCServletHttpFacade(request, response);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment(facade);
        if (deployment == null || !deployment.isConfigured()) {
            response.sendError(403);
            log.fine("deployment not configured");
            return;
        }
        PreAuthActionsHandler preActions = new PreAuthActionsHandler(new UserSessionManagement(){

            @Override
            public void logoutAll() {
                if (KeycloakOIDCFilter.this.idMapper != null) {
                    KeycloakOIDCFilter.this.idMapper.clear();
                }
            }

            @Override
            public void logoutHttpSessions(List<String> ids) {
                log.fine("**************** logoutHttpSessions");
                for (String id : ids) {
                    log.finest("removed idMapper: " + id);
                    KeycloakOIDCFilter.this.idMapper.removeSession(id);
                }
            }
        }, this.deploymentContext, facade);
        if (preActions.handleRequest()) {
            return;
        }
        this.nodesRegistrationManagement.tryRegister(deployment);
        OIDCFilterSessionStore tokenStore = new OIDCFilterSessionStore(request, facade, 100000, deployment, this.idMapper);
        tokenStore.checkCurrentToken();
        FilterRequestAuthenticator authenticator = new FilterRequestAuthenticator(deployment, tokenStore, facade, request, 8443);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            log.fine("AUTHENTICATED");
            if (facade.isEnded()) {
                return;
            }
            AuthenticatedActionsHandler actions = new AuthenticatedActionsHandler(deployment, facade);
            if (actions.handledRequest()) {
                return;
            }
            HttpServletRequestWrapper wrapper = tokenStore.buildWrapper();
            chain.doFilter((ServletRequest)wrapper, res);
            return;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            log.fine("challenge");
            challenge.challenge(facade);
            return;
        }
        response.sendError(403);
    }

    private boolean shouldSkip(HttpServletRequest request) {
        if (this.skipPattern == null) {
            return false;
        }
        String requestPath = request.getRequestURI().substring(request.getContextPath().length());
        return this.skipPattern.matcher(requestPath).matches();
    }

    public void destroy() {
    }
}

