/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.KeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterTokenStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.OidcKeycloakAccount;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.RefreshableKeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.RequestAuthenticator;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet.FilterSessionStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.KeycloakAccount;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.SessionIdMapper;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class OIDCFilterSessionStore
extends FilterSessionStore
implements AdapterTokenStore {
    protected final KeycloakDeployment deployment;
    private static final Logger log = Logger.getLogger("" + OIDCFilterSessionStore.class);
    protected final SessionIdMapper idMapper;

    public OIDCFilterSessionStore(HttpServletRequest request, HttpFacade facade, int maxBuffer, KeycloakDeployment deployment, SessionIdMapper idMapper) {
        super(request, facade, maxBuffer);
        this.deployment = deployment;
        this.idMapper = idMapper;
    }

    public HttpServletRequestWrapper buildWrapper() {
        HttpSession session = this.request.getSession(false);
        KeycloakAccount account = null;
        if (session != null && (account = (KeycloakAccount)session.getAttribute(KeycloakAccount.class.getName())) == null) {
            account = (KeycloakAccount)this.request.getAttribute(KeycloakAccount.class.getName());
        }
        if (account == null) {
            account = (KeycloakAccount)this.request.getAttribute(KeycloakAccount.class.getName());
        }
        return this.buildWrapper(session, account);
    }

    @Override
    public void checkCurrentToken() {
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession == null) {
            return;
        }
        SerializableKeycloakAccount account = (SerializableKeycloakAccount)httpSession.getAttribute(KeycloakAccount.class.getName());
        if (account == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = account.getKeycloakSecurityContext();
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setCurrentRequestInfo(this.deployment, this);
        }
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return;
        }
        this.cleanSession(httpSession);
        httpSession.invalidate();
    }

    protected void cleanSession(HttpSession session) {
        session.removeAttribute(KeycloakAccount.class.getName());
        session.removeAttribute(KeycloakSecurityContext.class.getName());
        this.clearSavedRequest(session);
    }

    @Override
    public boolean isCached(RequestAuthenticator authenticator) {
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession == null) {
            return false;
        }
        SerializableKeycloakAccount account = (SerializableKeycloakAccount)httpSession.getAttribute(KeycloakAccount.class.getName());
        if (account == null) {
            return false;
        }
        log.fine("remote logged in already. Establish state from session");
        RefreshableKeycloakSecurityContext securityContext = account.getKeycloakSecurityContext();
        if (!this.deployment.getRealm().equals(securityContext.getRealm())) {
            log.fine("Account from cookie is from a different realm than for the request.");
            this.cleanSession(httpSession);
            return false;
        }
        if (this.idMapper != null && !this.idMapper.hasSession(httpSession.getId())) {
            log.fine("idMapper does not have session: " + httpSession.getId());
            this.cleanSession(httpSession);
            return false;
        }
        securityContext.setCurrentRequestInfo(this.deployment, this);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        this.needRequestRestore = this.restoreRequest();
        return true;
    }

    @Override
    public void saveAccountInfo(OidcKeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        Set<String> roles = account.getRoles();
        SerializableKeycloakAccount sAccount = new SerializableKeycloakAccount(roles, account.getPrincipal(), securityContext);
        HttpSession httpSession = this.request.getSession();
        httpSession.setAttribute(KeycloakAccount.class.getName(), (Object)sAccount);
        httpSession.setAttribute(KeycloakSecurityContext.class.getName(), (Object)sAccount.getKeycloakSecurityContext());
        if (this.idMapper != null) {
            this.idMapper.map(account.getKeycloakSecurityContext().getToken().getSessionState(), account.getPrincipal().getName(), httpSession.getId());
        }
    }

    @Override
    public void logout() {
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null) {
            SerializableKeycloakAccount account = (SerializableKeycloakAccount)httpSession.getAttribute(KeycloakAccount.class.getName());
            if (account != null) {
                account.getKeycloakSecurityContext().logout(this.deployment);
            }
            this.cleanSession(httpSession);
        }
    }

    @Override
    public void servletRequestLogout() {
        this.logout();
    }

    @Override
    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }

    public static class SerializableKeycloakAccount
    implements OidcKeycloakAccount,
    Serializable {
        protected Set<String> roles;
        protected Principal principal;
        protected RefreshableKeycloakSecurityContext securityContext;

        public SerializableKeycloakAccount(Set<String> roles, Principal principal, RefreshableKeycloakSecurityContext securityContext) {
            this.roles = roles;
            this.principal = principal;
            this.securityContext = securityContext;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        @Override
        public Set<String> getRoles() {
            return this.roles;
        }

        @Override
        public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
            return this.securityContext;
        }
    }
}

