/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.servlet;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.AuthenticationError;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.LogoutError;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.MultivaluedHashMap;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.ServerCookie;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.UriUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletHttpFacade
implements HttpFacade {
    protected final RequestFacade requestFacade = new RequestFacade();
    protected final ResponseFacade responseFacade = new ResponseFacade();
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected MultivaluedHashMap<String, String> queryParameters;

    public ServletHttpFacade(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public boolean isEnded() {
        return this.responseFacade.isEnded();
    }

    @Override
    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    @Override
    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        throw new IllegalStateException("Not supported yet");
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        protected boolean ended;

        protected ResponseFacade() {
        }

        @Override
        public void setStatus(int status) {
            ServletHttpFacade.this.response.setStatus(status);
        }

        @Override
        public void addHeader(String name, String value) {
            ServletHttpFacade.this.response.addHeader(name, value);
        }

        @Override
        public void setHeader(String name, String value) {
            ServletHttpFacade.this.response.setHeader(name, value);
        }

        @Override
        public void resetCookie(String name, String path) {
            this.setCookie(name, "", path, null, 0, false, false);
        }

        @Override
        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            StringBuffer cookieBuf = new StringBuffer();
            ServerCookie.appendCookieValue(cookieBuf, 1, name, value, path, domain, null, maxAge, secure, httpOnly, null);
            String cookie = cookieBuf.toString();
            ServletHttpFacade.this.response.addHeader("Set-Cookie", cookie);
        }

        @Override
        public OutputStream getOutputStream() {
            try {
                return ServletHttpFacade.this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void sendError(int code) {
            try {
                ServletHttpFacade.this.response.sendError(code);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void sendError(int code, String message) {
            try {
                ServletHttpFacade.this.response.sendError(code, message);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void end() {
            this.ended = true;
        }

        public boolean isEnded() {
            return this.ended;
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        private InputStream inputStream;

        protected RequestFacade() {
        }

        @Override
        public String getMethod() {
            return ServletHttpFacade.this.request.getMethod();
        }

        @Override
        public String getURI() {
            StringBuffer buf = ServletHttpFacade.this.request.getRequestURL();
            if (ServletHttpFacade.this.request.getQueryString() != null) {
                buf.append('?').append(ServletHttpFacade.this.request.getQueryString());
            }
            return buf.toString();
        }

        @Override
        public String getRelativePath() {
            String contextPath;
            String uri = ServletHttpFacade.this.request.getRequestURI();
            String servletPath = uri.substring(uri.indexOf(contextPath = ServletHttpFacade.this.request.getContextPath()) + contextPath.length());
            if ("".equals(servletPath)) {
                servletPath = "/";
            }
            return servletPath;
        }

        @Override
        public boolean isSecure() {
            return ServletHttpFacade.this.request.isSecure();
        }

        @Override
        public String getFirstParam(String param) {
            return ServletHttpFacade.this.request.getParameter(param);
        }

        @Override
        public String getQueryParamValue(String param) {
            if (ServletHttpFacade.this.queryParameters == null) {
                ServletHttpFacade.this.queryParameters = UriUtils.decodeQueryString(ServletHttpFacade.this.request.getQueryString());
            }
            return ServletHttpFacade.this.queryParameters.getFirst(param);
        }

        public MultivaluedHashMap<String, String> getQueryParameters() {
            if (ServletHttpFacade.this.queryParameters == null) {
                ServletHttpFacade.this.queryParameters = UriUtils.decodeQueryString(ServletHttpFacade.this.request.getQueryString());
            }
            return ServletHttpFacade.this.queryParameters;
        }

        @Override
        public HttpFacade.Cookie getCookie(String cookieName) {
            if (ServletHttpFacade.this.request.getCookies() == null) {
                return null;
            }
            Cookie cookie = null;
            for (Cookie c : ServletHttpFacade.this.request.getCookies()) {
                if (!c.getName().equals(cookieName)) continue;
                cookie = c;
                break;
            }
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        @Override
        public String getHeader(String name) {
            return ServletHttpFacade.this.request.getHeader(name);
        }

        @Override
        public List<String> getHeaders(String name) {
            Enumeration values = ServletHttpFacade.this.request.getHeaders(name);
            LinkedList<String> list = new LinkedList<String>();
            while (values.hasMoreElements()) {
                list.add((String)values.nextElement());
            }
            return list;
        }

        @Override
        public InputStream getInputStream() {
            return this.getInputStream(false);
        }

        @Override
        public InputStream getInputStream(boolean buffered) {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (buffered) {
                try {
                    this.inputStream = new BufferedInputStream((InputStream)ServletHttpFacade.this.request.getInputStream());
                    return this.inputStream;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return ServletHttpFacade.this.request.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getRemoteAddr() {
            return ServletHttpFacade.this.request.getRemoteAddr();
        }

        @Override
        public void setError(AuthenticationError error) {
            ServletHttpFacade.this.request.setAttribute(AuthenticationError.class.getName(), (Object)error);
        }

        @Override
        public void setError(LogoutError error) {
            ServletHttpFacade.this.request.setAttribute(LogoutError.class.getName(), (Object)error);
        }
    }
}

