/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util;

import java.util.Random;

public class Retry {
    public static int execute(Runnable runnable, int attemptsCount, long intervalMillis) {
        int iteration = 0;
        while (true) {
            try {
                runnable.run();
                return iteration;
            }
            catch (AssertionError | RuntimeException e) {
                ++iteration;
                if (--attemptsCount > 0) {
                    try {
                        if (intervalMillis <= 0L) continue;
                        Thread.sleep(intervalMillis);
                    }
                    catch (InterruptedException ie) {
                        ie.addSuppressed((Throwable)e);
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static int executeWithBackoff(AdvancedRunnable runnable, int attemptsCount, int intervalBaseMillis) {
        return Retry.executeWithBackoff(runnable, null, attemptsCount, intervalBaseMillis);
    }

    public static int executeWithBackoff(AdvancedRunnable runnable, ThrowableCallback throwableCallback, int attemptsCount, int intervalBaseMillis) {
        int iteration = 0;
        while (true) {
            try {
                runnable.run(iteration);
                return iteration;
            }
            catch (AssertionError | RuntimeException e) {
                if (throwableCallback != null) {
                    throwableCallback.handleThrowable(iteration, (Throwable)e);
                }
                ++iteration;
                if (--attemptsCount > 0) {
                    try {
                        if (intervalBaseMillis <= 0) continue;
                        int delay = Retry.computeBackoffInterval(intervalBaseMillis, iteration);
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ie) {
                        ie.addSuppressed((Throwable)e);
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private static int computeBackoffInterval(int base, int iteration) {
        int iterationBase = base * (int)Math.pow(2.0, iteration);
        return new Random().nextInt(iterationBase);
    }

    public static <T> T call(Supplier<T> supplier, int attemptsCount, long intervalMillis) {
        int iteration = 0;
        while (true) {
            try {
                return supplier.get(iteration);
            }
            catch (AssertionError | RuntimeException e) {
                ++iteration;
                if (--attemptsCount > 0) {
                    try {
                        if (intervalMillis <= 0L) continue;
                        Thread.sleep(intervalMillis);
                    }
                    catch (InterruptedException ie) {
                        ie.addSuppressed((Throwable)e);
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static interface Supplier<T> {
        public T get(int var1);
    }

    public static interface ThrowableCallback {
        public void handleThrowable(int var1, Throwable var2);
    }

    public static interface AdvancedRunnable {
        public void run(int var1);
    }
}

