/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.VerificationException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.JavaAlgorithm;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.KeyWrapper;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.SignatureVerifierContext;
import java.security.PublicKey;
import java.security.Signature;

public class AsymmetricSignatureVerifierContext
implements SignatureVerifierContext {
    private final KeyWrapper key;

    public AsymmetricSignatureVerifierContext(KeyWrapper key) {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        try {
            Signature verifier = Signature.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithm()));
            verifier.initVerify((PublicKey)this.key.getPublicKey());
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (Exception e) {
            throw new VerificationException("Signing failed", e);
        }
    }
}

