/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.JavaAlgorithm;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.KeyWrapper;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.SignatureException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.SignatureSignerContext;
import javax.crypto.Mac;

public class MacSignatureSignerContext
implements SignatureSignerContext {
    private final KeyWrapper key;

    public MacSignatureSignerContext(KeyWrapper key) throws SignatureException {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getHashAlgorithm() {
        return JavaAlgorithm.getJavaAlgorithmForHash(this.key.getAlgorithm());
    }

    @Override
    public byte[] sign(byte[] data) throws SignatureException {
        try {
            Mac mac = Mac.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithm()));
            mac.init(this.key.getSecretKey());
            mac.update(data);
            return mac.doFinal();
        }
        catch (Exception e) {
            throw new SignatureException("Signing failed", e);
        }
    }
}

