/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.VerificationException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.JavaAlgorithm;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.KeyWrapper;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.SignatureVerifierContext;
import java.security.MessageDigest;
import javax.crypto.Mac;

public class MacSignatureVerifierContext
implements SignatureVerifierContext {
    private final KeyWrapper key;

    public MacSignatureVerifierContext(KeyWrapper key) {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        try {
            Mac mac = Mac.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithm()));
            mac.init(this.key.getSecretKey());
            mac.update(data);
            byte[] verificationSignature = mac.doFinal();
            return MessageDigest.isEqual(verificationSignature, signature);
        }
        catch (Exception e) {
            throw new VerificationException("Signing failed", e);
        }
    }
}

