/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.Base64Url;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.KeyUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.PemUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.KeyUse;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk.ECPublicJWK;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk.JWK;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk.RSAPublicJWK;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public class JWKBuilder {
    public static final String DEFAULT_PUBLIC_KEY_USE = "sig";
    private String kid;
    private String algorithm;

    private JWKBuilder() {
    }

    public static JWKBuilder create() {
        return new JWKBuilder();
    }

    public JWKBuilder kid(String kid) {
        this.kid = kid;
        return this;
    }

    public JWKBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JWK rs256(PublicKey key) {
        this.algorithm("RS256");
        return this.rsa(key);
    }

    public JWK rsa(Key key) {
        return this.rsa(key, (X509Certificate)null);
    }

    public JWK rsa(Key key, X509Certificate certificate) {
        RSAPublicKey rsaKey = (RSAPublicKey)key;
        RSAPublicJWK k = new RSAPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId(key);
        k.setKeyId(kid);
        k.setKeyType("RSA");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(DEFAULT_PUBLIC_KEY_USE);
        k.setModulus(Base64Url.encode(JWKBuilder.toIntegerBytes(rsaKey.getModulus())));
        k.setPublicExponent(Base64Url.encode(JWKBuilder.toIntegerBytes(rsaKey.getPublicExponent())));
        if (certificate != null) {
            k.setX509CertificateChain(new String[]{PemUtils.encodeCertificate(certificate)});
        }
        return k;
    }

    public JWK rsa(Key key, KeyUse keyUse) {
        String keyUseString;
        JWK k = this.rsa(key);
        String string = keyUseString = keyUse == null ? DEFAULT_PUBLIC_KEY_USE : keyUse.getSpecName();
        if (KeyUse.ENC == keyUse) {
            keyUseString = "enc";
        }
        k.setPublicKeyUse(keyUseString);
        return k;
    }

    public JWK ec(Key key) {
        ECPublicKey ecKey = (ECPublicKey)key;
        ECPublicJWK k = new ECPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId(key);
        int fieldSize = ecKey.getParams().getCurve().getField().getFieldSize();
        BigInteger affineX = ecKey.getW().getAffineX();
        BigInteger affineY = ecKey.getW().getAffineY();
        k.setKeyId(kid);
        k.setKeyType("EC");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(DEFAULT_PUBLIC_KEY_USE);
        k.setCrv("P-" + fieldSize);
        k.setX(Base64Url.encode(JWKBuilder.toIntegerBytes(ecKey.getW().getAffineX())));
        k.setY(Base64Url.encode(JWKBuilder.toIntegerBytes(ecKey.getW().getAffineY())));
        return k;
    }

    private static byte[] toIntegerBytes(BigInteger bigInt) {
        int bitlen = bigInt.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInt.toByteArray();
        if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInt.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }
}

