/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.docker;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;

public class DockerAccess {
    public static final int ACCESS_TYPE = 0;
    public static final int REPOSITORY_NAME = 1;
    public static final int PERMISSIONS = 2;
    public static final String DECODE_ENCODING = "UTF-8";
    @JsonProperty(value="type")
    protected String type;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="actions")
    protected List<String> actions;

    public DockerAccess() {
    }

    public DockerAccess(String scopeParam) {
        if (scopeParam != null) {
            try {
                String unencoded = URLDecoder.decode(scopeParam, DECODE_ENCODING);
                String[] parts = unencoded.split(":");
                if (parts.length != 3) {
                    throw new IllegalArgumentException(String.format("Expecting input string to have %d parts delineated by a ':' character.  Found %d parts: %s", 3, parts.length, unencoded));
                }
                this.type = parts[0];
                this.name = parts[1];
                if (parts[2] != null) {
                    this.actions = Arrays.asList(parts[2].split(","));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Error attempting to decode scope parameter using encoding: UTF-8");
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public DockerAccess setType(String type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DockerAccess setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public DockerAccess setActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerAccess)) {
            return false;
        }
        DockerAccess that = (DockerAccess)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.actions != null ? this.actions.equals(that.actions) : that.actions == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DockerAccess{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", actions=" + this.actions + '}';
    }
}

