/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.json.StringListMapDeserializer;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.idm.authorization.ScopeRepresentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResourceRepresentation {
    @JsonProperty(value="_id")
    private String id;
    private String name;
    @JsonProperty(value="uris")
    private Set<String> uris;
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="scopes")
    private Set<ScopeRepresentation> scopes;
    @JsonProperty(value="icon_uri")
    private String iconUri;
    private ResourceOwnerRepresentation owner;
    private Boolean ownerManagedAccess;
    private String displayName;
    @JsonDeserialize(using=StringListMapDeserializer.class)
    private Map<String, List<String>> attributes;

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, Set<String> uris, String type, String iconUri) {
        this.name = name;
        this.scopes = scopes;
        this.uris = uris;
        this.type = type;
        this.iconUri = iconUri;
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type, String iconUri) {
        this(name, scopes, Collections.singleton(uri), type, iconUri);
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, Set<String> uris, String type) {
        this(name, scopes, uris, type, null);
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type) {
        this(name, scopes, Collections.singleton(uri), type, null);
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes) {
        this(name, scopes, (Set<String>)null, null, null);
    }

    public ResourceRepresentation(String name, String ... scopes) {
        this.name = name;
        this.scopes = new HashSet<ScopeRepresentation>();
        for (String s : scopes) {
            ScopeRepresentation rep = new ScopeRepresentation(s);
            this.scopes.add(rep);
        }
    }

    public ResourceRepresentation() {
        this(null, null, (Set<String>)null, null, null);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Deprecated
    @JsonIgnore
    public String getUri() {
        if (this.uris == null || this.uris.isEmpty()) {
            return null;
        }
        return this.uris.iterator().next();
    }

    public Set<String> getUris() {
        return this.uris;
    }

    public String getType() {
        return this.type;
    }

    public Set<ScopeRepresentation> getScopes() {
        if (this.scopes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.scopes);
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Deprecated
    @JsonSetter(value="uri")
    public void setUri(String uri) {
        if (uri != null && !"".equalsIgnoreCase(uri.trim())) {
            this.uris = Collections.singleton(uri);
        }
    }

    public void setUris(Set<String> uris) {
        if (uris != null) {
            HashSet<String> resultSet = new HashSet<String>();
            for (String uri : uris) {
                if (uri == null || "".equalsIgnoreCase(uri.trim())) continue;
                resultSet.add(uri);
            }
            this.uris = resultSet;
        }
    }

    public void setType(String type) {
        if (type != null && !"".equalsIgnoreCase(type.trim())) {
            this.type = type;
        }
    }

    public void setScopes(Set<ScopeRepresentation> scopes) {
        this.scopes = scopes;
    }

    @JsonSetter(value="resource_scopes")
    private void setScopesUma(Set<ScopeRepresentation> scopes) {
        this.scopes = scopes;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceOwnerRepresentation getOwner() {
        return this.owner;
    }

    @JsonProperty
    public void setOwner(ResourceOwnerRepresentation owner) {
        this.owner = owner;
    }

    @JsonIgnore
    public void setOwner(String ownerId) {
        if (ownerId == null) {
            this.owner = null;
            return;
        }
        if (this.owner == null) {
            this.owner = new ResourceOwnerRepresentation();
        }
        this.owner.setId(ownerId);
    }

    public Boolean getOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    public void setOwnerManagedAccess(Boolean ownerManagedAccess) {
        this.ownerManagedAccess = ownerManagedAccess;
    }

    public void addScope(String ... scopeNames) {
        if (this.scopes == null) {
            this.scopes = new HashSet<ScopeRepresentation>();
        }
        for (String scopeName : scopeNames) {
            this.scopes.add(new ScopeRepresentation(scopeName));
        }
    }

    public void addScope(ScopeRepresentation scope) {
        if (this.scopes == null) {
            this.scopes = new HashSet<ScopeRepresentation>();
        }
        this.scopes.add(scope);
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRepresentation scope = (ResourceRepresentation)o;
        return Objects.equals(this.getName(), scope.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

