/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.info;

public class MemoryInfoRepresentation {
    protected long total;
    protected String totalFormated;
    protected long used;
    protected String usedFormated;
    protected long free;
    protected long freePercentage;
    protected String freeFormated;

    public static MemoryInfoRepresentation create() {
        MemoryInfoRepresentation rep = new MemoryInfoRepresentation();
        Runtime runtime = Runtime.getRuntime();
        rep.total = runtime.maxMemory();
        rep.totalFormated = MemoryInfoRepresentation.formatMemory(rep.total);
        rep.used = runtime.totalMemory() - runtime.freeMemory();
        rep.usedFormated = MemoryInfoRepresentation.formatMemory(rep.used);
        rep.free = rep.total - rep.used;
        rep.freeFormated = MemoryInfoRepresentation.formatMemory(rep.free);
        rep.freePercentage = rep.free * 100L / rep.total;
        return rep;
    }

    public long getTotal() {
        return this.total;
    }

    public String getTotalFormated() {
        return this.totalFormated;
    }

    public long getFree() {
        return this.free;
    }

    public String getFreeFormated() {
        return this.freeFormated;
    }

    public long getUsed() {
        return this.used;
    }

    public String getUsedFormated() {
        return this.usedFormated;
    }

    public long getFreePercentage() {
        return this.freePercentage;
    }

    private static String formatMemory(long bytes) {
        if (bytes > 0x100000L) {
            return bytes / 0x100000L + " MB";
        }
        if (bytes > 1024L) {
            return bytes / 1024L + " kB";
        }
        return bytes + " B";
    }
}

