/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.util;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.KeyUse;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.crypto.KeyWrapper;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk.JSONWebKeySet;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk.JWK;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jwk.JWKParser;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class JWKSUtils {
    public static Map<String, PublicKey> getKeysForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        HashMap<String, PublicKey> result = new HashMap<String, PublicKey>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!jwk.getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            result.put(jwk.getKeyId(), parser.toPublicKey());
        }
        return result;
    }

    public static Map<String, KeyWrapper> getKeyWrappersForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        HashMap<String, KeyWrapper> result = new HashMap<String, KeyWrapper>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!jwk.getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setKid(jwk.getKeyId());
            keyWrapper.setAlgorithm(jwk.getAlgorithm());
            keyWrapper.setType(jwk.getKeyType());
            keyWrapper.setUse(JWKSUtils.getKeyUse(jwk.getPublicKeyUse()));
            keyWrapper.setPublicKey(parser.toPublicKey());
            result.put(keyWrapper.getKid(), keyWrapper);
        }
        return result;
    }

    private static KeyUse getKeyUse(String keyUse) {
        switch (keyUse) {
            case "sig": {
                return KeyUse.SIG;
            }
            case "enc": {
                return KeyUse.ENC;
            }
        }
        return null;
    }

    public static JWK getKeyForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!parser.getJwk().getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            return jwk;
        }
        return null;
    }
}

