/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.StringPropertyReplacer;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.SystemEnvProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;

public class SystemPropertiesJsonParserFactory
extends MappingJsonFactory {
    private static final Properties properties = new SystemEnvProperties();

    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        JsonParser delegate = super._createParser(in, ctxt);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        JsonParser delegate = super._createParser(r, ctxt);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        JsonParser delegate = super._createParser(data, offset, len, ctxt, recyclable);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        JsonParser delegate = super._createParser(data, offset, len, ctxt);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    public static class SystemPropertiesAwareJsonParser
    extends JsonParserDelegate {
        public SystemPropertiesAwareJsonParser(JsonParser d) {
            super(d);
        }

        public String getText() throws IOException {
            String orig = super.getText();
            return StringPropertyReplacer.replaceProperties(orig, properties);
        }
    }
}

