/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.apikey;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.security.core.AuthenticationContext;
import io.gravitee.gateway.security.core.AuthenticationHandler;
import io.gravitee.gateway.security.core.AuthenticationPolicy;
import io.gravitee.reporter.api.http.SecurityType;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class ApiKeyAuthenticationHandler
implements AuthenticationHandler,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ApiKeyAuthenticationHandler.class);
    static final String API_KEY_POLICY = "api-key";
    private static final String APIKEY_CONTEXT_ATTRIBUTE = "apikey";
    private static final List<AuthenticationPolicy> POLICIES = Collections.singletonList(() -> "api-key");
    @Value(value="${policy.api-key.header:X-Gravitee-Api-Key}")
    private String apiKeyHeader = "X-Gravitee-Api-Key";
    @Value(value="${policy.api-key.param:api-key}")
    private String apiKeyQueryParameter = "api-key";
    @Autowired
    private ApplicationContext applicationContext;
    private ApiKeyRepository apiKeyRepository;

    public void afterPropertiesSet() {
        this.apiKeyRepository = (ApiKeyRepository)this.applicationContext.getBean(ApiKeyRepository.class);
    }

    public boolean canHandle(AuthenticationContext context) {
        String apiKey = this.readApiKey(context.request());
        if (apiKey == null) {
            return false;
        }
        if (this.apiKeyRepository != null && context.get(APIKEY_CONTEXT_ATTRIBUTE) == null) {
            try {
                Optional optApiKey = this.apiKeyRepository.findById(apiKey);
                if (optApiKey.isPresent()) {
                    context.request().metrics().setSecurityType(SecurityType.API_KEY);
                    context.request().metrics().setSecurityToken(apiKey);
                }
                context.set(APIKEY_CONTEXT_ATTRIBUTE, (Object)optApiKey);
            }
            catch (TechnicalException technicalException) {
                // empty catch block
            }
        }
        return true;
    }

    public String name() {
        return "api_key";
    }

    public int order() {
        return 500;
    }

    public List<AuthenticationPolicy> handle(ExecutionContext executionContext) {
        return POLICIES;
    }

    private String readApiKey(Request request) {
        this.logger.debug("Looking for an API Key from request header: {}", (Object)this.apiKeyHeader);
        String apiKey = request.headers().getFirst(this.apiKeyHeader);
        if (apiKey == null || apiKey.isEmpty()) {
            this.logger.debug("Looking for an API Key from request query parameter: {}", (Object)this.apiKeyQueryParameter);
            apiKey = (String)request.parameters().getFirst((Object)this.apiKeyQueryParameter);
        }
        return apiKey;
    }
}

