/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.ShutdownContext;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class StartupContext
implements Closeable {
    private static final Logger LOG = Logger.getLogger(StartupContext.class);
    private final Map<String, Object> values = new HashMap<String, Object>();
    private Object lastValue;
    private boolean lastValueSet = false;
    private final List<Runnable> shutdownTasks = new ArrayList<Runnable>();
    private final List<Runnable> lastShutdownTasks = new ArrayList<Runnable>();
    private final ShutdownContext shutdownContext = new ShutdownContext(){

        @Override
        public void addShutdownTask(Runnable runnable) {
            StartupContext.this.shutdownTasks.add(runnable);
        }

        @Override
        public void addLastShutdownTask(Runnable runnable) {
            StartupContext.this.lastShutdownTasks.add(runnable);
        }
    };

    public StartupContext() {
        this.values.put(ShutdownContext.class.getName(), this.shutdownContext);
    }

    public void putValue(String name, Object value) {
        this.values.put(name, value);
        this.lastValueSet = true;
        this.lastValue = value;
    }

    public Object getValue(String name) {
        return this.values.get(name);
    }

    public Object getLastValue() {
        return this.lastValue;
    }

    public boolean isLastValueSet() {
        return this.lastValueSet;
    }

    @Override
    public void close() {
        this.runAllInReverseOrder(this.shutdownTasks);
        this.shutdownTasks.clear();
        this.runAllInReverseOrder(this.lastShutdownTasks);
        this.lastShutdownTasks.clear();
    }

    private void runAllInReverseOrder(List<Runnable> tasks) {
        ArrayList<Runnable> toClose = new ArrayList<Runnable>(tasks);
        Collections.reverse(toClose);
        for (Runnable r : toClose) {
            try {
                r.run();
            }
            catch (Throwable e) {
                LOG.error((Object)"Running a shutdown task failed", e);
            }
        }
    }
}

