/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.runtime.AnonymousIdentityProvider;
import io.quarkus.security.runtime.QuarkusIdentityProviderManagerImpl;
import java.util.concurrent.Executor;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@ApplicationScoped
public class IdentityProviderManagerCreator {
    @Inject
    Instance<IdentityProvider<?>> identityProviders;
    @Inject
    Instance<SecurityIdentityAugmentor> augmentors;

    @Produces
    @ApplicationScoped
    public IdentityProviderManager ipm() {
        boolean customAnon = false;
        QuarkusIdentityProviderManagerImpl.Builder builder = QuarkusIdentityProviderManagerImpl.builder();
        for (IdentityProvider i : this.identityProviders) {
            builder.addProvider(i);
            if (i.getRequestType() != AnonymousAuthenticationRequest.class) continue;
            customAnon = true;
        }
        if (!customAnon) {
            builder.addProvider(new AnonymousIdentityProvider());
        }
        for (IdentityProvider i : this.augmentors) {
            builder.addSecurityIdentityAugmenter((SecurityIdentityAugmentor)i);
        }
        builder.setBlockingExecutor(new Executor(){

            @Override
            public void execute(Runnable command) {
                ExecutorRecorder.getCurrent().execute(command);
            }
        });
        return builder.build();
    }
}

