/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.connection;

import com.github.takezoe.scaladoc.Scaladoc;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.ExecutionMode;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.misc.AclDef;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.workflow.AtlasExportable;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.connection.ConnectionMetadata;
import io.smartdatalake.workflow.connection.DeltaLakeTableConnection$;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n * Connection information for DeltaLake tables\n *\n * @param id unique id of this connection\n * @param db hive db\n * @param pathPrefix schema, authority and base path for tables directory on hadoop\n * @param acl permissions for files created with this connection\n * @param metadata\n */")
@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0016-\u0001VB\u0001B\u0012\u0001\u0003\u0016\u0004%\te\u0012\u0005\t5\u0002\u0011\t\u0012)A\u0005\u0011\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005f\u0001\tE\t\u0015!\u0003^\u0011!1\u0007A!f\u0001\n\u0003a\u0006\u0002C4\u0001\u0005#\u0005\u000b\u0011B/\t\u0011!\u0004!Q3A\u0005\u0002%D\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006IA\u001b\u0005\tm\u0002\u0011)\u001a!C\u0001o\"A1\u0010\u0001B\tB\u0003%\u0001\u0010\u0003\u0005}\u0001\tU\r\u0011\"\u0011~\u0011%\t)\u0001\u0001B\tB\u0003%a\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003k\u0001\u0011\u0013!C\u0001\u0003oA\u0011\"!\u0014\u0001#\u0003%\t!a\u0014\t\u0013\u0005M\u0003!%A\u0005\u0002\u0005=\u0003\"CA+\u0001E\u0005I\u0011AA,\u0011%\tY\u0006AI\u0001\n\u0003\ti\u0006C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002d!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0003s\u0002\u0011\u0011!C\u0001\u0003wB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u0005E\u0005!!A\u0005B\u0005M\u0005\"CAQ\u0001\u0005\u0005I\u0011AAR\u0011%\t9\u000bAA\u0001\n\u0003\nI\u000bC\u0005\u0002,\u0002\t\t\u0011\"\u0011\u0002.\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011W\u0004\b\u0003+d\u0003\u0012AAl\r\u0019YC\u0006#\u0001\u0002Z\"9\u0011qA\u0010\u0005\u0002\u0005m\u0007bBAo?\u0011\u0005\u0013q\u001c\u0005\n\u0003{|\u0012\u0011!CA\u0003\u007fD\u0011B!\u0004 #\u0003%\t!a\u0016\t\u0013\t=q$%A\u0005\u0002\u0005u\u0003\"\u0003B\t?E\u0005I\u0011AA2\u0011%\u0011\u0019bHA\u0001\n\u0003\u0013)\u0002C\u0005\u0003$}\t\n\u0011\"\u0001\u0002X!I!QE\u0010\u0012\u0002\u0013\u0005\u0011Q\f\u0005\n\u0005Oy\u0012\u0013!C\u0001\u0003GB\u0011B!\u000b \u0003\u0003%IAa\u000b\u00031\u0011+G\u000e^1MC.,G+\u00192mK\u000e{gN\\3di&|gN\u0003\u0002.]\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005=\u0002\u0014\u0001C<pe.4Gn\\<\u000b\u0005E\u0012\u0014!D:nCJ$H-\u0019;bY\u0006\\WMC\u00014\u0003\tIwn\u0001\u0001\u0014\u000b\u00011D\bQ\"\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\tid(D\u0001-\u0013\tyDF\u0001\u0006D_:tWm\u0019;j_:\u0004\"aN!\n\u0005\tC$a\u0002)s_\u0012,8\r\u001e\t\u0003o\u0011K!!\u0012\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0005%$W#\u0001%\u0011\u0005%;fB\u0001&U\u001d\tY%K\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q\nN\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!!\r\u001a\n\u0005M\u0003\u0014AB2p]\u001aLw-\u0003\u0002V-\u0006y1\u000b\u001a7D_:4\u0017nZ(cU\u0016\u001cGO\u0003\u0002Ta%\u0011\u0001,\u0017\u0002\r\u0007>tg.Z2uS>t\u0017\n\u001a\u0006\u0003+Z\u000b1!\u001b3!\u0003\t!'-F\u0001^!\tq&M\u0004\u0002`AB\u0011Q\nO\u0005\u0003Cb\na\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011\rO\u0001\u0004I\n\u0004\u0013A\u00039bi\"\u0004&/\u001a4jq\u0006Y\u0001/\u0019;i!J,g-\u001b=!\u0003\r\t7\r\\\u000b\u0002UB\u0019qg[7\n\u00051D$AB(qi&|g\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u0006!Q.[:d\u0015\t\u0011\b'\u0001\u0003vi&d\u0017B\u0001;p\u0005\u0019\t5\r\u001c#fM\u0006!\u0011m\u00197!\u0003i\u0019\u0007.Z2l\t\u0016dG/\u0019'bW\u0016\u001c\u0006/\u0019:l\u001fB$\u0018n\u001c8t+\u0005A\bCA\u001cz\u0013\tQ\bHA\u0004C_>dW-\u00198\u00027\rDWmY6EK2$\u0018\rT1lKN\u0003\u0018M]6PaRLwN\\:!\u0003!iW\r^1eCR\fW#\u0001@\u0011\u0007]Zw\u0010E\u0002>\u0003\u0003I1!a\u0001-\u0005I\u0019uN\u001c8fGRLwN\\'fi\u0006$\u0017\r^1\u0002\u00135,G/\u00193bi\u0006\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b\u0002\f\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0011\u0005u\u0002\u0001\"\u0002$\u000e\u0001\u0004A\u0005\"B.\u000e\u0001\u0004i\u0006\"\u00024\u000e\u0001\u0004i\u0006b\u00025\u000e!\u0003\u0005\rA\u001b\u0005\bm6\u0001\n\u00111\u0001y\u0011\u001daX\u0002%AA\u0002y\fqAZ1di>\u0014\u00180\u0006\u0002\u0002\u001eA)\u0011qDA\u0011y5\ta+C\u0002\u0002$Y\u0013\u0011C\u0012:p[\u000e{gNZ5h\r\u0006\u001cGo\u001c:z\u0003\u0011\u0019w\u000e]=\u0015\u001d\u0005-\u0011\u0011FA\u0016\u0003[\ty#!\r\u00024!9ai\u0004I\u0001\u0002\u0004A\u0005bB.\u0010!\u0003\u0005\r!\u0018\u0005\bM>\u0001\n\u00111\u0001^\u0011\u001dAw\u0002%AA\u0002)DqA^\b\u0011\u0002\u0003\u0007\u0001\u0010C\u0004}\u001fA\u0005\t\u0019\u0001@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\b\u0016\u0004\u0011\u0006m2FAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0003(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u000b\u0016\u0004;\u0006m\u0012AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tIFK\u0002k\u0003w\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002`)\u001a\u00010a\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\r\u0016\u0004}\u0006m\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014\u0001\u00027b]\u001eT!!!\u001e\u0002\t)\fg/Y\u0005\u0004G\u0006=\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA?!\r9\u0014qP\u0005\u0004\u0003\u0003C$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAD\u0003\u001b\u00032aNAE\u0013\r\tY\t\u000f\u0002\u0004\u0003:L\b\"CAH1\u0005\u0005\t\u0019AA?\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0007\u0003/\u000bi*a\"\u000e\u0005\u0005e%bAANq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0015\u0011\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002y\u0003KC\u0011\"a$\u001b\u0003\u0003\u0005\r!a\"\u0002\u0011!\f7\u000f[\"pI\u0016$\"!! \u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001b\u0002\r\u0015\fX/\u00197t)\rA\u00181\u0017\u0005\n\u0003\u001fk\u0012\u0011!a\u0001\u0003\u000fCs\u0001AA\\\u0003\u001f\f\t\u000e\u0005\u0003\u0002:\u0006-WBAA^\u0015\u0011\ti,a0\u0002\u0011M\u001c\u0017\r\\1e_\u000eTA!!1\u0002D\u00069A/Y6fu>,'\u0002BAc\u0003\u000f\faaZ5uQV\u0014'BAAe\u0003\r\u0019w.\\\u0005\u0005\u0003\u001b\fYL\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\t\t\u0019.\u0001B!_)R#\u0002\t\u0016!\u0007>tg.Z2uS>t\u0007%\u001b8g_Jl\u0017\r^5p]\u00022wN\u001d\u0011EK2$\u0018\rT1lK\u0002\"\u0018M\u00197fg*\u0001#F\u0003\u0011+A\u0001\u0003\u0018M]1nA%$\u0007%\u001e8jcV,\u0007%\u001b3!_\u001a\u0004C\u000f[5tA\r|gN\\3di&|gN\u0003\u0011+A\u0001\u0003\u0018M]1nA\u0011\u0014\u0007\u0005[5wK\u0002\"'M\u0003\u0011+A\u0001\u0003\u0018M]1nAA\fG\u000f\u001b)sK\u001aL\u0007\u0010I:dQ\u0016l\u0017\r\f\u0011bkRDwN]5us\u0002\ng\u000e\u001a\u0011cCN,\u0007\u0005]1uQ\u00022wN\u001d\u0011uC\ndWm\u001d\u0011eSJ,7\r^8ss\u0002zg\u000e\t5bI>|\u0007O\u0003\u0011+A\u0001\u0003\u0018M]1nA\u0005\u001cG\u000e\t9fe6L7o]5p]N\u0004cm\u001c:!M&dWm\u001d\u0011de\u0016\fG/\u001a3!o&$\b\u000e\t;iSN\u00043m\u001c8oK\u000e$\u0018n\u001c8\u000bA)\u0002\u0003\t]1sC6\u0004S.\u001a;bI\u0006$\u0018M\u0003\u0011+_\u0005AB)\u001a7uC2\u000b7.\u001a+bE2,7i\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005uz2#B\u00107\u0003;\u0019ECAAl\u0003)1'o\\7D_:4\u0017n\u001a\u000b\u0005\u0003C\fi\u000f\u0006\u0003\u0002\f\u0005\r\bbBAsC\u0001\u000f\u0011q]\u0001\u0011S:\u001cH/\u00198dKJ+w-[:uef\u0004B!a\b\u0002j&\u0019\u00111\u001e,\u0003!%s7\u000f^1oG\u0016\u0014VmZ5tiJL\bBB*\"\u0001\u0004\ty\u000f\u0005\u0003\u0002r\u0006eXBAAz\u0015\r\u0019\u0016Q\u001f\u0006\u0005\u0003o\f9-\u0001\u0005usB,7/\u00194f\u0013\u0011\tY0a=\u0003\r\r{gNZ5h\u0003\u0015\t\u0007\u000f\u001d7z)9\tYA!\u0001\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017AQA\u0012\u0012A\u0002!CQa\u0017\u0012A\u0002uCQA\u001a\u0012A\u0002uCq\u0001\u001b\u0012\u0011\u0002\u0003\u0007!\u000eC\u0004wEA\u0005\t\u0019\u0001=\t\u000fq\u0014\u0003\u0013!a\u0001}\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u00122\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005/\u0011y\u0002\u0005\u00038W\ne\u0001#C\u001c\u0003\u001c!kVL\u001b=\u007f\u0013\r\u0011i\u0002\u000f\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\t\u0005b%!AA\u0002\u0005-\u0011a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0017!\u0011\tiGa\f\n\t\tE\u0012q\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class DeltaLakeTableConnection
implements Connection,
Product,
Serializable {
    private final String id;
    private final String db;
    private final String pathPrefix;
    private final Option<AclDef> acl;
    private final boolean checkDeltaLakeSparkOptions;
    private final Option<ConnectionMetadata> metadata;

    public static Option<ConnectionMetadata> $lessinit$greater$default$6() {
        return DeltaLakeTableConnection$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return DeltaLakeTableConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<AclDef> $lessinit$greater$default$4() {
        return DeltaLakeTableConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple6<SdlConfigObject.ConnectionId, String, String, Option<AclDef>, Object, Option<ConnectionMetadata>>> unapply(DeltaLakeTableConnection deltaLakeTableConnection) {
        return DeltaLakeTableConnection$.MODULE$.unapply(deltaLakeTableConnection);
    }

    public static Option<ConnectionMetadata> apply$default$6() {
        return DeltaLakeTableConnection$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return DeltaLakeTableConnection$.MODULE$.apply$default$5();
    }

    public static Option<AclDef> apply$default$4() {
        return DeltaLakeTableConnection$.MODULE$.apply$default$4();
    }

    public static DeltaLakeTableConnection apply(String string, String string2, String string3, Option<AclDef> option, boolean bl, Option<ConnectionMetadata> option2) {
        return DeltaLakeTableConnection$.MODULE$.apply(string, string2, string3, option, bl, option2);
    }

    public static DeltaLakeTableConnection fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return DeltaLakeTableConnection$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return DeltaLakeTableConnection$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return DeltaLakeTableConnection$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return DeltaLakeTableConnection$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return DeltaLakeTableConnection$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return DeltaLakeTableConnection$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return DeltaLakeTableConnection$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return DeltaLakeTableConnection$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return DeltaLakeTableConnection$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return DeltaLakeTableConnection$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return DeltaLakeTableConnection$.MODULE$.conditionReader();
    }

    public static ConfigReader<ExecutionMode> executionModeReader() {
        return DeltaLakeTableConnection$.MODULE$.executionModeReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return DeltaLakeTableConnection$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return DeltaLakeTableConnection$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return DeltaLakeTableConnection$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return DeltaLakeTableConnection$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return DeltaLakeTableConnection$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return DeltaLakeTableConnection$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return DeltaLakeTableConnection$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return DeltaLakeTableConnection$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] from a DDL string and creates a SparkSchema.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return DeltaLakeTableConnection$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[StructType]] values.\n   *\n   * This reader parses a [[StructType]] from a DDL string.\n   */")
    public static ConfigReader<StructType> structTypeReader() {
        return DeltaLakeTableConnection$.MODULE$.structTypeReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return DeltaLakeTableConnection$.MODULE$.sdlDefaultNaming();
    }

    public String toStringShort() {
        return Connection.toStringShort$((Connection)this);
    }

    public String atlasName() {
        return Connection.atlasName$((Connection)this);
    }

    public String atlasQualifiedName(String prefix) {
        return AtlasExportable.atlasQualifiedName$((AtlasExportable)this, (String)prefix);
    }

    public String id() {
        return this.id;
    }

    public String db() {
        return this.db;
    }

    public String pathPrefix() {
        return this.pathPrefix;
    }

    public Option<AclDef> acl() {
        return this.acl;
    }

    public boolean checkDeltaLakeSparkOptions() {
        return this.checkDeltaLakeSparkOptions;
    }

    public Option<ConnectionMetadata> metadata() {
        return this.metadata;
    }

    public FromConfigFactory<Connection> factory() {
        return DeltaLakeTableConnection$.MODULE$;
    }

    public DeltaLakeTableConnection copy(String id, String db, String pathPrefix, Option<AclDef> acl, boolean checkDeltaLakeSparkOptions, Option<ConnectionMetadata> metadata) {
        return new DeltaLakeTableConnection(id, db, pathPrefix, acl, checkDeltaLakeSparkOptions, metadata);
    }

    public String copy$default$1() {
        return this.id();
    }

    public String copy$default$2() {
        return this.db();
    }

    public String copy$default$3() {
        return this.pathPrefix();
    }

    public Option<AclDef> copy$default$4() {
        return this.acl();
    }

    public boolean copy$default$5() {
        return this.checkDeltaLakeSparkOptions();
    }

    public Option<ConnectionMetadata> copy$default$6() {
        return this.metadata();
    }

    public String productPrefix() {
        return "DeltaLakeTableConnection";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = new SdlConfigObject.ConnectionId(this.id());
                break;
            }
            case 1: {
                object = this.db();
                break;
            }
            case 2: {
                object = this.pathPrefix();
                break;
            }
            case 3: {
                object = this.acl();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.checkDeltaLakeSparkOptions());
                break;
            }
            case 5: {
                object = this.metadata();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeltaLakeTableConnection;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new SdlConfigObject.ConnectionId(this.id())));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.db()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathPrefix()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.acl()));
        n = Statics.mix((int)n, (int)(this.checkDeltaLakeSparkOptions() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.metadata()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeltaLakeTableConnection)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeltaLakeTableConnection deltaLakeTableConnection = (DeltaLakeTableConnection)x$1;
        String string = this.id();
        String string2 = deltaLakeTableConnection.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.db();
        String string4 = deltaLakeTableConnection.db();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.pathPrefix();
        String string6 = deltaLakeTableConnection.pathPrefix();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        Option<AclDef> option = this.acl();
        Option<AclDef> option2 = deltaLakeTableConnection.acl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.checkDeltaLakeSparkOptions() != deltaLakeTableConnection.checkDeltaLakeSparkOptions()) return false;
        Option<ConnectionMetadata> option3 = this.metadata();
        Option<ConnectionMetadata> option4 = deltaLakeTableConnection.metadata();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!deltaLakeTableConnection.canEqual(this)) return false;
        return true;
    }

    public DeltaLakeTableConnection(String id, String db, String pathPrefix, Option<AclDef> acl, boolean checkDeltaLakeSparkOptions, Option<ConnectionMetadata> metadata) {
        this.id = id;
        this.db = db;
        this.pathPrefix = pathPrefix;
        this.acl = acl;
        this.checkDeltaLakeSparkOptions = checkDeltaLakeSparkOptions;
        this.metadata = metadata;
        SdlConfigObject.$init$((SdlConfigObject)this);
        AtlasExportable.$init$((AtlasExportable)this);
        Connection.$init$((Connection)this);
        Product.$init$((Product)this);
    }
}

