/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.connection;

import com.github.takezoe.scaladoc.Scaladoc;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.ConfigurationException;
import io.smartdatalake.config.ConfigurationException$;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.ExecutionMode;
import io.smartdatalake.definitions.SASLSCRAMAuthMode;
import io.smartdatalake.definitions.SSLCertsAuthMode;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.workflow.AtlasExportable;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.connection.ConnectionMetadata;
import io.smartdatalake.workflow.connection.KafkaConnection$;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataobject.Expectation;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.spark.sql.confluent.ConfluentClient;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.Unit$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n * Connection information for kafka\n *\n * @param id             unique id of this connection\n * @param brokers        comma separated list of kafka bootstrap server incl. port, e.g. \"host1:9092,host2:9092:\n * @param schemaRegistry url of schema registry service, e.g. \"https://host2\"\n * @param options        Options for the Kafka stream reader (see https://spark.apache.org/docs/latest/structured-streaming-kafka-integration.html)\n * @param metadata\n */")
@ScalaSignature(bytes="\u0006\u0001\t=g\u0001\u0002\u001f>\u0001\u001aC\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0005\u0017\u0005\tW\u0002\u0011\t\u0012)A\u00053\"AA\u000e\u0001BK\u0002\u0013\u0005Q\u000e\u0003\u0005w\u0001\tE\t\u0015!\u0003o\u0011!9\bA!f\u0001\n\u0003A\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B=\t\u0011u\u0004!Q3A\u0005\u0002yD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B@\t\u0015\u0005\u001d\u0001A!f\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0012)A\u0005\u0003\u0017A!\"a\u0007\u0001\u0005+\u0007I\u0011IA\u000f\u0011)\t9\u0003\u0001B\tB\u0003%\u0011q\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011)\tY\u0004\u0001EC\u0002\u0013%\u0011Q\b\u0005\u000b\u0003G\u0002!\u0019!C\u0001\u0003\u0006\u0015\u0004\u0002CA;\u0001\u0001\u0006I!a\u001a\t\u0013\u0005]\u0004A1A\u0005\n\u0005\u0015\u0004\u0002CA=\u0001\u0001\u0006I!a\u001a\t\u0013\u0005m\u0004A1A\u0005\n\u0005\u0015\u0004\u0002CA?\u0001\u0001\u0006I!a\u001a\t\u0015\u0005}\u0004A1A\u0005\u0002}\n\t\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAB\u0011%\t\t\n\u0001b\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAK\u0011)\t)\u000b\u0001b\u0001\n\u0003y\u00141\u0013\u0005\t\u0003O\u0003\u0001\u0015!\u0003\u0002\u0016\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0003\u0004A\u0011IAb\u0011%\ti\rAA\u0001\n\u0003\ty\rC\u0005\u0002^\u0002\t\n\u0011\"\u0001\u0002`\"I\u0011Q\u001f\u0001\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0003w\u0004\u0011\u0013!C\u0001\u0003{D\u0011B!\u0001\u0001#\u0003%\tAa\u0001\t\u0013\t\u001d\u0001!%A\u0005\u0002\t%\u0001\"\u0003B\u0007\u0001E\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\u0002AA\u0001\n\u0003\n)\u0007C\u0005\u0003\u0016\u0001\t\t\u0011\"\u0001\u0003\u0018!I!q\u0004\u0001\u0002\u0002\u0013\u0005!\u0011\u0005\u0005\n\u0005[\u0001\u0011\u0011!C!\u0005_A\u0011B!\u000f\u0001\u0003\u0003%\tAa\u000f\t\u0013\t}\u0002!!A\u0005B\t\u0005\u0003\"\u0003B\"\u0001\u0005\u0005I\u0011\tB#\u0011%\u00119\u0005AA\u0001\n\u0003\u0012IeB\u0004\u0003nuB\tAa\u001c\u0007\rqj\u0004\u0012\u0001B9\u0011\u001d\tIC\fC\u0001\u0005gBqA!\u001e/\t\u0003\u00129\bC\u0005\u0003\u0016:\n\t\u0011\"!\u0003\u0018\"I!Q\u0015\u0018\u0012\u0002\u0013\u0005\u0011Q \u0005\n\u0005Os\u0013\u0013!C\u0001\u0005\u0007A\u0011B!+/#\u0003%\tA!\u0003\t\u0013\t-f&%A\u0005\u0002\t=\u0001\"\u0003BW]\u0005\u0005I\u0011\u0011BX\u0011%\u0011iLLI\u0001\n\u0003\ti\u0010C\u0005\u0003@:\n\n\u0011\"\u0001\u0003\u0004!I!\u0011\u0019\u0018\u0012\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005\u0007t\u0013\u0013!C\u0001\u0005\u001fA\u0011B!2/\u0003\u0003%IAa2\u0003\u001f-\u000bgm[1D_:tWm\u0019;j_:T!AP \u0002\u0015\r|gN\\3di&|gN\u0003\u0002A\u0003\u0006Aqo\u001c:lM2|wO\u0003\u0002C\u0007\u0006i1/\\1si\u0012\fG/\u00197bW\u0016T\u0011\u0001R\u0001\u0003S>\u001c\u0001aE\u0003\u0001\u000f6\u000bF\u000b\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001d>k\u0011!P\u0005\u0003!v\u0012!bQ8o]\u0016\u001cG/[8o!\tA%+\u0003\u0002T\u0013\n9\u0001K]8ek\u000e$\bC\u0001%V\u0013\t1\u0016J\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0002jIV\t\u0011\f\u0005\u0002[Q:\u00111,\u001a\b\u00039\u000et!!\u00182\u000f\u0005y\u000bW\"A0\u000b\u0005\u0001,\u0015A\u0002\u001fs_>$h(C\u0001E\u0013\t\u00115)\u0003\u0002e\u0003\u000611m\u001c8gS\u001eL!AZ4\u0002\u001fM#GnQ8oM&<wJ\u00196fGRT!\u0001Z!\n\u0005%T'\u0001D\"p]:,7\r^5p]&#'B\u00014h\u0003\rIG\rI\u0001\bEJ|7.\u001a:t+\u0005q\u0007CA8t\u001d\t\u0001\u0018\u000f\u0005\u0002_\u0013&\u0011!/S\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s\u0013\u0006A!M]8lKJ\u001c\b%\u0001\btG\",W.\u0019*fO&\u001cHO]=\u0016\u0003e\u00042\u0001\u0013>o\u0013\tY\u0018J\u0001\u0004PaRLwN\\\u0001\u0010g\u000eDW-\\1SK\u001eL7\u000f\u001e:zA\u00059q\u000e\u001d;j_:\u001cX#A@\u0011\u000b=\f\tA\u001c8\n\u0007\u0005\rQOA\u0002NCB\f\u0001b\u001c9uS>t7\u000fI\u0001\tCV$\b.T8eKV\u0011\u00111\u0002\t\u0005\u0011j\fi\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\"Q\u0001\fI\u00164\u0017N\\5uS>t7/\u0003\u0003\u0002\u0018\u0005E!\u0001C!vi\"lu\u000eZ3\u0002\u0013\u0005,H\u000f['pI\u0016\u0004\u0013\u0001C7fi\u0006$\u0017\r^1\u0016\u0005\u0005}\u0001\u0003\u0002%{\u0003C\u00012ATA\u0012\u0013\r\t)#\u0010\u0002\u0013\u0007>tg.Z2uS>tW*\u001a;bI\u0006$\u0018-A\u0005nKR\fG-\u0019;bA\u00051A(\u001b8jiz\"b\"!\f\u00020\u0005E\u00121GA\u001b\u0003o\tI\u0004\u0005\u0002O\u0001!)q+\u0004a\u00013\")A.\u0004a\u0001]\"9q/\u0004I\u0001\u0002\u0004I\bbB?\u000e!\u0003\u0005\ra \u0005\n\u0003\u000fi\u0001\u0013!a\u0001\u0003\u0017A\u0011\"a\u0007\u000e!\u0003\u0005\r!a\b\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002X5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0003bI6LgN\u0003\u0003\u0002J\u0005-\u0013aB2mS\u0016tGo\u001d\u0006\u0005\u0003\u001b\ny%A\u0003lC\u001a\\\u0017M\u0003\u0003\u0002R\u0005M\u0013AB1qC\u000eDWM\u0003\u0002\u0002V\u0005\u0019qN]4\n\t\u0005e\u00131\t\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fK\u0002\u000f\u0003;\u00022\u0001SA0\u0013\r\t\t'\u0013\u0002\niJ\fgn]5f]R\fqcS1gW\u0006\u001cuN\u001c4jO>\u0003H/[8o!J,g-\u001b=\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005Y\u0006twM\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\r!\u00181N\u0001\u0019\u0017\u000647.Y\"p]\u001aLwm\u00149uS>t\u0007K]3gSb\u0004\u0013\u0001G&bM.\f7k\u0015'TK\u000e,(/\u001b;z!J|Go\\2pY\u0006I2*\u00194lCN\u001bFjU3dkJLG/\u001f)s_R|7m\u001c7!\u0003qY\u0015MZ6b'\u0006\u001bFjU*M'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\fQdS1gW\u0006\u001c\u0016i\u0015'T'2\u001bVmY;sSRL\bK]8u_\u000e|G\u000eI\u0001\nCV$\b\u000e\u0015:paN,\"!a!\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fSA!!#\u0002p\u0005!Q\u000f^5m\u0013\u0011\ti)a\"\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0006bkRD\u0007K]8qg\u0002\n1\"Y;uQ>\u0003H/[8ogV\u0011\u0011Q\u0013\t\u0007\u0003/\u000b\tK\u001c8\u000e\u0005\u0005e%\u0002BAN\u0003;\u000bq!\\;uC\ndWMC\u0002\u0002 &\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019!!'\u0002\u0019\u0005,H\u000f[(qi&|gn\u001d\u0011\u0002\u0019M\u0004\u0018M]6PaRLwN\\:\u0002\u001bM\u0004\u0018M]6PaRLwN\\:!\u0003-!x\u000e]5d\u000bbL7\u000f^:\u0015\t\u00055\u00161\u0017\t\u0004\u0011\u0006=\u0016bAAY\u0013\n9!i\\8mK\u0006t\u0007BBA[7\u0001\u0007a.A\u0003u_BL7-\u0001\nuKN$8k\u00195f[\u0006\u0014VmZ5tiJLHCAA^!\rA\u0015QX\u0005\u0004\u0003\u007fK%\u0001B+oSR\fqAZ1di>\u0014\u00180\u0006\u0002\u0002FB)\u0011qYAe\u001b6\tq-C\u0002\u0002L\u001e\u0014\u0011C\u0012:p[\u000e{gNZ5h\r\u0006\u001cGo\u001c:z\u0003\u0011\u0019w\u000e]=\u0015\u001d\u00055\u0012\u0011[Aj\u0003+\f9.!7\u0002\\\"9qK\bI\u0001\u0002\u0004I\u0006b\u00027\u001f!\u0003\u0005\rA\u001c\u0005\boz\u0001\n\u00111\u0001z\u0011\u001dih\u0004%AA\u0002}D\u0011\"a\u0002\u001f!\u0003\u0005\r!a\u0003\t\u0013\u0005ma\u0004%AA\u0002\u0005}\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CT3!WArW\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\u0013Ut7\r[3dW\u0016$'bAAx\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003sT3A\\Ar\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a@+\u0007e\f\u0019/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0015!fA@\u0002d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B\u0006U\u0011\tY!a9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u0003\u0016\u0005\u0003?\t\u0019/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00053\u00012\u0001\u0013B\u000e\u0013\r\u0011i\"\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005G\u0011I\u0003E\u0002I\u0005KI1Aa\nJ\u0005\r\te.\u001f\u0005\n\u0005W9\u0013\u0011!a\u0001\u00053\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0019!\u0019\u0011\u0019D!\u000e\u0003$5\u0011\u0011QT\u0005\u0005\u0005o\tiJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAW\u0005{A\u0011Ba\u000b*\u0003\u0003\u0005\rAa\t\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0007\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001a\u0002\r\u0015\fX/\u00197t)\u0011\tiKa\u0013\t\u0013\t-B&!AA\u0002\t\r\u0002f\u0002\u0001\u0003P\t\u001d$\u0011\u000e\t\u0005\u0005#\u0012\u0019'\u0004\u0002\u0003T)!!Q\u000bB,\u0003!\u00198-\u00197bI>\u001c'\u0002\u0002B-\u00057\nq\u0001^1lKj|WM\u0003\u0003\u0003^\t}\u0013AB4ji\",(M\u0003\u0002\u0003b\u0005\u00191m\\7\n\t\t\u0015$1\u000b\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012!1N\u0001\u0004\u0016>R#F\u0003\u0011+A\r{gN\\3di&|g\u000eI5oM>\u0014X.\u0019;j_:\u0004cm\u001c:!W\u000647.\u0019\u0006!U)\u0001#\u0006\t!qCJ\fW\u000eI5eA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011v]&\fX/\u001a\u0011jI\u0002zg\r\t;iSN\u00043m\u001c8oK\u000e$\u0018n\u001c8\u000bA)\u0002\u0003\t]1sC6\u0004#M]8lKJ\u001c\b\u0005\t\u0011!A\u0001\u0002\u0003eY8n[\u0006\u00043/\u001a9be\u0006$X\r\u001a\u0011mSN$\be\u001c4!W\u000647.\u0019\u0011c_>$8\u000f\u001e:ba\u0002\u001aXM\u001d<fe\u0002Jgn\u00197/AA|'\u000f\u001e\u0017!K::g\u0006\t\u0012i_N$\u0018GO\u001d1sIb\u0003n\\:ueiJ\u0004'\u000f\u001a;\u0015\u0001R\u0003\u0005\u00119be\u0006l\u0007e]2iK6\f'+Z4jgR\u0014\u0018\u0010I;sY\u0002zg\rI:dQ\u0016l\u0017\r\t:fO&\u001cHO]=!g\u0016\u0014h/[2fY\u0001*gf\u001a\u0018!E!$H\u000f]:;_=Bwn\u001d;3E)\u0001#\u0006\t!qCJ\fW\u000eI8qi&|gn\u001d\u0011!A\u0001\u0002\u0003\u0005\t\u0011PaRLwN\\:!M>\u0014\b\u0005\u001e5fA-\u000bgm[1!gR\u0014X-Y7!e\u0016\fG-\u001a:!QM,W\r\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gR\u0014Xo\u0019;ve\u0016$Wf\u001d;sK\u0006l\u0017N\\4.W\u000647.Y\u0017j]R,wM]1uS>tg\u0006\u001b;nY&R\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011nKR\fG-\u0019;b\u0015\u0001Rs&A\bLC\u001a\\\u0017mQ8o]\u0016\u001cG/[8o!\tqefE\u0003/\u000f\u0006\u0015G\u000b\u0006\u0002\u0003p\u0005QaM]8n\u0007>tg-[4\u0015\t\te$Q\u0011\u000b\u0005\u0003[\u0011Y\bC\u0004\u0003~A\u0002\u001dAa \u0002!%t7\u000f^1oG\u0016\u0014VmZ5tiJL\b\u0003BAd\u0005\u0003K1Aa!h\u0005AIen\u001d;b]\u000e,'+Z4jgR\u0014\u0018\u0010\u0003\u0004ea\u0001\u0007!q\u0011\t\u0005\u0005\u0013\u0013\t*\u0004\u0002\u0003\f*\u0019AM!$\u000b\t\t=%qL\u0001\tif\u0004Xm]1gK&!!1\u0013BF\u0005\u0019\u0019uN\u001c4jO\u0006)\u0011\r\u001d9msRq\u0011Q\u0006BM\u00057\u0013iJa(\u0003\"\n\r\u0006\"B,2\u0001\u0004I\u0006\"\u000272\u0001\u0004q\u0007bB<2!\u0003\u0005\r!\u001f\u0005\b{F\u0002\n\u00111\u0001\u0000\u0011%\t9!\rI\u0001\u0002\u0004\tY\u0001C\u0005\u0002\u001cE\u0002\n\u00111\u0001\u0002 \u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0017B]!\u0011A%Pa-\u0011\u0017!\u0013),\u00178z\u007f\u0006-\u0011qD\u0005\u0004\u0005oK%A\u0002+va2,g\u0007C\u0005\u0003<Z\n\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!3\u0011\t\u0005%$1Z\u0005\u0005\u0005\u001b\fYG\u0001\u0004PE*,7\r\u001e")
public class KafkaConnection
implements Connection,
Product,
scala.Serializable {
    private transient AdminClient adminClient;
    private final String id;
    private final String brokers;
    private final Option<String> schemaRegistry;
    private final Map<String, String> options;
    private final Option<AuthMode> authMode;
    private final Option<ConnectionMetadata> metadata;
    private final String KafkaConfigOptionPrefix;
    private final String KafkaSSLSecurityProtocol;
    private final String KafkaSASLSSLSecurityProtocol;
    private final Properties authProps;
    private final scala.collection.mutable.Map<String, String> authOptions;
    private final scala.collection.mutable.Map<String, String> sparkOptions;
    private volatile transient boolean bitmap$trans$0;

    public static Option<ConnectionMetadata> $lessinit$greater$default$6() {
        return KafkaConnection$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<AuthMode> $lessinit$greater$default$5() {
        return KafkaConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static Map<String, String> $lessinit$greater$default$4() {
        return KafkaConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return KafkaConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple6<SdlConfigObject.ConnectionId, String, Option<String>, Map<String, String>, Option<AuthMode>, Option<ConnectionMetadata>>> unapply(KafkaConnection kafkaConnection) {
        return KafkaConnection$.MODULE$.unapply(kafkaConnection);
    }

    public static Option<ConnectionMetadata> apply$default$6() {
        return KafkaConnection$.MODULE$.apply$default$6();
    }

    public static Option<AuthMode> apply$default$5() {
        return KafkaConnection$.MODULE$.apply$default$5();
    }

    public static Map<String, String> apply$default$4() {
        return KafkaConnection$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return KafkaConnection$.MODULE$.apply$default$3();
    }

    public static KafkaConnection apply(String string, String string2, Option<String> option, Map<String, String> map, Option<AuthMode> option2, Option<ConnectionMetadata> option3) {
        return KafkaConnection$.MODULE$.apply(string, string2, option, map, option2, option3);
    }

    public static KafkaConnection fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return KafkaConnection$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return KafkaConnection$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return KafkaConnection$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return KafkaConnection$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return KafkaConnection$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return KafkaConnection$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return KafkaConnection$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return KafkaConnection$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return KafkaConnection$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return KafkaConnection$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return KafkaConnection$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return KafkaConnection$.MODULE$.conditionReader();
    }

    public static ConfigReader<ExecutionMode> executionModeReader() {
        return KafkaConnection$.MODULE$.executionModeReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return KafkaConnection$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return KafkaConnection$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return KafkaConnection$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return KafkaConnection$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return KafkaConnection$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return KafkaConnection$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return KafkaConnection$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return KafkaConnection$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return KafkaConnection$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[StructType]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   * See [[SchemaProviderType]] for available providers.\n   */")
    public static ConfigReader<StructType> structTypeReader() {
        return KafkaConnection$.MODULE$.structTypeReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return KafkaConnection$.MODULE$.sdlDefaultNaming();
    }

    public String toStringShort() {
        return Connection.toStringShort$((Connection)this);
    }

    public String atlasName() {
        return Connection.atlasName$((Connection)this);
    }

    public String atlasQualifiedName(String prefix) {
        return AtlasExportable.atlasQualifiedName$((AtlasExportable)this, (String)prefix);
    }

    public String id() {
        return this.id;
    }

    public String brokers() {
        return this.brokers;
    }

    public Option<String> schemaRegistry() {
        return this.schemaRegistry;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Option<AuthMode> authMode() {
        return this.authMode;
    }

    public Option<ConnectionMetadata> metadata() {
        return this.metadata;
    }

    private AdminClient adminClient$lzycompute() {
        KafkaConnection kafkaConnection = this;
        synchronized (kafkaConnection) {
            if (!this.bitmap$trans$0) {
                Properties props = new Properties();
                props.put("bootstrap.servers", this.brokers());
                ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.authProps()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = props.put(k, v);
                    return object;
                });
                this.adminClient = AdminClient.create((Properties)props);
                this.bitmap$trans$0 = true;
            }
        }
        return this.adminClient;
    }

    private AdminClient adminClient() {
        return !this.bitmap$trans$0 ? this.adminClient$lzycompute() : this.adminClient;
    }

    public String KafkaConfigOptionPrefix() {
        return this.KafkaConfigOptionPrefix;
    }

    private String KafkaSSLSecurityProtocol() {
        return this.KafkaSSLSecurityProtocol;
    }

    private String KafkaSASLSSLSecurityProtocol() {
        return this.KafkaSASLSSLSecurityProtocol;
    }

    public Properties authProps() {
        return this.authProps;
    }

    private scala.collection.mutable.Map<String, String> authOptions() {
        return this.authOptions;
    }

    public scala.collection.mutable.Map<String, String> sparkOptions() {
        return this.sparkOptions;
    }

    public boolean topicExists(String topic) {
        return ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((Set)this.adminClient().listTopics().names().get()).asScala()).contains((Object)topic);
    }

    public void testSchemaRegistry() {
        try {
            this.schemaRegistry().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                KafkaConnection.$anonfun$testSchemaRegistry$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new ConfigurationException(new StringBuilder(40).append("(").append(new SdlConfigObject.ConnectionId(this.id())).append(") Can not connect to schema registry (").append(this.schemaRegistry().get()).append(")").toString(), (Option)None$.MODULE$, (Throwable)e);
        }
    }

    public FromConfigFactory<Connection> factory() {
        return KafkaConnection$.MODULE$;
    }

    public KafkaConnection copy(String id, String brokers, Option<String> schemaRegistry, Map<String, String> options, Option<AuthMode> authMode, Option<ConnectionMetadata> metadata) {
        return new KafkaConnection(id, brokers, schemaRegistry, options, authMode, metadata);
    }

    public String copy$default$1() {
        return this.id();
    }

    public String copy$default$2() {
        return this.brokers();
    }

    public Option<String> copy$default$3() {
        return this.schemaRegistry();
    }

    public Map<String, String> copy$default$4() {
        return this.options();
    }

    public Option<AuthMode> copy$default$5() {
        return this.authMode();
    }

    public Option<ConnectionMetadata> copy$default$6() {
        return this.metadata();
    }

    public String productPrefix() {
        return "KafkaConnection";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = new SdlConfigObject.ConnectionId(this.id());
                break;
            }
            case 1: {
                object = this.brokers();
                break;
            }
            case 2: {
                object = this.schemaRegistry();
                break;
            }
            case 3: {
                object = this.options();
                break;
            }
            case 4: {
                object = this.authMode();
                break;
            }
            case 5: {
                object = this.metadata();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KafkaConnection;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KafkaConnection)) return false;
        boolean bl = true;
        if (!bl) return false;
        KafkaConnection kafkaConnection = (KafkaConnection)x$1;
        String string = this.id();
        String string2 = kafkaConnection.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.brokers();
        String string4 = kafkaConnection.brokers();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<String> option = this.schemaRegistry();
        Option<String> option2 = kafkaConnection.schemaRegistry();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = kafkaConnection.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<AuthMode> option3 = this.authMode();
        Option<AuthMode> option4 = kafkaConnection.authMode();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<ConnectionMetadata> option5 = this.metadata();
        Option<ConnectionMetadata> option6 = kafkaConnection.metadata();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!kafkaConnection.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$authProps$1() {
        return "JKS";
    }

    public static final /* synthetic */ String $anonfun$authProps$2() {
        return "JKS";
    }

    public static final /* synthetic */ String $anonfun$authProps$3() {
        return "JKS";
    }

    public static final /* synthetic */ Tuple2 $anonfun$authOptions$1(KafkaConnection $this, Tuple2 c) {
        return new Tuple2((Object)new StringBuilder(0).append($this.KafkaConfigOptionPrefix()).append(c._1()).toString(), c._2());
    }

    public static final /* synthetic */ void $anonfun$testSchemaRegistry$1(String x$1) {
        new ConfluentClient(x$1).test();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public KafkaConnection(String id, String brokers, Option<String> schemaRegistry, Map<String, String> options, Option<AuthMode> authMode, Option<ConnectionMetadata> metadata) {
        this.id = id;
        this.brokers = brokers;
        this.schemaRegistry = schemaRegistry;
        this.options = options;
        this.authMode = authMode;
        this.metadata = metadata;
        super();
        SdlConfigObject.$init$((SdlConfigObject)this);
        AtlasExportable.$init$((AtlasExportable)this);
        Connection.$init$((Connection)this);
        Product.$init$((Product)this);
        this.KafkaConfigOptionPrefix = "kafka.";
        this.KafkaSSLSecurityProtocol = "SSL";
        this.KafkaSASLSSLSecurityProtocol = "SASL_SSL";
        props = new Properties();
        var9_8 = false;
        var10_9 = null;
        var11_10 = authMode;
        if (!(var11_10 instanceof Some)) ** GOTO lbl-1000
        var9_8 = true;
        var10_9 = (Some)var11_10;
        m = (AuthMode)var10_9.value();
        if (m instanceof SSLCertsAuthMode) {
            var13_12 = (SSLCertsAuthMode)m;
            props.put("security.protocol", this.KafkaSSLSecurityProtocol());
            props.put("ssl.keystore.location", var13_12.keystorePath());
            props.put("ssl.keystore.password", var13_12.keystorePass());
            props.put("ssl.keystore.type", var13_12.keystoreType().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$authProps$1(), ()Ljava/lang/String;)()));
            props.put("ssl.truststore.location", var13_12.truststorePath());
            props.put("ssl.truststore.password", var13_12.truststorePass());
            var7_13 /* !! */  = props.put("ssl.truststore.type", var13_12.truststoreType().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$authProps$2(), ()Ljava/lang/String;)()));
        } else if (var9_8 && (m = (AuthMode)var10_9.value()) instanceof SASLSCRAMAuthMode) {
            var15_15 = (SASLSCRAMAuthMode)m;
            props.put("security.protocol", this.KafkaSASLSSLSecurityProtocol());
            props.put("sasl.mechanism", var15_15.sslMechanism());
            props.put("sasl.jaas.config", new StringBuilder(89).append("org.apache.kafka.common.security.scram.ScramLoginModule required username=\"").append(var15_15.username()).append("\" password=\"").append(var15_15.password()).append("\";").toString());
            props.put("ssl.truststore.location", var15_15.truststorePath());
            props.put("ssl.truststore.password", var15_15.truststorePass());
            var7_13 /* !! */  = props.put("ssl.truststore.type", var15_15.truststoreType().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$authProps$3(), ()Ljava/lang/String;)()));
        } else {
            if (var9_8) {
                m = (AuthMode)var10_9.value();
                throw new ConfigurationException(new StringBuilder(22).append(m.getClass().getSimpleName()).append(" is not supported for ").append(this.getClass().getSimpleName()).toString(), ConfigurationException$.MODULE$.apply$default$2(), ConfigurationException$.MODULE$.apply$default$3());
            }
            if (None$.MODULE$.equals(var11_10)) {
                var7_13 /* !! */  = Unit$.MODULE$;
            } else {
                throw new MatchError(var11_10);
            }
        }
        this.authProps = props;
        this.authOptions = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.authProps()).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$authOptions$1(io.smartdatalake.workflow.connection.KafkaConnection scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((KafkaConnection)this), Map$.MODULE$.canBuildFrom());
        this.sparkOptions = this.authOptions().$plus$plus(options).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(17).append(this.KafkaConfigOptionPrefix()).append("bootstrap.servers").toString()), (Object)brokers));
    }
}

