/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.dataobject;

import com.github.takezoe.scaladoc.Scaladoc;
import io.smartdatalake.workflow.dataobject.TopicPartitionOffsets$;
import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n * Offsets to process per topic partition\n * Note: endOffset is exclusive\n */")
@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001\u0002\u0013&\t:B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005{!A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005S\u0001\tE\t\u0015!\u0003M\u0011!\u0019\u0006A!f\u0001\n\u0003Y\u0005\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u000bU\u0003A\u0011\u0001,\t\u000fq\u0003!\u0019!C\u0005;\"1\u0011\r\u0001Q\u0001\nyCqA\u0019\u0001C\u0002\u0013%Q\f\u0003\u0004d\u0001\u0001\u0006IA\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u000b\u0001\t\u0003\t\u0019\u0002C\u0004\u0002.\u0001!I!a\f\t\u0013\u0005u\u0002!!A\u0005\u0002\u0005}\u0002\"CA$\u0001E\u0005I\u0011AA%\u0011%\ty\u0006AI\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002b!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\t\u0003s\u0002\u0011\u0011!C\u0001;\"I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005\u0015\u0006!!A\u0005B\u0005\u001d\u0006\"CAU\u0001\u0005\u0005I\u0011IAV\u0011%\ti\u000bAA\u0001\n\u0003\nykB\u0005\u0002:\u0016\n\t\u0011#\u0003\u0002<\u001aAA%JA\u0001\u0012\u0013\ti\f\u0003\u0004V=\u0011\u0005\u00111\u001a\u0005\n\u0003Ss\u0012\u0011!C#\u0003WC\u0011\"!4\u001f\u0003\u0003%\t)a4\t\u0013\u0005]g$!A\u0005\u0002\u0006e\u0007\"CAt=\u0005\u0005I\u0011BAu\u0005U!v\u000e]5d!\u0006\u0014H/\u001b;j_:|eMZ:fiNT!AJ\u0014\u0002\u0015\u0011\fG/Y8cU\u0016\u001cGO\u0003\u0002)S\u0005Aqo\u001c:lM2|wO\u0003\u0002+W\u0005i1/\\1si\u0012\fG/\u00197bW\u0016T\u0011\u0001L\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001_UB\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00021m%\u0011q'\r\u0002\b!J|G-^2u!\t\u0001\u0014(\u0003\u0002;c\ta1+\u001a:jC2L'0\u00192mK\u0006qAo\u001c9jGB\u000b'\u000f^5uS>tW#A\u001f\u0011\u0005y:U\"A \u000b\u0005\u0001\u000b\u0015AB2p[6|gN\u0003\u0002C\u0007\u0006)1.\u00194lC*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tAuH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n1b\u001d;beR|eMZ:fiV\tA\nE\u00021\u001b>K!AT\u0019\u0003\r=\u0003H/[8o!\t\u0001\u0004+\u0003\u0002Rc\t!Aj\u001c8h\u00031\u0019H/\u0019:u\u001f\u001a47/\u001a;!\u0003%)g\u000eZ(gMN,G/\u0001\u0006f]\u0012|eMZ:fi\u0002\na\u0001P5oSRtD\u0003B,Z5n\u0003\"\u0001\u0017\u0001\u000e\u0003\u0015BQaO\u0004A\u0002uBQAS\u0004A\u00021CQaU\u0004A\u00021\u000bQ\u0003Z3gCVdGo\u00144gg\u0016$X)\u0019:mS\u0016\u001cH/F\u0001_!\t\u0001t,\u0003\u0002ac\t\u0019\u0011J\u001c;\u0002-\u0011,g-Y;mi>3gm]3u\u000b\u0006\u0014H.[3ti\u0002\n1\u0003Z3gCVdGo\u00144gg\u0016$H*\u0019;fgR\fA\u0003Z3gCVdGo\u00144gg\u0016$H*\u0019;fgR\u0004\u0013!B:qY&$HC\u00014s!\r9wn\u0016\b\u0003Q6t!!\u001b7\u000e\u0003)T!a[\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u000182\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0007M+\u0017O\u0003\u0002oc!)1\u000f\u0004a\u0001=\u0006QQ.\u0019=PM\u001a\u001cX\r^:)\r1)\u00181AA\u0003!\t1x0D\u0001x\u0015\tA\u00180\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tQ80A\u0004uC.,'p\\3\u000b\u0005ql\u0018AB4ji\",(MC\u0001\u007f\u0003\r\u0019w.\\\u0005\u0004\u0003\u00039(\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005\u001d\u0011!a\u000e0U)R\u0001\u0005\t\u0011+AM\u0003H.\u001b;tAQD\u0017n\u001d\u0011U_BL7\rU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:!S:\u001cH/\u00198dK\u0002Jg\u000e^8![VdG/\u001b9mK\u0002Jgn\u001d;b]\u000e,7\u000fI4jm\u0016t\u0007\u0005\u001e5fA5\f\u00070[7v[\u0002zgMZ:fiN\u0004\u0003/\u001a:!i\u0006\u001c8N\u0003\u0011!A)\u0002cj\u001c;fu\u0001JW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004\u0013n\u001d\u0011sK\u000e,(o]5wK*\u0001\u0003\u0005\t\u00160\u0003I9W\r^#naRLXI\u001c3F]R\u0014\u0018.Z:\u0015\u0007\u0019\fi\u0001\u0003\u0004\u0002\u00105\u0001\rAX\u0001\u0005g&TX-A\fhKR\u001cF/\u0019:u\u001f\u001a47/\u001a;t\r>\u00148\u000b]1sWV\u0011\u0011Q\u0003\t\u0005\u0003/\tyB\u0004\u0003\u0002\u001a\u0005m\u0001CA52\u0013\r\ti\"M\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0011\u0007\u000b\u0004\u000fk\u0006\r\u0011qE\u0011\u0003\u0003S\t\u0001m\f\u0016+\u0015\u0001\u0002\u0003E\u000b\u0011De\u0016\fG/\u001a\u0011tiJLgn\u001a\u0011u_\u0002*8/\u001a\u0011bg\u0002\u001aH/\u0019:uS:<w&\u001a8eS:<wJ\u001a4tKR\u001c\be\u001c9uS>t\u0007EZ8sAM\u0003\u0018M]6!\u0017\u000647.\u0019\u0011eCR\f\u0007e]8ve\u000e,'\u0002\t\u0011!U=\nQcZ3u\u000b:$wJ\u001a4tKR\u001chi\u001c:Ta\u0006\u00148.\u0001\nhKR|eMZ:fiN4uN]*qCJ\\G\u0003CA\u000b\u0003c\t)$!\u000f\t\r\u0005M\u0002\u00031\u0001>\u0003\t!\b\u000f\u0003\u0004\u00028A\u0001\r\u0001T\u0001\u0003_RDa!a\u000f\u0011\u0001\u0004q\u0016!\u00043fM\u0006,H\u000e^(gMN,G/\u0001\u0003d_BLHcB,\u0002B\u0005\r\u0013Q\t\u0005\bwE\u0001\n\u00111\u0001>\u0011\u001dQ\u0015\u0003%AA\u00021CqaU\t\u0011\u0002\u0003\u0007A*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-#fA\u001f\u0002N-\u0012\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003%)hn\u00195fG.,GMC\u0002\u0002ZE\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti&a\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r$f\u0001'\u0002N\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014\u0001\u00027b]\u001eT!!!\u001e\u0002\t)\fg/Y\u0005\u0005\u0003C\ty'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0014Q\u0011\t\u0004a\u0005\u0005\u0015bAABc\t\u0019\u0011I\\=\t\u0011\u0005\u001du#!AA\u0002y\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAG!\u0019\ty)!&\u0002\u00005\u0011\u0011\u0011\u0013\u0006\u0004\u0003'\u000b\u0014AC2pY2,7\r^5p]&!\u0011qSAI\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00151\u0015\t\u0004a\u0005}\u0015bAAQc\t9!i\\8mK\u0006t\u0007\"CAD3\u0005\u0005\t\u0019AA@\u0003!A\u0017m\u001d5D_\u0012,G#\u00010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001b\u0002\r\u0015\fX/\u00197t)\u0011\ti*!-\t\u0013\u0005\u001dE$!AA\u0002\u0005}\u0004F\u0002\u0001v\u0003\u0007\t),\t\u0002\u00028\u0006\tvF\u000b\u0016\u000bA)\u0002sJ\u001a4tKR\u001c\b\u0005^8!aJ|7-Z:tAA,'\u000f\t;pa&\u001c\u0007\u0005]1si&$\u0018n\u001c8\u000bA)\u0002cj\u001c;fu\u0001*g\u000eZ(gMN,G\u000fI5tA\u0015D8\r\\;tSZ,'\u0002\t\u00160\u0003U!v\u000e]5d!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004\"\u0001\u0017\u0010\u0014\ty\ty\f\u000f\t\t\u0003\u0003\f9-\u0010'M/6\u0011\u00111\u0019\u0006\u0004\u0003\u000b\f\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u0013\f\u0019MA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f]\u000b\t.a5\u0002V\")1(\ta\u0001{!)!*\ta\u0001\u0019\")1+\ta\u0001\u0019\u00069QO\\1qa2LH\u0003BAn\u0003G\u0004B\u0001M'\u0002^B1\u0001'a8>\u00192K1!!92\u0005\u0019!V\u000f\u001d7fg!A\u0011Q\u001d\u0012\u0002\u0002\u0003\u0007q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001e\t\u0005\u0003[\ni/\u0003\u0003\u0002p\u0006=$AB(cU\u0016\u001cG\u000f")
public class TopicPartitionOffsets
implements Product,
scala.Serializable {
    private final TopicPartition topicPartition;
    private final Option<Object> startOffset;
    private final Option<Object> endOffset;
    private final int defaultOffsetEarliest;
    private final int defaultOffsetLatest;

    public static Option<Tuple3<TopicPartition, Option<Object>, Option<Object>>> unapply(TopicPartitionOffsets topicPartitionOffsets) {
        return TopicPartitionOffsets$.MODULE$.unapply(topicPartitionOffsets);
    }

    public static TopicPartitionOffsets apply(TopicPartition topicPartition, Option<Object> option, Option<Object> option2) {
        return TopicPartitionOffsets$.MODULE$.apply(topicPartition, option, option2);
    }

    public static Function1<Tuple3<TopicPartition, Option<Object>, Option<Object>>, TopicPartitionOffsets> tupled() {
        return TopicPartitionOffsets$.MODULE$.tupled();
    }

    public static Function1<TopicPartition, Function1<Option<Object>, Function1<Option<Object>, TopicPartitionOffsets>>> curried() {
        return TopicPartitionOffsets$.MODULE$.curried();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Object> startOffset() {
        return this.startOffset;
    }

    public Option<Object> endOffset() {
        return this.endOffset;
    }

    private int defaultOffsetEarliest() {
        return this.defaultOffsetEarliest;
    }

    private int defaultOffsetLatest() {
        return this.defaultOffsetLatest;
    }

    @Scaladoc(value="/**\n   * Splits this TopicPartitionOffsets instance into multiple instances given the maximum offsets per task\n   * Note: implementation is recursive\n   */")
    public Seq<TopicPartitionOffsets> split(int maxOffsets) {
        return this.startOffset().isDefined() && this.endOffset().isDefined() ? (BoxesRunTime.unboxToLong((Object)this.startOffset().get()) + (long)maxOffsets < BoxesRunTime.unboxToLong((Object)this.endOffset().get()) ? (Seq)((TraversableLike)new .colon.colon((Object)new TopicPartitionOffsets(this.topicPartition(), this.startOffset(), (Option<Object>)this.startOffset().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$29 -> x$29 + (long)maxOffsets)), (List)Nil$.MODULE$)).$plus$plus(new TopicPartitionOffsets(this.topicPartition(), (Option<Object>)this.startOffset().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$30 -> x$30 + (long)maxOffsets), this.endOffset()).split(maxOffsets), Seq$.MODULE$.canBuildFrom()) : (Seq)new .colon.colon((Object)this, (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)this, (List)Nil$.MODULE$);
    }

    public Seq<TopicPartitionOffsets> getEmptyEndEntries(int size) {
        return (Seq)Seq$.MODULE$.fill(size, (Function0 & Serializable & scala.Serializable)() -> {
            Option<Object> x$1 = this.endOffset();
            TopicPartition x$2 = this.copy$default$1();
            Option<Object> x$3 = this.copy$default$3();
            return this.copy(x$2, x$1, x$3);
        });
    }

    @Scaladoc(value="/**\n   * Create string to use as starting/endingOffsets option for Spark Kafka data source\n   */")
    public String getStartOffsetsForSpark() {
        return this.getOffsetsForSpark(this.topicPartition(), this.startOffset(), this.defaultOffsetEarliest());
    }

    public String getEndOffsetsForSpark() {
        return this.getOffsetsForSpark(this.topicPartition(), this.endOffset(), this.defaultOffsetLatest());
    }

    private String getOffsetsForSpark(TopicPartition tp, Option<Object> ot, int defaultOffset) {
        return new StringBuilder(3).append("\"").append(tp.partition()).append("\":").append(ot.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> defaultOffset)).toString();
    }

    public TopicPartitionOffsets copy(TopicPartition topicPartition, Option<Object> startOffset, Option<Object> endOffset) {
        return new TopicPartitionOffsets(topicPartition, startOffset, endOffset);
    }

    public TopicPartition copy$default$1() {
        return this.topicPartition();
    }

    public Option<Object> copy$default$2() {
        return this.startOffset();
    }

    public Option<Object> copy$default$3() {
        return this.endOffset();
    }

    public String productPrefix() {
        return "TopicPartitionOffsets";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Object> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.topicPartition();
                break;
            }
            case 1: {
                option = this.startOffset();
                break;
            }
            case 2: {
                option = this.endOffset();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopicPartitionOffsets;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopicPartitionOffsets)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopicPartitionOffsets topicPartitionOffsets = (TopicPartitionOffsets)x$1;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = topicPartitionOffsets.topicPartition();
        if (topicPartition == null) {
            if (topicPartition2 != null) {
                return false;
            }
        } else if (!topicPartition.equals(topicPartition2)) return false;
        Option<Object> option = this.startOffset();
        Option<Object> option2 = topicPartitionOffsets.startOffset();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.endOffset();
        Option<Object> option4 = topicPartitionOffsets.endOffset();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!topicPartitionOffsets.canEqual(this)) return false;
        return true;
    }

    public TopicPartitionOffsets(TopicPartition topicPartition, Option<Object> startOffset, Option<Object> endOffset) {
        this.topicPartition = topicPartition;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        Product.$init$((Product)this);
        this.defaultOffsetEarliest = -2;
        this.defaultOffsetLatest = -1;
    }
}

