/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.connection;

import com.github.takezoe.scaladoc.Scaladoc;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.BasicAuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.ExecutionMode;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.definitions.TokenAuthMode;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.workflow.AtlasExportable;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.connection.ConnectionMetadata;
import io.smartdatalake.workflow.connection.SplunkConnection$;
import io.smartdatalake.workflow.connection.SplunkConnectionService;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataobject.Expectation;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n * Connection information for splunk queries\n *\n * @param id unique id of this connection\n * @param host\n * @param port\n * @param authMode\n * @param metadata\n */")
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001\u0002\u0015*\u0001JB\u0001B\u0012\u0001\u0003\u0016\u0004%\te\u0012\u0005\t5\u0002\u0011\t\u0012)A\u0005\u0011\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005f\u0001\tE\t\u0015!\u0003^\u0011!1\u0007A!f\u0001\n\u00039\u0007\u0002C6\u0001\u0005#\u0005\u000b\u0011\u00025\t\u00111\u0004!Q3A\u0005\u00025D\u0001\u0002\u001e\u0001\u0003\u0012\u0003\u0006IA\u001c\u0005\tk\u0002\u0011)\u001a!C!m\"AQ\u0010\u0001B\tB\u0003%q\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u0011q\n\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011q\u000e\u0001\u0005B\u0005E\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\tI\tAI\u0001\n\u0003\tY\tC\u0005\u0002\"\u0002\t\n\u0011\"\u0001\u0002$\"I\u0011q\u0015\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003[\u0003\u0011\u0013!C\u0001\u0003_C\u0011\"a-\u0001#\u0003%\t!!.\t\u0013\u0005e\u0006!!A\u0005B\u0005m\u0006\u0002CAa\u0001\u0005\u0005I\u0011A4\t\u0013\u0005\r\u0007!!A\u0005\u0002\u0005\u0015\u0007\"CAi\u0001\u0005\u0005I\u0011IAj\u0011%\tY\u000eAA\u0001\n\u0003\ti\u000eC\u0005\u0002h\u0002\t\t\u0011\"\u0011\u0002j\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003_\u0004\u0011\u0011!C!\u0003c<qA!\u0005*\u0011\u0003\u0011\u0019B\u0002\u0004)S!\u0005!Q\u0003\u0005\u0007}\u0002\"\tAa\u0006\t\u000f\te\u0001\u0005\"\u0011\u0003\u001c!I!\u0011\b\u0011\u0002\u0002\u0013\u0005%1\b\u0005\n\u0005\u000f\u0002\u0013\u0013!C\u0001\u0003kC\u0011B!\u0013!\u0003\u0003%\tIa\u0013\t\u0013\te\u0003%%A\u0005\u0002\u0005U\u0006\"\u0003B.A\u0005\u0005I\u0011\u0002B/\u0005A\u0019\u0006\u000f\\;oW\u000e{gN\\3di&|gN\u0003\u0002+W\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u000b\u00051j\u0013\u0001C<pe.4Gn\\<\u000b\u00059z\u0013!D:nCJ$H-\u0019;bY\u0006\\WMC\u00011\u0003\tIwn\u0001\u0001\u0014\r\u0001\u0019\u0014(\u0010!D!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fMB\u0011!hO\u0007\u0002S%\u0011A(\u000b\u0002\u000b\u0007>tg.Z2uS>t\u0007C\u0001\u001e?\u0013\ty\u0014FA\fTa2,hn[\"p]:,7\r^5p]N+'O^5dKB\u0011A'Q\u0005\u0003\u0005V\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00025\t&\u0011Q)\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0003S\u0012,\u0012\u0001\u0013\t\u0003\u0013^s!A\u0013+\u000f\u0005-\u0013fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty\u0015'\u0001\u0004=e>|GOP\u0005\u0002a%\u0011afL\u0005\u0003'6\naaY8oM&<\u0017BA+W\u0003=\u0019F\r\\\"p]\u001aLwm\u00142kK\u000e$(BA*.\u0013\tA\u0016L\u0001\u0007D_:tWm\u0019;j_:LEM\u0003\u0002V-\u0006\u0019\u0011\u000e\u001a\u0011\u0002\t!|7\u000f^\u000b\u0002;B\u0011aL\u0019\b\u0003?\u0002\u0004\"!T\u001b\n\u0005\u0005,\u0014A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y\u001b\u0002\u000b!|7\u000f\u001e\u0011\u0002\tA|'\u000f^\u000b\u0002QB\u0011A'[\u0005\u0003UV\u00121!\u00138u\u0003\u0015\u0001xN\u001d;!\u0003!\tW\u000f\u001e5N_\u0012,W#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005El\u0013a\u00033fM&t\u0017\u000e^5p]NL!a\u001d9\u0003\u0011\u0005+H\u000f['pI\u0016\f\u0011\"Y;uQ6{G-\u001a\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012a\u001e\t\u0004iaT\u0018BA=6\u0005\u0019y\u0005\u000f^5p]B\u0011!h_\u0005\u0003y&\u0012!cQ8o]\u0016\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u0006IQ.\u001a;bI\u0006$\u0018\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0011\u0005i\u0002\u0001\"\u0002$\f\u0001\u0004A\u0005\"B.\f\u0001\u0004i\u0006\"\u00024\f\u0001\u0004A\u0007\"\u00027\f\u0001\u0004q\u0007bB;\f!\u0003\u0005\ra^\u0001\u000fgV\u0004\bo\u001c:uK\u0012\fU\u000f\u001e5t+\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005e\u0011QD\u0007\u0003\u0003+Q1!a\u00066\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t)BA\u0002TKF\u0004D!a\b\u00024A1\u0011\u0011EA\u0016\u0003_i!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0005Y\u0006twM\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#a\t\u0003\u000b\rc\u0017m]:\u0011\t\u0005E\u00121\u0007\u0007\u0001\t-\t)\u0004AA\u0001\u0002\u0003\u0015\t!a\u000e\u0003\u0005}\u000b\u0014\u0003BA\u001d\u0003\u0017\u0012b!a\u000f\u0002@\u0005\u0015cABA\u001f\u0001\u0001\tID\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002p\u0003\u0003J1!a\u0011q\u00055!vn[3o\u0003V$\b.T8eKB\u0019q.a\u0012\n\u0007\u0005%\u0003OA\u0007CCNL7-Q;uQ6{G-\u001a\n\u0006\u0003\u001b\u00025I\u001c\u0004\u0007\u0003{\u0001\u0001!a\u0013\u0002\u001fM,\b\u000f]8si\u0016$\u0017)\u001e;ig\u0002\nqbY8o]\u0016\u001cG\u000fV8Ta2,hn[\u000b\u0003\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0004ta2,hn\u001b\u0006\u0003\u0003?\n1aY8n\u0013\u0011\t\u0019'!\u0017\u0003\u000fM+'O^5dK\u0006!A/Z:u)\t\tI\u0007E\u00025\u0003WJ1!!\u001c6\u0005\u0011)f.\u001b;\u0002\u000f\u0019\f7\r^8ssV\u0011\u00111\u000f\t\u0006\u0003k\n9(O\u0007\u0002-&\u0019\u0011\u0011\u0010,\u0003#\u0019\u0013x.\\\"p]\u001aLwMR1di>\u0014\u00180\u0001\u0003d_BLH\u0003DA\u0001\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0005b\u0002$\u0012!\u0003\u0005\r\u0001\u0013\u0005\b7F\u0001\n\u00111\u0001^\u0011\u001d1\u0017\u0003%AA\u0002!Dq\u0001\\\t\u0011\u0002\u0003\u0007a\u000eC\u0004v#A\u0005\t\u0019A<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0012\u0016\u0004\u0011\u0006=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mU'\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0015\u0016\u0004;\u0006=\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003WS3\u0001[AH\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!-+\u00079\fy)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005]&fA<\u0002\u0010\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!0\u0011\t\u0005\u0005\u0012qX\u0005\u0004G\u0006\r\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\fi\rE\u00025\u0003\u0013L1!a36\u0005\r\te.\u001f\u0005\t\u0003\u001fL\u0012\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!6\u0011\r\u0005M\u0011q[Ad\u0013\u0011\tI.!\u0006\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003?\f)\u000fE\u00025\u0003CL1!a96\u0005\u001d\u0011un\u001c7fC:D\u0011\"a4\u001c\u0003\u0003\u0005\r!a2\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001[\u0001\ti>\u001cFO]5oOR\u0011\u0011QX\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u00171\u001f\u0005\n\u0003\u001ft\u0012\u0011!a\u0001\u0003\u000fDs\u0001AA|\u0005\u0017\u0011i\u0001\u0005\u0003\u0002z\n\u001dQBAA~\u0015\u0011\ti0a@\u0002\u0011M\u001c\u0017\r\\1e_\u000eTAA!\u0001\u0003\u0004\u00059A/Y6fu>,'\u0002\u0002B\u0003\u0003;\naaZ5uQV\u0014\u0017\u0002\u0002B\u0005\u0003w\u0014\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005\u001f\t\u00111J\u0018+U)\u0001#\u0006I\"p]:,7\r^5p]\u0002JgNZ8s[\u0006$\u0018n\u001c8!M>\u0014\be\u001d9mk:\\\u0007%];fe&,7O\u0003\u0011+\u0015\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001b3!k:L\u0017/^3!S\u0012\u0004sN\u001a\u0011uQ&\u001c\beY8o]\u0016\u001cG/[8o\u0015\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005[8ti*\u0001#\u0006\t!qCJ\fW\u000e\t9peRT\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011bkRDWj\u001c3f\u0015\u0001R\u0003\u0005\u00119be\u0006l\u0007%\\3uC\u0012\fG/\u0019\u0006!U=\n\u0001c\u00159mk:\\7i\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005i\u00023#\u0002\u00114\u0003g\u001aEC\u0001B\n\u0003)1'o\\7D_:4\u0017n\u001a\u000b\u0005\u0005;\u0011I\u0003\u0006\u0003\u0002\u0002\t}\u0001b\u0002B\u0011E\u0001\u000f!1E\u0001\u0011S:\u001cH/\u00198dKJ+w-[:uef\u0004B!!\u001e\u0003&%\u0019!q\u0005,\u0003!%s7\u000f^1oG\u0016\u0014VmZ5tiJL\bBB*#\u0001\u0004\u0011Y\u0003\u0005\u0003\u0003.\tURB\u0001B\u0018\u0015\r\u0019&\u0011\u0007\u0006\u0005\u0005g\ti&\u0001\u0005usB,7/\u00194f\u0013\u0011\u00119Da\f\u0003\r\r{gNZ5h\u0003\u0015\t\u0007\u000f\u001d7z)1\t\tA!\u0010\u0003@\t\u0005#1\tB#\u0011\u001515\u00051\u0001I\u0011\u0015Y6\u00051\u0001^\u0011\u001517\u00051\u0001i\u0011\u0015a7\u00051\u0001o\u0011\u001d)8\u0005%AA\u0002]\fq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iE!\u0016\u0011\tQB(q\n\t\ti\tE\u0003*\u00185oo&\u0019!1K\u001b\u0003\rQ+\b\u000f\\36\u0011%\u00119&JA\u0001\u0002\u0004\t\t!A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0018\u0011\t\u0005\u0005\"\u0011M\u0005\u0005\u0005G\n\u0019C\u0001\u0004PE*,7\r\u001e")
public class SplunkConnection
implements Connection,
SplunkConnectionService,
Product,
scala.Serializable {
    private final String id;
    private final String host;
    private final int port;
    private final AuthMode authMode;
    private final Option<ConnectionMetadata> metadata;
    private final Seq<Class<? extends Product>> supportedAuths;

    public static Option<ConnectionMetadata> $lessinit$greater$default$5() {
        return SplunkConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple5<SdlConfigObject.ConnectionId, String, Object, AuthMode, Option<ConnectionMetadata>>> unapply(SplunkConnection splunkConnection) {
        return SplunkConnection$.MODULE$.unapply(splunkConnection);
    }

    public static Option<ConnectionMetadata> apply$default$5() {
        return SplunkConnection$.MODULE$.apply$default$5();
    }

    public static SplunkConnection apply(String string, String string2, int n, AuthMode authMode, Option<ConnectionMetadata> option) {
        return SplunkConnection$.MODULE$.apply(string, string2, n, authMode, option);
    }

    public static SplunkConnection fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return SplunkConnection$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return SplunkConnection$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return SplunkConnection$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return SplunkConnection$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return SplunkConnection$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return SplunkConnection$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return SplunkConnection$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return SplunkConnection$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<scala.collection.immutable.Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<scala.collection.immutable.Map<String, String>> configReader) {
        return SplunkConnection$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return SplunkConnection$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return SplunkConnection$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return SplunkConnection$.MODULE$.conditionReader();
    }

    public static ConfigReader<ExecutionMode> executionModeReader() {
        return SplunkConnection$.MODULE$.executionModeReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return SplunkConnection$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return SplunkConnection$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return SplunkConnection$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return SplunkConnection$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return SplunkConnection$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return SplunkConnection$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return SplunkConnection$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return SplunkConnection$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return SplunkConnection$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[StructType]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   * See [[SchemaProviderType]] for available providers.\n   */")
    public static ConfigReader<StructType> structTypeReader() {
        return SplunkConnection$.MODULE$.structTypeReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return SplunkConnection$.MODULE$.sdlDefaultNaming();
    }

    public String toStringShort() {
        return Connection.toStringShort$((Connection)this);
    }

    public String atlasName() {
        return Connection.atlasName$((Connection)this);
    }

    public String atlasQualifiedName(String prefix) {
        return AtlasExportable.atlasQualifiedName$((AtlasExportable)this, (String)prefix);
    }

    public String id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public AuthMode authMode() {
        return this.authMode;
    }

    public Option<ConnectionMetadata> metadata() {
        return this.metadata;
    }

    private Seq<Class<? extends Product>> supportedAuths() {
        return this.supportedAuths;
    }

    @Override
    public Service connectToSplunk() {
        ServiceArgs connectionArgs = new ServiceArgs();
        connectionArgs.setHost(this.host());
        connectionArgs.setPort(this.port());
        connectionArgs.setSSLSecurityProtocol(SSLSecurityProtocol.TLSv1_2);
        AuthMode authMode = this.authMode();
        if (authMode instanceof TokenAuthMode) {
            TokenAuthMode tokenAuthMode = (TokenAuthMode)authMode;
            connectionArgs.setToken(tokenAuthMode.token());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (authMode instanceof BasicAuthMode) {
            BasicAuthMode basicAuthMode = (BasicAuthMode)authMode;
            connectionArgs.setUsername(basicAuthMode.user());
            connectionArgs.setPassword(basicAuthMode.password());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(15).append(this.authMode().getClass().getSimpleName()).append(" not supported.").toString());
        }
        return Service.connect((Map)connectionArgs);
    }

    public void test() {
        this.connectToSplunk().logout();
    }

    public FromConfigFactory<Connection> factory() {
        return SplunkConnection$.MODULE$;
    }

    public SplunkConnection copy(String id, String host, int port, AuthMode authMode, Option<ConnectionMetadata> metadata) {
        return new SplunkConnection(id, host, port, authMode, metadata);
    }

    public String copy$default$1() {
        return this.id();
    }

    public String copy$default$2() {
        return this.host();
    }

    public int copy$default$3() {
        return this.port();
    }

    public AuthMode copy$default$4() {
        return this.authMode();
    }

    public Option<ConnectionMetadata> copy$default$5() {
        return this.metadata();
    }

    public String productPrefix() {
        return "SplunkConnection";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = new SdlConfigObject.ConnectionId(this.id());
                break;
            }
            case 1: {
                object = this.host();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.port());
                break;
            }
            case 3: {
                object = this.authMode();
                break;
            }
            case 4: {
                object = this.metadata();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SplunkConnection;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new SdlConfigObject.ConnectionId(this.id())));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.host()));
        n = Statics.mix((int)n, (int)this.port());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.authMode()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.metadata()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SplunkConnection)) return false;
        boolean bl = true;
        if (!bl) return false;
        SplunkConnection splunkConnection = (SplunkConnection)x$1;
        String string = this.id();
        String string2 = splunkConnection.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.host();
        String string4 = splunkConnection.host();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.port() != splunkConnection.port()) return false;
        AuthMode authMode = this.authMode();
        AuthMode authMode2 = splunkConnection.authMode();
        if (authMode == null) {
            if (authMode2 != null) {
                return false;
            }
        } else if (!authMode.equals(authMode2)) return false;
        Option<ConnectionMetadata> option = this.metadata();
        Option<ConnectionMetadata> option2 = splunkConnection.metadata();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!splunkConnection.canEqual(this)) return false;
        return true;
    }

    public SplunkConnection(String id, String host, int port, AuthMode authMode, Option<ConnectionMetadata> metadata) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.authMode = authMode;
        this.metadata = metadata;
        SdlConfigObject.$init$((SdlConfigObject)this);
        AtlasExportable.$init$((AtlasExportable)this);
        Connection.$init$((Connection)this);
        Product.$init$((Product)this);
        this.supportedAuths = (Seq)new .colon.colon(BasicAuthMode.class, (List)new .colon.colon(TokenAuthMode.class, (List)Nil$.MODULE$));
        Predef$.MODULE$.require(this.supportedAuths().contains(authMode.getClass()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(this.authMode().getClass().getSimpleName()).append(" not supported by ").append(this.getClass().getSimpleName()).append(". Supported auth modes are ").append(((TraversableOnce)this.supportedAuths().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSimpleName(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(".").toString());
    }
}

