/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.dataobject;

import com.github.takezoe.scaladoc.Scaladoc;
import com.typesafe.config.Config;
import configs.ConfigError$;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import configs.ConfigReader$;
import configs.ConfigUtil$;
import configs.Result;
import configs.Result$;
import io.smartdatalake.config.ConfigImplicits;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.ExecutionMode;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataobject.DataObject;
import io.smartdatalake.workflow.dataobject.DataObjectMetadata;
import io.smartdatalake.workflow.dataobject.DataObjectMetadata$;
import io.smartdatalake.workflow.dataobject.Expectation;
import io.smartdatalake.workflow.dataobject.SplunkDataObject;
import io.smartdatalake.workflow.dataobject.SplunkDataObject$;
import io.smartdatalake.workflow.dataobject.SplunkDataObject$$anon$2$;
import io.smartdatalake.workflow.dataobject.SplunkParams;
import io.smartdatalake.workflow.dataobject.SplunkParams$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class SplunkDataObject$
implements FromConfigFactory<DataObject>,
scala.Serializable {
    public static SplunkDataObject$ MODULE$;
    private final String SF_TIME_FORMAT;
    private final ConfigReader<SplunkParams> splunkParamsReader;
    private final ConfigReader<LocalDateTime> splunkLocalDateTimeReader;
    private final ConfigReader<Duration> splunkDurationReader;
    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[StructType]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   * See [[SchemaProviderType]] for available providers.\n   */")
    private final ConfigReader<StructType> structTypeReader;
    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    private final ConfigReader<GenericSchema> genericSchemaReader;
    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    private final ConfigReader<OutputMode> outputModeReader;
    private final ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader;
    private final ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader;
    private final ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader;
    private final ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader;
    private final ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader;
    private final ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader;
    private final ConfigReader<SecretProviderConfig> secretProviderConfigReader;
    private final ConfigReader<ExecutionMode> executionModeReader;
    private final ConfigReader<Condition> conditionReader;
    private final ConfigReader<AuthMode> authModeReader;
    private final ConfigReader<SaveModeOptions> saveModeOptionsReader;
    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    private final ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader;
    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    private final ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader;
    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    private final ConfigReader<SdlConfigObject.ActionId> actionIdReader;
    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    private final ConfigReader<GenericDfTransformer> dfTransformerReader;
    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    private final ConfigReader<GenericDfsTransformer> dfsTransformerReader;
    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    private final ConfigReader<ParsableScriptDef> scriptDefReader;
    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    private final ConfigReader<Expectation> expectationReader;

    static {
        new SplunkDataObject$();
    }

    @Scaladoc(value="/**\n   * Helper method to extract case class from config\n   */")
    public <T> T extract(Config config, ConfigReader<T> evidence$1) {
        return (T)FromConfigFactory.extract$((FromConfigFactory)this, (Config)config, evidence$1);
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return ConfigImplicits.sdlDefaultNaming$((ConfigImplicits)this);
    }

    public ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> mapReader) {
        return ConfigImplicits.mapDataObjectIdStringReader$((ConfigImplicits)this, mapReader);
    }

    public ConfigReader<StructType> structTypeReader() {
        return this.structTypeReader;
    }

    public ConfigReader<GenericSchema> genericSchemaReader() {
        return this.genericSchemaReader;
    }

    public ConfigReader<OutputMode> outputModeReader() {
        return this.outputModeReader;
    }

    public ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return this.customDfCreatorConfigReader;
    }

    public ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return this.customDfTransformerConfigReader;
    }

    public ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return this.customDfsTransformerConfigReader;
    }

    public ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return this.customFileTransformerConfigReader;
    }

    public ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return this.sparkUdfCreatorConfigReader;
    }

    public ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return this.sparkRepartitionDefReader;
    }

    public ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return this.secretProviderConfigReader;
    }

    public ConfigReader<ExecutionMode> executionModeReader() {
        return this.executionModeReader;
    }

    public ConfigReader<Condition> conditionReader() {
        return this.conditionReader;
    }

    public ConfigReader<AuthMode> authModeReader() {
        return this.authModeReader;
    }

    public ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return this.saveModeOptionsReader;
    }

    public ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return this.connectionIdReader;
    }

    public ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return this.dataObjectIdReader;
    }

    public ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return this.actionIdReader;
    }

    public ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return this.dfTransformerReader;
    }

    public ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return this.dfsTransformerReader;
    }

    public ConfigReader<ParsableScriptDef> scriptDefReader() {
        return this.scriptDefReader;
    }

    public ConfigReader<Expectation> expectationReader() {
        return this.expectationReader;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$structTypeReader_$eq(ConfigReader<StructType> x$1) {
        this.structTypeReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$genericSchemaReader_$eq(ConfigReader<GenericSchema> x$1) {
        this.genericSchemaReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$outputModeReader_$eq(ConfigReader<OutputMode> x$1) {
        this.outputModeReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$customDfCreatorConfigReader_$eq(ConfigReader<CustomDfCreatorConfig> x$1) {
        this.customDfCreatorConfigReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$customDfTransformerConfigReader_$eq(ConfigReader<CustomDfTransformerConfig> x$1) {
        this.customDfTransformerConfigReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$customDfsTransformerConfigReader_$eq(ConfigReader<CustomDfsTransformerConfig> x$1) {
        this.customDfsTransformerConfigReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$customFileTransformerConfigReader_$eq(ConfigReader<CustomFileTransformerConfig> x$1) {
        this.customFileTransformerConfigReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$sparkUdfCreatorConfigReader_$eq(ConfigReader<SparkUDFCreatorConfig> x$1) {
        this.sparkUdfCreatorConfigReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$sparkRepartitionDefReader_$eq(ConfigReader<SparkRepartitionDef> x$1) {
        this.sparkRepartitionDefReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$secretProviderConfigReader_$eq(ConfigReader<SecretProviderConfig> x$1) {
        this.secretProviderConfigReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$executionModeReader_$eq(ConfigReader<ExecutionMode> x$1) {
        this.executionModeReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$conditionReader_$eq(ConfigReader<Condition> x$1) {
        this.conditionReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$authModeReader_$eq(ConfigReader<AuthMode> x$1) {
        this.authModeReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$saveModeOptionsReader_$eq(ConfigReader<SaveModeOptions> x$1) {
        this.saveModeOptionsReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$connectionIdReader_$eq(ConfigReader<SdlConfigObject.ConnectionId> x$1) {
        this.connectionIdReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$dataObjectIdReader_$eq(ConfigReader<SdlConfigObject.DataObjectId> x$1) {
        this.dataObjectIdReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$actionIdReader_$eq(ConfigReader<SdlConfigObject.ActionId> x$1) {
        this.actionIdReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$dfTransformerReader_$eq(ConfigReader<GenericDfTransformer> x$1) {
        this.dfTransformerReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$dfsTransformerReader_$eq(ConfigReader<GenericDfsTransformer> x$1) {
        this.dfsTransformerReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$scriptDefReader_$eq(ConfigReader<ParsableScriptDef> x$1) {
        this.scriptDefReader = x$1;
    }

    public void io$smartdatalake$config$ConfigImplicits$_setter_$expectationReader_$eq(ConfigReader<Expectation> x$1) {
        this.expectationReader = x$1;
    }

    public Option<DataObjectMetadata> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    private String SF_TIME_FORMAT() {
        return this.SF_TIME_FORMAT;
    }

    @Scaladoc(value="/**\n   * Parse a [[LocalDateTime]] from a [[SplunkDataObject]] SDL config.\n   *\n   * @param value a string specifying the [[LocalDateTime]] in the expected format.\n   * @return  a new [[LocalDateTime]] instance representing the specified value.\n   */")
    public LocalDateTime parseConfigDateTime(String value) {
        String valueStripped = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(value)).stripPrefix("'"))).stripSuffix("'");
        return LocalDateTime.parse(valueStripped, DateTimeFormatter.ofPattern(this.SF_TIME_FORMAT()));
    }

    @Scaladoc(value="/**\n   * Parse a [[Duration]] from a [[SplunkDataObject]] SDL config.\n   *\n   * @param value an integer specifying the [[Duration]] in the expected format.\n   * @return  a new [[Duration]] instance representing the specified value.\n   */")
    public Duration parseConfigDuration(int value) {
        return Duration.ofMinutes(value);
    }

    public ConfigReader<SplunkParams> splunkParamsReader() {
        return this.splunkParamsReader;
    }

    public ConfigReader<LocalDateTime> splunkLocalDateTimeReader() {
        return this.splunkLocalDateTimeReader;
    }

    public ConfigReader<Duration> splunkDurationReader() {
        return this.splunkDurationReader;
    }

    public SplunkDataObject fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return this.extract(config, new Object(instanceRegistry){
            private ConfigReader<SplunkDataObject> t$macro$2;
            private ConfigReader<SdlConfigObject.DataObjectId> t$macro$5;
            private ConfigReader<SplunkParams> t$macro$7;
            private ConfigReader<SdlConfigObject.ConnectionId> t$macro$9;
            private ConfigReader<Option<DataObjectMetadata>> t$macro$12;
            private ConfigReader<Option<Option<DataObjectMetadata>>> t$macro$11;
            private final ConfigKeyNaming<SplunkDataObject> n$macro$1;
            private volatile byte bitmap$0;
            private final InstanceRegistry instanceRegistry$1;

            public ConfigKeyNaming<SplunkDataObject> n$macro$1() {
                return this.n$macro$1;
            }

            private ConfigReader<SplunkDataObject> t$macro$2$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.t$macro$2 = ConfigReader$.MODULE$.fromConfig((Function1 & Serializable & scala.Serializable)c$macro$3 -> {
                            Nil$ nil$;
                            Nil$ nil$2;
                            if (this.n$macro$1().failOnSuperfluousKeys()) {
                                List configKeys = ConfigUtil$.MODULE$.getRootKeys(c$macro$3);
                                List paramKeys = (List)new .colon.colon((Object)this.n$macro$1().apply("id"), (List)new .colon.colon((Object)this.n$macro$1().apply("params"), (List)new .colon.colon((Object)this.n$macro$1().apply("connectionId"), (List)new .colon.colon((Object)this.n$macro$1().apply("metadata"), (List)Nil$.MODULE$)))).flatten((Function1)Predef$.MODULE$.$conforms());
                                nil$2 = (List)ConfigUtil$.MODULE$.getSuperfluousKeys(configKeys, paramKeys).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                    Tuple2 tuple2 = x0$1;
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    String key = (String)tuple2._1();
                                    List similarParams = (List)tuple2._2();
                                    String string = new StringBuilder(0).append(key).append((Object)(similarParams.nonEmpty() ? new StringBuilder(17).append(" (did you mean ").append(similarParams.mkString(", ")).append("?)").toString() : "")).toString();
                                    return string;
                                }, List$.MODULE$.canBuildFrom());
                            } else {
                                nil$2 = nil$ = Nil$.MODULE$;
                            }
                            Result result = Nil$.MODULE$.equals(nil$) ? Result$.MODULE$.apply4(this.t$macro$5().read(c$macro$3, this.n$macro$1().apply("id")), this.t$macro$7().read(c$macro$3, this.n$macro$1().apply("params")), this.t$macro$9().read(c$macro$3, this.n$macro$1().apply("connectionId")), this.t$macro$11().read(c$macro$3, this.n$macro$1().apply("metadata")), (Function4 & Serializable & scala.Serializable)(a$macro$4, a$macro$6, a$macro$8, a$macro$10) -> anon.2.$anonfun$t$macro$2$9(this, ((SdlConfigObject.DataObjectId)a$macro$4).id(), a$macro$6, ((SdlConfigObject.ConnectionId)a$macro$8).id(), a$macro$10)) : Result$.MODULE$.failure(ConfigError$.MODULE$.apply(new StringBuilder(26).append("Superfluous key(s) found: ").append(nil$.mkString(", ")).toString()));
                            return result;
                        });
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.t$macro$2;
            }

            public ConfigReader<SplunkDataObject> t$macro$2() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.t$macro$2$lzycompute() : this.t$macro$2;
            }

            private ConfigReader<SdlConfigObject.DataObjectId> t$macro$5$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.t$macro$5 = ConfigReader$.MODULE$.apply(SplunkDataObject$.MODULE$.dataObjectIdReader());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.t$macro$5;
            }

            public ConfigReader<SdlConfigObject.DataObjectId> t$macro$5() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.t$macro$5$lzycompute() : this.t$macro$5;
            }

            private ConfigReader<SplunkParams> t$macro$7$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 4) == 0) {
                        this.t$macro$7 = ConfigReader$.MODULE$.apply(SplunkDataObject$.MODULE$.splunkParamsReader());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                    }
                }
                return this.t$macro$7;
            }

            public ConfigReader<SplunkParams> t$macro$7() {
                return (byte)(this.bitmap$0 & 4) == 0 ? this.t$macro$7$lzycompute() : this.t$macro$7;
            }

            private ConfigReader<SdlConfigObject.ConnectionId> t$macro$9$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 8) == 0) {
                        this.t$macro$9 = ConfigReader$.MODULE$.apply(SplunkDataObject$.MODULE$.connectionIdReader());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                    }
                }
                return this.t$macro$9;
            }

            public ConfigReader<SdlConfigObject.ConnectionId> t$macro$9() {
                return (byte)(this.bitmap$0 & 8) == 0 ? this.t$macro$9$lzycompute() : this.t$macro$9;
            }

            private ConfigReader<Option<DataObjectMetadata>> t$macro$12$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 0x10) == 0) {
                        this.t$macro$12 = ConfigReader$.MODULE$.apply(ConfigReader$.MODULE$.optionConfigReader(new Object(null){
                            private ConfigReader<DataObjectMetadata> t$macro$14;
                            private ConfigReader<Option<String>> t$macro$18;
                            private ConfigReader<Option<Option<String>>> t$macro$17;
                            private ConfigReader<Seq<String>> t$macro$24;
                            private ConfigReader<Option<Seq<String>>> t$macro$23;
                            private final ConfigKeyNaming<DataObjectMetadata> n$macro$13;
                            private volatile byte bitmap$0;

                            public ConfigKeyNaming<DataObjectMetadata> n$macro$13() {
                                return this.n$macro$13;
                            }

                            private ConfigReader<DataObjectMetadata> t$macro$14$lzycompute() {
                                anon$2$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 1) == 0) {
                                        this.t$macro$14 = ConfigReader$.MODULE$.fromConfig((Function1 & Serializable & scala.Serializable)c$macro$15 -> {
                                            Nil$ nil$;
                                            Nil$ nil$2;
                                            if (this.n$macro$13().failOnSuperfluousKeys()) {
                                                List configKeys = ConfigUtil$.MODULE$.getRootKeys(c$macro$15);
                                                List paramKeys = (List)new .colon.colon((Object)this.n$macro$13().apply("name"), (List)new .colon.colon((Object)this.n$macro$13().apply("description"), (List)new .colon.colon((Object)this.n$macro$13().apply("layer"), (List)new .colon.colon((Object)this.n$macro$13().apply("subjectArea"), (List)new .colon.colon((Object)this.n$macro$13().apply("tags"), (List)Nil$.MODULE$))))).flatten((Function1)Predef$.MODULE$.$conforms());
                                                nil$2 = (List)ConfigUtil$.MODULE$.getSuperfluousKeys(configKeys, paramKeys).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                                    Tuple2 tuple2 = x0$2;
                                                    if (tuple2 == null) {
                                                        throw new MatchError((Object)tuple2);
                                                    }
                                                    String key = (String)tuple2._1();
                                                    List similarParams = (List)tuple2._2();
                                                    String string = new StringBuilder(0).append(key).append((Object)(similarParams.nonEmpty() ? new StringBuilder(17).append(" (did you mean ").append(similarParams.mkString(", ")).append("?)").toString() : "")).toString();
                                                    return string;
                                                }, List$.MODULE$.canBuildFrom());
                                            } else {
                                                nil$2 = nil$ = Nil$.MODULE$;
                                            }
                                            Result result = Nil$.MODULE$.equals(nil$) ? Result$.MODULE$.apply5(this.t$macro$17().read(c$macro$15, this.n$macro$13().apply("name")), this.t$macro$17().read(c$macro$15, this.n$macro$13().apply("description")), this.t$macro$17().read(c$macro$15, this.n$macro$13().apply("layer")), this.t$macro$17().read(c$macro$15, this.n$macro$13().apply("subjectArea")), this.t$macro$23().read(c$macro$15, this.n$macro$13().apply("tags")), (Function5 & Serializable & scala.Serializable)(a$macro$16, a$macro$19, a$macro$20, a$macro$21, a$macro$22) -> new DataObjectMetadata((Option)a$macro$16.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataObjectMetadata$.MODULE$.$lessinit$greater$default$1()), (Option)a$macro$19.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataObjectMetadata$.MODULE$.$lessinit$greater$default$2()), (Option)a$macro$20.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataObjectMetadata$.MODULE$.$lessinit$greater$default$3()), (Option)a$macro$21.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataObjectMetadata$.MODULE$.$lessinit$greater$default$4()), (Seq)a$macro$22.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataObjectMetadata$.MODULE$.$lessinit$greater$default$5()))) : Result$.MODULE$.failure(ConfigError$.MODULE$.apply(new StringBuilder(26).append("Superfluous key(s) found: ").append(nil$.mkString(", ")).toString()));
                                            return result;
                                        });
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                                    }
                                }
                                return this.t$macro$14;
                            }

                            public ConfigReader<DataObjectMetadata> t$macro$14() {
                                return (byte)(this.bitmap$0 & 1) == 0 ? this.t$macro$14$lzycompute() : this.t$macro$14;
                            }

                            private ConfigReader<Option<String>> t$macro$18$lzycompute() {
                                anon$2$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 2) == 0) {
                                        this.t$macro$18 = ConfigReader$.MODULE$.apply(ConfigReader$.MODULE$.optionConfigReader(ConfigReader$.MODULE$.stringConfigReader()));
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                                    }
                                }
                                return this.t$macro$18;
                            }

                            public ConfigReader<Option<String>> t$macro$18() {
                                return (byte)(this.bitmap$0 & 2) == 0 ? this.t$macro$18$lzycompute() : this.t$macro$18;
                            }

                            private ConfigReader<Option<Option<String>>> t$macro$17$lzycompute() {
                                anon$2$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 4) == 0) {
                                        this.t$macro$17 = ConfigReader$.MODULE$.optionConfigReader(this.t$macro$18());
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                                    }
                                }
                                return this.t$macro$17;
                            }

                            public ConfigReader<Option<Option<String>>> t$macro$17() {
                                return (byte)(this.bitmap$0 & 4) == 0 ? this.t$macro$17$lzycompute() : this.t$macro$17;
                            }

                            private ConfigReader<Seq<String>> t$macro$24$lzycompute() {
                                anon$2$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 8) == 0) {
                                        this.t$macro$24 = ConfigReader$.MODULE$.apply(ConfigReader$.MODULE$.cbfJListConfigReader(ConfigReader$.MODULE$.javaListConfigReader(ConfigReader$.MODULE$.stringConfigReader()), Predef$.MODULE$.fallbackStringCanBuildFrom()));
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                                    }
                                }
                                return this.t$macro$24;
                            }

                            public ConfigReader<Seq<String>> t$macro$24() {
                                return (byte)(this.bitmap$0 & 8) == 0 ? this.t$macro$24$lzycompute() : this.t$macro$24;
                            }

                            private ConfigReader<Option<Seq<String>>> t$macro$23$lzycompute() {
                                anon$2$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 0x10) == 0) {
                                        this.t$macro$23 = ConfigReader$.MODULE$.optionConfigReader(this.t$macro$24());
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                                    }
                                }
                                return this.t$macro$23;
                            }

                            public ConfigReader<Option<Seq<String>>> t$macro$23() {
                                return (byte)(this.bitmap$0 & 0x10) == 0 ? this.t$macro$23$lzycompute() : this.t$macro$23;
                            }
                            {
                                this.n$macro$13 = SplunkDataObject$.MODULE$.sdlDefaultNaming();
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$t$macro$14$1(io.smartdatalake.workflow.dataobject.SplunkDataObject$$anon$2$$anon$3 com.typesafe.config.Config ), $anonfun$t$macro$14$4(), $anonfun$t$macro$14$5(), $anonfun$t$macro$14$6(), $anonfun$t$macro$14$7(), $anonfun$t$macro$14$8(), $anonfun$t$macro$14$2(scala.Tuple2 ), $anonfun$t$macro$14$3(scala.Option scala.Option scala.Option scala.Option scala.Option )}, serializedLambda);
                            }
                        }.t$macro$14()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                    }
                }
                return this.t$macro$12;
            }

            public ConfigReader<Option<DataObjectMetadata>> t$macro$12() {
                return (byte)(this.bitmap$0 & 0x10) == 0 ? this.t$macro$12$lzycompute() : this.t$macro$12;
            }

            private ConfigReader<Option<Option<DataObjectMetadata>>> t$macro$11$lzycompute() {
                anon.2 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 0x20) == 0) {
                        this.t$macro$11 = ConfigReader$.MODULE$.optionConfigReader(this.t$macro$12());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                    }
                }
                return this.t$macro$11;
            }

            public ConfigReader<Option<Option<DataObjectMetadata>>> t$macro$11() {
                return (byte)(this.bitmap$0 & 0x20) == 0 ? this.t$macro$11$lzycompute() : this.t$macro$11;
            }

            public static final /* synthetic */ SplunkDataObject $anonfun$t$macro$2$9(anon.2 $this, String a$macro$4, SplunkParams a$macro$6, String a$macro$8, Option a$macro$10) {
                return new SplunkDataObject(a$macro$4, a$macro$6, a$macro$8, (Option<DataObjectMetadata>)((Option)a$macro$10.getOrElse((Function0 & Serializable & scala.Serializable)() -> SplunkDataObject$.MODULE$.$lessinit$greater$default$4())), $this.instanceRegistry$1);
            }
            {
                this.instanceRegistry$1 = instanceRegistry$1;
                this.n$macro$1 = SplunkDataObject$.MODULE$.sdlDefaultNaming();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$t$macro$2$7(io.smartdatalake.workflow.dataobject.SplunkDataObject$$anon$2 com.typesafe.config.Config ), $anonfun$t$macro$2$10(), $anonfun$t$macro$2$8(scala.Tuple2 ), $anonfun$t$macro$2$9$adapted(io.smartdatalake.workflow.dataobject.SplunkDataObject$$anon$2 java.lang.Object io.smartdatalake.workflow.dataobject.SplunkParams java.lang.Object scala.Option )}, serializedLambda);
            }
        }.t$macro$2());
    }

    public SplunkDataObject apply(String id, SplunkParams params, String connectionId, Option<DataObjectMetadata> metadata, InstanceRegistry instanceRegistry) {
        return new SplunkDataObject(id, params, connectionId, metadata, instanceRegistry);
    }

    public Option<DataObjectMetadata> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<SdlConfigObject.DataObjectId, SplunkParams, SdlConfigObject.ConnectionId, Option<DataObjectMetadata>>> unapply(SplunkDataObject x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)new SdlConfigObject.DataObjectId(x$0.id()), (Object)x$0.params(), (Object)new SdlConfigObject.ConnectionId(x$0.connectionId()), x$0.metadata()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SplunkDataObject$() {
        MODULE$ = this;
        ConfigImplicits.$init$((ConfigImplicits)this);
        FromConfigFactory.$init$((FromConfigFactory)this);
        this.SF_TIME_FORMAT = "yyyy-MM-dd HH:mm";
        this.splunkParamsReader = new Object(){
            private ConfigReader<SplunkParams> t$macro$2;
            private ConfigReader<String> t$macro$5;
            private ConfigReader<LocalDateTime> t$macro$7;
            private ConfigReader<Duration> t$macro$11;
            private ConfigReader<Option<Duration>> t$macro$10;
            private ConfigReader<Seq<String>> t$macro$14;
            private ConfigReader<Option<Seq<String>>> t$macro$13;
            private ConfigReader<Object> t$macro$17;
            private ConfigReader<Option<Object>> t$macro$16;
            private final ConfigKeyNaming<SplunkParams> n$macro$1;
            private volatile int bitmap$0;

            public ConfigKeyNaming<SplunkParams> n$macro$1() {
                return this.n$macro$1;
            }

            private ConfigReader<SplunkParams> t$macro$2$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 1) == 0) {
                        this.t$macro$2 = ConfigReader$.MODULE$.fromConfig((Function1 & Serializable & scala.Serializable)c$macro$3 -> {
                            Nil$ nil$;
                            Nil$ nil$2;
                            if (this.n$macro$1().failOnSuperfluousKeys()) {
                                List configKeys = ConfigUtil$.MODULE$.getRootKeys(c$macro$3);
                                List paramKeys = (List)new .colon.colon((Object)this.n$macro$1().apply("query"), (List)new .colon.colon((Object)this.n$macro$1().apply("queryFrom"), (List)new .colon.colon((Object)this.n$macro$1().apply("queryTo"), (List)new .colon.colon((Object)this.n$macro$1().apply("queryTimeInterval"), (List)new .colon.colon((Object)this.n$macro$1().apply("columnNames"), (List)new .colon.colon((Object)this.n$macro$1().apply("parallelRequests"), (List)Nil$.MODULE$)))))).flatten((Function1)Predef$.MODULE$.$conforms());
                                nil$2 = (List)ConfigUtil$.MODULE$.getSuperfluousKeys(configKeys, paramKeys).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                    Tuple2 tuple2 = x0$1;
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    String key = (String)tuple2._1();
                                    List similarParams = (List)tuple2._2();
                                    String string = new StringBuilder(0).append(key).append((Object)(similarParams.nonEmpty() ? new StringBuilder(17).append(" (did you mean ").append(similarParams.mkString(", ")).append("?)").toString() : "")).toString();
                                    return string;
                                }, List$.MODULE$.canBuildFrom());
                            } else {
                                nil$2 = nil$ = Nil$.MODULE$;
                            }
                            Result result = Nil$.MODULE$.equals(nil$) ? Result$.MODULE$.apply6(this.t$macro$5().read(c$macro$3, this.n$macro$1().apply("query")), this.t$macro$7().read(c$macro$3, this.n$macro$1().apply("queryFrom")), this.t$macro$7().read(c$macro$3, this.n$macro$1().apply("queryTo")), this.t$macro$10().read(c$macro$3, this.n$macro$1().apply("queryTimeInterval")), this.t$macro$13().read(c$macro$3, this.n$macro$1().apply("columnNames")), this.t$macro$16().read(c$macro$3, this.n$macro$1().apply("parallelRequests")), (Function6 & Serializable & scala.Serializable)(a$macro$4, a$macro$6, a$macro$8, a$macro$9, a$macro$12, a$macro$15) -> new SplunkParams((String)a$macro$4, (LocalDateTime)a$macro$6, (LocalDateTime)a$macro$8, (Duration)a$macro$9.getOrElse((Function0 & Serializable & scala.Serializable)() -> SplunkParams$.MODULE$.$lessinit$greater$default$4()), (Seq<String>)((Seq)a$macro$12.getOrElse((Function0 & Serializable & scala.Serializable)() -> SplunkParams$.MODULE$.$lessinit$greater$default$5())), BoxesRunTime.unboxToInt((Object)a$macro$15.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> SplunkParams$.MODULE$.$lessinit$greater$default$6())))) : Result$.MODULE$.failure(ConfigError$.MODULE$.apply(new StringBuilder(26).append("Superfluous key(s) found: ").append(nil$.mkString(", ")).toString()));
                            return result;
                        });
                        this.bitmap$0 |= 1;
                    }
                }
                return this.t$macro$2;
            }

            public ConfigReader<SplunkParams> t$macro$2() {
                return (this.bitmap$0 & 1) == 0 ? this.t$macro$2$lzycompute() : this.t$macro$2;
            }

            private ConfigReader<String> t$macro$5$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 2) == 0) {
                        this.t$macro$5 = ConfigReader$.MODULE$.apply(ConfigReader$.MODULE$.stringConfigReader());
                        this.bitmap$0 |= 2;
                    }
                }
                return this.t$macro$5;
            }

            public ConfigReader<String> t$macro$5() {
                return (this.bitmap$0 & 2) == 0 ? this.t$macro$5$lzycompute() : this.t$macro$5;
            }

            private ConfigReader<LocalDateTime> t$macro$7$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 4) == 0) {
                        this.t$macro$7 = ConfigReader$.MODULE$.apply(SplunkDataObject$.MODULE$.splunkLocalDateTimeReader());
                        this.bitmap$0 |= 4;
                    }
                }
                return this.t$macro$7;
            }

            public ConfigReader<LocalDateTime> t$macro$7() {
                return (this.bitmap$0 & 4) == 0 ? this.t$macro$7$lzycompute() : this.t$macro$7;
            }

            private ConfigReader<Duration> t$macro$11$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 8) == 0) {
                        this.t$macro$11 = ConfigReader$.MODULE$.apply(SplunkDataObject$.MODULE$.splunkDurationReader());
                        this.bitmap$0 |= 8;
                    }
                }
                return this.t$macro$11;
            }

            public ConfigReader<Duration> t$macro$11() {
                return (this.bitmap$0 & 8) == 0 ? this.t$macro$11$lzycompute() : this.t$macro$11;
            }

            private ConfigReader<Option<Duration>> t$macro$10$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x10) == 0) {
                        this.t$macro$10 = ConfigReader$.MODULE$.optionConfigReader(this.t$macro$11());
                        this.bitmap$0 |= 0x10;
                    }
                }
                return this.t$macro$10;
            }

            public ConfigReader<Option<Duration>> t$macro$10() {
                return (this.bitmap$0 & 0x10) == 0 ? this.t$macro$10$lzycompute() : this.t$macro$10;
            }

            private ConfigReader<Seq<String>> t$macro$14$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x20) == 0) {
                        this.t$macro$14 = ConfigReader$.MODULE$.apply(ConfigReader$.MODULE$.cbfJListConfigReader(ConfigReader$.MODULE$.javaListConfigReader(ConfigReader$.MODULE$.stringConfigReader()), Predef$.MODULE$.fallbackStringCanBuildFrom()));
                        this.bitmap$0 |= 0x20;
                    }
                }
                return this.t$macro$14;
            }

            public ConfigReader<Seq<String>> t$macro$14() {
                return (this.bitmap$0 & 0x20) == 0 ? this.t$macro$14$lzycompute() : this.t$macro$14;
            }

            private ConfigReader<Option<Seq<String>>> t$macro$13$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x40) == 0) {
                        this.t$macro$13 = ConfigReader$.MODULE$.optionConfigReader(this.t$macro$14());
                        this.bitmap$0 |= 0x40;
                    }
                }
                return this.t$macro$13;
            }

            public ConfigReader<Option<Seq<String>>> t$macro$13() {
                return (this.bitmap$0 & 0x40) == 0 ? this.t$macro$13$lzycompute() : this.t$macro$13;
            }

            private ConfigReader<Object> t$macro$17$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x80) == 0) {
                        this.t$macro$17 = ConfigReader$.MODULE$.apply(ConfigReader$.MODULE$.intConfigReader());
                        this.bitmap$0 |= 0x80;
                    }
                }
                return this.t$macro$17;
            }

            public ConfigReader<Object> t$macro$17() {
                return (this.bitmap$0 & 0x80) == 0 ? this.t$macro$17$lzycompute() : this.t$macro$17;
            }

            private ConfigReader<Option<Object>> t$macro$16$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x100) == 0) {
                        this.t$macro$16 = ConfigReader$.MODULE$.optionConfigReader(this.t$macro$17());
                        this.bitmap$0 |= 0x100;
                    }
                }
                return this.t$macro$16;
            }

            public ConfigReader<Option<Object>> t$macro$16() {
                return (this.bitmap$0 & 0x100) == 0 ? this.t$macro$16$lzycompute() : this.t$macro$16;
            }
            {
                this.n$macro$1 = SplunkDataObject$.MODULE$.sdlDefaultNaming();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$t$macro$2$1(io.smartdatalake.workflow.dataobject.SplunkDataObject$$anon$1 com.typesafe.config.Config ), $anonfun$t$macro$2$4(), $anonfun$t$macro$2$5(), $anonfun$t$macro$2$6(), $anonfun$t$macro$2$2(scala.Tuple2 ), $anonfun$t$macro$2$3(java.lang.String java.time.LocalDateTime java.time.LocalDateTime scala.Option scala.Option scala.Option )}, serializedLambda);
            }
        }.t$macro$2();
        this.splunkLocalDateTimeReader = ConfigReader$.MODULE$.fromTry((Function2 & Serializable & scala.Serializable)(c, p) -> MODULE$.parseConfigDateTime(c.getString(p)));
        this.splunkDurationReader = ConfigReader$.MODULE$.fromTry((Function2 & Serializable & scala.Serializable)(c, p) -> MODULE$.parseConfigDuration(c.getInt(p)));
    }
}

