/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.dataobject;

import com.github.takezoe.scaladoc.Scaladoc;
import com.splunk.JobExportArgs;
import com.splunk.Service;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.ExecutionMode;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.PartitionValues;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.misc.SmartDataLakeLogger;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.workflow.ActionPipelineContext;
import io.smartdatalake.workflow.AtlasExportable;
import io.smartdatalake.workflow.DataFrameSubFeed;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.connection.SplunkConnection;
import io.smartdatalake.workflow.dataframe.GenericDataFrame;
import io.smartdatalake.workflow.dataframe.GenericDataType;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataobject.CanCreateDataFrame;
import io.smartdatalake.workflow.dataobject.CanCreateSparkDataFrame;
import io.smartdatalake.workflow.dataobject.ConnectionTestException;
import io.smartdatalake.workflow.dataobject.DataObject;
import io.smartdatalake.workflow.dataobject.DataObjectMetadata;
import io.smartdatalake.workflow.dataobject.Expectation;
import io.smartdatalake.workflow.dataobject.HousekeepingMode;
import io.smartdatalake.workflow.dataobject.QueryTimeInterval;
import io.smartdatalake.workflow.dataobject.SplunkDataObject$;
import io.smartdatalake.workflow.dataobject.SplunkParams;
import io.smartdatalake.workflow.dataobject.SplunkService;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n * [[DataObject]] of type Splunk.\n * Provides details to an action to access Splunk logs.\n */")
@ScalaSignature(bytes="\u0006\u0001\r]e\u0001\u0002\u001e<\u0001\u0012C\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0005\u0018\u0005\t_\u0002\u0011\t\u0012)A\u0005;\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005v\u0001\tE\t\u0015!\u0003s\u0011!1\bA!f\u0001\n\u00039\b\u0002C>\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u0011q\u0004!Q3A\u0005BuD\u0011\"!\u0003\u0001\u0005#\u0005\u000b\u0011\u0002@\t\u0015\u0005-\u0001A!A!\u0002\u0017\ti\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\u000b\t\u0013\u0005]\u0003A1A\u0005\f\u0005e\u0003\u0002CAF\u0001\u0001\u0006I!a\u0017\t\u0013\u00055\u0005A1A\u0005\f\u0005=\u0005\u0002CAM\u0001\u0001\u0006I!!%\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"I\u0011q\u001c\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001d\u0005\b\u0003o\u0004A\u0011IA}\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u0011\t\u001d\u0003\u0001\"\u0001<\u0005\u0013BqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\u0004\u0002!\tE!\"\t\u0013\t5\u0005!!A\u0005\u0002\t=\u0005\"\u0003BO\u0001E\u0005I\u0011\u0001BP\u0011%\u0011\u0019\u000bAI\u0001\n\u0003\u0011)\u000bC\u0005\u0003*\u0002\t\n\u0011\"\u0001\u0003,\"I!q\u0016\u0001\u0012\u0002\u0013\u0005!\u0011\u0017\u0005\n\u0005k\u0003\u0011\u0011!C!\u0005oC\u0011Ba1\u0001\u0003\u0003%\tA!2\t\u0013\t5\u0007!!A\u0005\u0002\t=\u0007\"\u0003Bn\u0001\u0005\u0005I\u0011\tBo\u0011%\u0011Y\u000fAA\u0001\n\u0003\u0011i\u000fC\u0005\u0003x\u0002\t\t\u0011\"\u0011\u0003z\"I!1 \u0001\u0002\u0002\u0013\u0005#Q \u0005\n\u0005\u007f\u0004\u0011\u0011!C!\u0007\u00039qaa\u0003<\u0011\u0003\u0019iA\u0002\u0004;w!\u00051q\u0002\u0005\b\u0003+AC\u0011AB\t\u0011%\u0019\u0019\u0002\u000bb\u0001\n\u0013\u00119\f\u0003\u0005\u0004\u0016!\u0002\u000b\u0011\u0002B]\u0011\u001d\u00199\u0002\u000bC\u0001\u00073Aqaa\t)\t\u0003\u0019)\u0003C\u0005\u00040!\u0012\r\u0011b\u0001\u00042!A1q\b\u0015!\u0002\u0013\u0019\u0019\u0004C\u0005\u0004B!\u0012\r\u0011b\u0001\u0004D!A1q\t\u0015!\u0002\u0013\u0019)\u0005C\u0005\u0004J!\u0012\r\u0011b\u0001\u0004L!A1q\n\u0015!\u0002\u0013\u0019i\u0005C\u0004\u0004R!\"\tea\u0015\t\u0013\r%\u0004&!A\u0005\u0002\u000e-\u0004\"CB=QE\u0005I\u0011\u0001BY\u0011%\u0019Y\bKA\u0001\n\u0003\u001bi\bC\u0005\u0004\f\"\n\n\u0011\"\u0001\u00032\"I1Q\u0012\u0015\u0002\u0002\u0013%1q\u0012\u0002\u0011'BdWO\\6ECR\fwJ\u00196fGRT!\u0001P\u001f\u0002\u0015\u0011\fG/Y8cU\u0016\u001cGO\u0003\u0002?\u007f\u0005Aqo\u001c:lM2|wO\u0003\u0002A\u0003\u0006i1/\\1si\u0012\fG/\u00197bW\u0016T\u0011AQ\u0001\u0003S>\u001c\u0001aE\u0004\u0001\u000b.{%+\u0016-\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\taU*D\u0001<\u0013\tq5H\u0001\u0006ECR\fwJ\u00196fGR\u0004\"\u0001\u0014)\n\u0005E[$aF\"b]\u000e\u0013X-\u0019;f'B\f'o\u001b#bi\u00064%/Y7f!\ta5+\u0003\u0002Uw\ti1\u000b\u001d7v].\u001cVM\u001d<jG\u0016\u0004\"A\u0012,\n\u0005];%a\u0002)s_\u0012,8\r\u001e\t\u0003\rfK!AW$\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0005%$W#A/\u0011\u0005ycgBA0j\u001d\t\u0001wM\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011AmQ\u0001\u0007yI|w\u000e\u001e \n\u0003\tK!\u0001Q!\n\u0005!|\u0014AB2p]\u001aLw-\u0003\u0002kW\u0006y1\u000b\u001a7D_:4\u0017nZ(cU\u0016\u001cGO\u0003\u0002i\u007f%\u0011QN\u001c\u0002\r\t\u0006$\u0018m\u00142kK\u000e$\u0018\n\u001a\u0006\u0003U.\f1!\u001b3!\u0003\u0019\u0001\u0018M]1ngV\t!\u000f\u0005\u0002Mg&\u0011Ao\u000f\u0002\r'BdWO\\6QCJ\fWn]\u0001\ba\u0006\u0014\u0018-\\:!\u00031\u0019wN\u001c8fGRLwN\\%e+\u0005A\bC\u00010z\u0013\tQhN\u0001\u0007D_:tWm\u0019;j_:LE-A\u0007d_:tWm\u0019;j_:LE\rI\u0001\t[\u0016$\u0018\rZ1uCV\ta\u0010\u0005\u0003G\u007f\u0006\r\u0011bAA\u0001\u000f\n1q\n\u001d;j_:\u00042\u0001TA\u0003\u0013\r\t9a\u000f\u0002\u0013\t\u0006$\u0018m\u00142kK\u000e$X*\u001a;bI\u0006$\u0018-A\u0005nKR\fG-\u0019;bA\u0005\u0001\u0012N\\:uC:\u001cWMU3hSN$(/\u001f\t\u0005\u0003\u001f\t\t\"D\u0001l\u0013\r\t\u0019b\u001b\u0002\u0011\u0013:\u001cH/\u00198dKJ+w-[:uef\fa\u0001P5oSRtDCCA\r\u0003?\t\t#a\t\u0002&Q!\u00111DA\u000f!\ta\u0005\u0001C\u0004\u0002\f)\u0001\u001d!!\u0004\t\u000bmS\u0001\u0019A/\t\u000bAT\u0001\u0019\u0001:\t\u000bYT\u0001\u0019\u0001=\t\u000fqT\u0001\u0013!a\u0001}\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003ci!!a\f\u000b\u0007\u0005\u001dR(\u0003\u0003\u00024\u0005=\"\u0001E*qYVt7nQ8o]\u0016\u001cG/[8o\u0003-\u0019wN\u001c8fGRLwN\u001c\u0011)\u000f1\tI$!\u0015\u0002TA!\u00111HA'\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001C:dC2\fGm\\2\u000b\t\u0005\r\u0013QI\u0001\bi\u0006\\WM_8f\u0015\u0011\t9%!\u0013\u0002\r\u001dLG\u000f[;c\u0015\t\tY%A\u0002d_6LA!a\u0014\u0002>\tA1kY1mC\u0012|7-A\u0003wC2,X-\t\u0002\u0002V\u0005\u0001vF\u000b\u0016\u000bA\u0001\u0002#\u0006I\"p]:,7\r^5p]\u0002\"WMZ5oKN\u0004\u0003n\\:uY\u0001\u0002xN\u001d;!C:$\u0007e\u0019:fI\u0016tG/[1mg\u0002Jg\u000eI2f]R\u0014\u0018\r\u001c\u0011m_\u000e\fG/[8o\u0015\u0001\u0002\u0003EK\u0018\u0002\u001bI|woU3r\u000b:\u001cw\u000eZ3s+\t\tY\u0006\u0005\u0004\u0002^\u0005=\u00141O\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005\u00191/\u001d7\u000b\t\u0005\u0015\u0014qM\u0001\u0006gB\f'o\u001b\u0006\u0005\u0003S\nY'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003[\n1a\u001c:h\u0013\u0011\t\t(a\u0018\u0003\u000f\u0015s7m\u001c3feB1\u0011QOA@\u0003\u000bsA!a\u001e\u0002|9\u0019!-!\u001f\n\u0003!K1!! H\u0003\u001d\u0001\u0018mY6bO\u0016LA!!!\u0002\u0004\n\u00191+Z9\u000b\u0007\u0005ut\t\u0005\u0003\u0002^\u0005\u001d\u0015\u0002BAE\u0003?\u00121AU8x\u00039\u0011xn^*fc\u0016s7m\u001c3fe\u0002\n\u0001$];fef$\u0016.\\3J]R,'O^1m\u000b:\u001cw\u000eZ3s+\t\t\t\n\u0005\u0004\u0002^\u0005=\u00141\u0013\t\u0004\u0019\u0006U\u0015bAALw\t\t\u0012+^3ssRKW.Z%oi\u0016\u0014h/\u00197\u00023E,XM]=US6,\u0017J\u001c;feZ\fG.\u00128d_\u0012,'\u000fI\u0001\u0012O\u0016$8\u000b]1sW\u0012\u000bG/\u0019$sC6,G\u0003BAP\u0003\u0013$B!!)\u0002>B!\u00111UA\\\u001d\u0011\t)+!.\u000f\t\u0005\u001d\u00161\u0017\b\u0005\u0003S\u000b\tL\u0004\u0003\u0002,\u0006=fb\u00012\u0002.&\u0011\u0011QN\u0005\u0005\u0003S\nY'\u0003\u0003\u0002f\u0005\u001d\u0014\u0002BA1\u0003GJA!! \u0002`%!\u0011\u0011XA^\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002~\u0005}\u0003bBA`#\u0001\u000f\u0011\u0011Y\u0001\bG>tG/\u001a=u!\u0011\t\u0019-!2\u000e\u0003uJ1!a2>\u0005U\t5\r^5p]BK\u0007/\u001a7j]\u0016\u001cuN\u001c;fqRD\u0011\"a3\u0012!\u0003\u0005\r!!4\u0002\u001fA\f'\u000f^5uS>tg+\u00197vKN\u0004b!!\u001e\u0002\u0000\u0005=\u0007\u0003BAi\u00037l!!a5\u000b\t\u0005U\u0017q[\u0001\u0005Q\u001247OC\u0002\u0002Z~\nA!\u001e;jY&!\u0011Q\\Aj\u0005=\u0001\u0016M\u001d;ji&|gNV1mk\u0016\u001c\u0018aG4fiN\u0003\u0018M]6ECR\fgI]1nK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002d*\"\u0011QZAsW\t\t9\u000f\u0005\u0003\u0002j\u0006MXBAAv\u0015\u0011\ti/a<\u0002\u0013Ut7\r[3dW\u0016$'bAAy\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00181\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00029sKB\f'/\u001a\u000b\u0005\u0003w\u0014\t\u0001E\u0002G\u0003{L1!a@H\u0005\u0011)f.\u001b;\t\u000f\u0005}6\u0003q\u0001\u0002B\u0006q!/Z1e\rJ|Wn\u00159mk:\\G\u0003\u0002B\u0004\u0005\u0017!B!!)\u0003\n!9\u0011q\u0018\u000bA\u0004\u0005\u0005\u0007\"\u00029\u0015\u0001\u0004\u0011\u0018A\u0005:fC\u0012\u0014vn^:Ge>l7\u000b\u001d7v].$b!a\u001d\u0003\u0012\tU\u0001b\u0002B\n+\u0001\u0007\u00111S\u0001\tS:$XM\u001d<bY\")\u0001/\u0006a\u0001e\u0006yAO]1og\u001a|'/\u001c+p%><8\u000f\u0006\u0004\u0002t\tm!q\u0007\u0005\b\u0005;1\u0002\u0019\u0001B\u0010\u00035\u0019X-\u0019:dQJ+7/\u001e7ugB1\u0011QOA@\u0005C\u0001\u0002Ba\t\u0003,\tE\"\u0011\u0007\b\u0005\u0005K\u00119\u0003\u0005\u0002c\u000f&\u0019!\u0011F$\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iCa\f\u0003\u00075\u000b\u0007OC\u0002\u0003*\u001d\u0003BAa\t\u00034%!!Q\u0007B\u0018\u0005\u0019\u0019FO]5oO\"9!\u0011\b\fA\u0002\tm\u0012AB:dQ\u0016l\u0017\r\u0005\u0003\u0003>\t\rSB\u0001B \u0015\u0011\u0011\t%a\u0018\u0002\u000bQL\b/Z:\n\t\t\u0015#q\b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aD:qY&$\u0018+^3ssRKW.Z:\u0015\u0011\t-#1\fB8\u0005g\"BA!\u0014\u0003TA1\u0011Q\fB(\u0003'KAA!\u0015\u0002`\t9A)\u0019;bg\u0016$\bbBA3/\u0001\u000f!Q\u000b\t\u0005\u0003;\u00129&\u0003\u0003\u0003Z\u0005}#\u0001D*qCJ\\7+Z:tS>t\u0007b\u0002B//\u0001\u0007!qL\u0001\u0005MJ|W\u000e\u0005\u0003\u0003b\t-TB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\tQLW.\u001a\u0006\u0003\u0005S\nAA[1wC&!!Q\u000eB2\u00055aunY1m\t\u0006$X\rV5nK\"9!\u0011O\fA\u0002\t}\u0013A\u0001;p\u0011\u001d\u0011\u0019b\u0006a\u0001\u0005k\u0002BA!\u0019\u0003x%!!\u0011\u0010B2\u0005!!UO]1uS>t\u0017!\u0004<bY&$\u0017\r^3Rk\u0016\u0014\u0018\u0010\u0006\u0003\u00032\t}\u0004b\u0002BA1\u0001\u0007!\u0011G\u0001\u0006cV,'/_\u0001\bM\u0006\u001cGo\u001c:z+\t\u00119\tE\u0003\u0002\u0010\t%5*C\u0002\u0003\f.\u0014\u0011C\u0012:p[\u000e{gNZ5h\r\u0006\u001cGo\u001c:z\u0003\u0011\u0019w\u000e]=\u0015\u0015\tE%Q\u0013BL\u00053\u0013Y\n\u0006\u0003\u0002\u001c\tM\u0005bBA\u00065\u0001\u000f\u0011Q\u0002\u0005\b7j\u0001\n\u00111\u0001^\u0011\u001d\u0001(\u0004%AA\u0002IDqA\u001e\u000e\u0011\u0002\u0003\u0007\u0001\u0010C\u0004}5A\u0005\t\u0019\u0001@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0015\u0016\u0004;\u0006\u0015\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005OS3A]As\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!,+\u0007a\f)/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM&f\u0001@\u0002f\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!/\u0011\t\tm&\u0011Y\u0007\u0003\u0005{SAAa0\u0003h\u0005!A.\u00198h\u0013\u0011\u0011)D!0\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t\u001d\u0007c\u0001$\u0003J&\u0019!1Z$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tE'q\u001b\t\u0004\r\nM\u0017b\u0001Bk\u000f\n\u0019\u0011I\\=\t\u0013\te\u0017%!AA\u0002\t\u001d\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003`B1!\u0011\u001dBt\u0005#l!Aa9\u000b\u0007\t\u0015x)\u0001\u0006d_2dWm\u0019;j_:LAA!;\u0003d\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011yO!>\u0011\u0007\u0019\u0013\t0C\u0002\u0003t\u001e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003Z\u000e\n\t\u00111\u0001\u0003R\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003H\u0006AAo\\*ue&tw\r\u0006\u0002\u0003:\u00061Q-];bYN$BAa<\u0004\u0004!I!\u0011\u001c\u0014\u0002\u0002\u0003\u0007!\u0011\u001b\u0015\b\u0001\u0005e\u0012\u0011KB\u0004C\t\u0019I!A10U)R\u0001E\u000b\u0011\\7\u0012\u000bG/Y(cU\u0016\u001cG/X/!_\u001a\u0004C/\u001f9fAM\u0003H.\u001e8l])\u0001#\u0006\t)s_ZLG-Z:!I\u0016$\u0018-\u001b7tAQ|\u0007%\u00198!C\u000e$\u0018n\u001c8!i>\u0004\u0013mY2fgN\u00043\u000b\u001d7v].\u0004Cn\\4t])\u0001#fL\u0001\u0011'BdWO\\6ECR\fwJ\u00196fGR\u0004\"\u0001\u0014\u0015\u0014\u000b!*%q\u0011-\u0015\u0005\r5\u0011AD*G?RKU*R0G\u001fJk\u0015\tV\u0001\u0010'\u001a{F+S'F?\u001a{%+T!UA\u0005\u0019\u0002/\u0019:tK\u000e{gNZ5h\t\u0006$X\rV5nKR!!qLB\u000e\u0011\u001d\t\t\u0006\fa\u0001\u0005cAs\u0001LA\u001d\u0003#\u001ay\"\t\u0002\u0004\"\u0005\t)p\f\u0016+\u0015\u0001\u0002\u0003E\u000b\u0011QCJ\u001cX\rI1!7ncunY1m\t\u0006$X\rV5nKvk\u0006E\u001a:p[\u0002\n\u0007eW.Ta2,hn\u001b#bi\u0006|%M[3divk\u0006e\u0015#MA\r|gNZ5h])\u0001\u0003\u0005\t\u0016\u000bA\u0001\u0002#\u0006\t!qCJ\fW\u000e\t<bYV,\u0007%\u0019\u0011tiJLgn\u001a\u0011ta\u0016\u001c\u0017NZ=j]\u001e\u0004C\u000f[3!7ncunY1m\t\u0006$X\rV5nKvk\u0006%\u001b8!i\",\u0007%\u001a=qK\u000e$X\r\u001a\u0011g_Jl\u0017\r\u001e\u0018\u000bA\u0001\u0002#\u0006\t!sKR,(O\u001c\u0011!C\u0002rWm\u001e\u0011\\72{7-\u00197ECR,G+[7f;v\u0003\u0013N\\:uC:\u001cW\r\t:faJ,7/\u001a8uS:<\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007E^1mk\u0016t#\u0002\t\u0011!U=\n1\u0003]1sg\u0016\u001cuN\u001c4jO\u0012+(/\u0019;j_:$BA!\u001e\u0004(!9\u0011\u0011K\u0017A\u0002\t\u001d\u0007fB\u0017\u0002:\u0005E31F\u0011\u0003\u0007[\t\u00111\\\u0018+U)\u0001\u0003\u0005\t\u0016!!\u0006\u00148/\u001a\u0011bAm[F)\u001e:bi&|g.X/!MJ|W\u000eI1!7n\u001b\u0006\u000f\\;oW\u0012\u000bG/Y(cU\u0016\u001cG/X/!'\u0012c\u0005eY8oM&<gF\u0003\u0011!A)R\u0001\u0005\t\u0011+A\u0001\u0003\u0018M]1nAY\fG.^3!C:\u0004\u0013N\u001c;fO\u0016\u0014\be\u001d9fG&4\u00170\u001b8hAQDW\rI.\\\tV\u0014\u0018\r^5p]vk\u0006%\u001b8!i\",\u0007%\u001a=qK\u000e$X\r\u001a\u0011g_Jl\u0017\r\u001e\u0018\u000bA\u0001\u0002#\u0006\t!sKR,(O\u001c\u0011!C\u0002rWm\u001e\u0011\\7\u0012+(/\u0019;j_:lV\fI5ogR\fgnY3!e\u0016\u0004(/Z:f]RLgn\u001a\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011wC2,XM\f\u0006!A\u0001Rs&\u0001\nta2,hn\u001b)be\u0006l7OU3bI\u0016\u0014XCAB\u001a!\u0015\u0019)da\u000fs\u001b\t\u00199D\u0003\u0002\u0004:\u000591m\u001c8gS\u001e\u001c\u0018\u0002BB\u001f\u0007o\u0011AbQ8oM&<'+Z1eKJ\f1c\u001d9mk:\\\u0007+\u0019:b[N\u0014V-\u00193fe\u0002\n\u0011d\u001d9mk:\\Gj\\2bY\u0012\u000bG/\u001a+j[\u0016\u0014V-\u00193feV\u00111Q\t\t\u0007\u0007k\u0019YDa\u0018\u00025M\u0004H.\u001e8l\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3SK\u0006$WM\u001d\u0011\u0002)M\u0004H.\u001e8l\tV\u0014\u0018\r^5p]J+\u0017\rZ3s+\t\u0019i\u0005\u0005\u0004\u00046\rm\"QO\u0001\u0016gBdWO\\6EkJ\fG/[8o%\u0016\fG-\u001a:!\u0003)1'o\\7D_:4\u0017n\u001a\u000b\u0005\u0007+\u001aI\u0006\u0006\u0003\u0002\u001c\r]\u0003bBA\u0006i\u0001\u000f\u0011Q\u0002\u0005\u0007QR\u0002\raa\u0017\u0011\t\ru3QM\u0007\u0003\u0007?R1\u0001[B1\u0015\u0011\u0019\u0019'!\u0013\u0002\u0011QL\b/Z:bM\u0016LAaa\u001a\u0004`\t11i\u001c8gS\u001e\fQ!\u00199qYf$\"b!\u001c\u0004r\rM4QOB<)\u0011\tYba\u001c\t\u000f\u0005-Q\u0007q\u0001\u0002\u000e!)1,\u000ea\u0001;\")\u0001/\u000ea\u0001e\")a/\u000ea\u0001q\"9A0\u000eI\u0001\u0002\u0004q\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!1qPBD!\u00111up!!\u0011\u000f\u0019\u001b\u0019)\u0018:y}&\u00191QQ$\u0003\rQ+\b\u000f\\35\u0011%\u0019IiNA\u0001\u0002\u0004\tY\"A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!%\u0011\t\tm61S\u0005\u0005\u0007+\u0013iL\u0001\u0004PE*,7\r\u001e")
public class SplunkDataObject
implements DataObject,
CanCreateSparkDataFrame,
SplunkService,
Product,
scala.Serializable {
    private final String id;
    private final SplunkParams params;
    private final String connectionId;
    private final Option<DataObjectMetadata> metadata;
    @Scaladoc(value="/**\n   * Connection defines host, port and credentials in central location\n   */")
    private final SplunkConnection connection;
    private final Encoder<Seq<Row>> rowSeqEncoder;
    private final Encoder<QueryTimeInterval> queryTimeIntervalEncoder;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<DataObjectMetadata> $lessinit$greater$default$4() {
        return SplunkDataObject$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<SdlConfigObject.DataObjectId, SplunkParams, SdlConfigObject.ConnectionId, Option<DataObjectMetadata>>> unapply(SplunkDataObject splunkDataObject) {
        return SplunkDataObject$.MODULE$.unapply(splunkDataObject);
    }

    public static Option<DataObjectMetadata> apply$default$4() {
        return SplunkDataObject$.MODULE$.apply$default$4();
    }

    public static SplunkDataObject apply(String string, SplunkParams splunkParams, String string2, Option<DataObjectMetadata> option, InstanceRegistry instanceRegistry) {
        return SplunkDataObject$.MODULE$.apply(string, splunkParams, string2, option, instanceRegistry);
    }

    public static SplunkDataObject fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return SplunkDataObject$.MODULE$.fromConfig(config, instanceRegistry);
    }

    public static ConfigReader<Duration> splunkDurationReader() {
        return SplunkDataObject$.MODULE$.splunkDurationReader();
    }

    public static ConfigReader<LocalDateTime> splunkLocalDateTimeReader() {
        return SplunkDataObject$.MODULE$.splunkLocalDateTimeReader();
    }

    public static ConfigReader<SplunkParams> splunkParamsReader() {
        return SplunkDataObject$.MODULE$.splunkParamsReader();
    }

    @Scaladoc(value="/**\n   * Parse a [[Duration]] from a [[SplunkDataObject]] SDL config.\n   *\n   * @param value an integer specifying the [[Duration]] in the expected format.\n   * @return  a new [[Duration]] instance representing the specified value.\n   */")
    public static Duration parseConfigDuration(int n) {
        return SplunkDataObject$.MODULE$.parseConfigDuration(n);
    }

    @Scaladoc(value="/**\n   * Parse a [[LocalDateTime]] from a [[SplunkDataObject]] SDL config.\n   *\n   * @param value a string specifying the [[LocalDateTime]] in the expected format.\n   * @return  a new [[LocalDateTime]] instance representing the specified value.\n   */")
    public static LocalDateTime parseConfigDateTime(String string) {
        return SplunkDataObject$.MODULE$.parseConfigDateTime(string);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return SplunkDataObject$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return SplunkDataObject$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return SplunkDataObject$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return SplunkDataObject$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return SplunkDataObject$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return SplunkDataObject$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return SplunkDataObject$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return SplunkDataObject$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return SplunkDataObject$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return SplunkDataObject$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return SplunkDataObject$.MODULE$.conditionReader();
    }

    public static ConfigReader<ExecutionMode> executionModeReader() {
        return SplunkDataObject$.MODULE$.executionModeReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return SplunkDataObject$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return SplunkDataObject$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return SplunkDataObject$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return SplunkDataObject$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return SplunkDataObject$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return SplunkDataObject$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return SplunkDataObject$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return SplunkDataObject$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return SplunkDataObject$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[StructType]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   * See [[SchemaProviderType]] for available providers.\n   */")
    public static ConfigReader<StructType> structTypeReader() {
        return SplunkDataObject$.MODULE$.structTypeReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return SplunkDataObject$.MODULE$.sdlDefaultNaming();
    }

    @Override
    public JobExportArgs createJobExportArgs(LocalDateTime queryFrom, LocalDateTime queryTo) {
        return SplunkService.createJobExportArgs$(this, queryFrom, queryTo);
    }

    @Override
    public Seq<Map<String, String>> readFromSplunk(String query, JobExportArgs searchArgs, Service splunk) {
        return SplunkService.readFromSplunk$(this, query, searchArgs, splunk);
    }

    @Scaladoc(value="/**\n   * Configured options for the Spark [[DataFrameReader]]/[[DataFrameWriter]].\n   *\n   * @see [[DataFrameReader]]\n   * @see [[DataFrameWriter]]\n   */")
    public Map<String, String> options() {
        return CanCreateSparkDataFrame.options$((CanCreateSparkDataFrame)this);
    }

    public GenericDataFrame getDataFrame(Seq<PartitionValues> partitionValues, Types.TypeApi subFeedType, ActionPipelineContext context) {
        return CanCreateSparkDataFrame.getDataFrame$((CanCreateSparkDataFrame)this, partitionValues, (Types.TypeApi)subFeedType, (ActionPipelineContext)context);
    }

    public Seq<PartitionValues> getDataFrame$default$1() {
        return CanCreateSparkDataFrame.getDataFrame$default$1$((CanCreateSparkDataFrame)this);
    }

    public DataFrameSubFeed getSubFeed(Seq<PartitionValues> partitionValues, Types.TypeApi subFeedType, ActionPipelineContext context) {
        return CanCreateSparkDataFrame.getSubFeed$((CanCreateSparkDataFrame)this, partitionValues, (Types.TypeApi)subFeedType, (ActionPipelineContext)context);
    }

    public Seq<PartitionValues> getSubFeed$default$1() {
        return CanCreateSparkDataFrame.getSubFeed$default$1$((CanCreateSparkDataFrame)this);
    }

    public Seq<Types.TypeApi> getSubFeedSupportedTypes() {
        return CanCreateSparkDataFrame.getSubFeedSupportedTypes$((CanCreateSparkDataFrame)this);
    }

    @Scaladoc(value="/**\n   * Creates the read schema based on a given write schema.\n   * Normally this is the same, but some DataObjects can remove & add columns on read (e.g. KafkaTopicDataObject, SparkFileDataObject)\n   * In this cases we have to break the DataFrame lineage und create a dummy DataFrame in init phase.\n   */")
    public GenericSchema createReadSchema(GenericSchema writeSchema, ActionPipelineContext context) {
        return CanCreateDataFrame.createReadSchema$((CanCreateDataFrame)this, (GenericSchema)writeSchema, (ActionPipelineContext)context);
    }

    public GenericSchema addFieldIfNotExisting(GenericSchema writeSchema, String colName, GenericDataType dataType) {
        return CanCreateDataFrame.addFieldIfNotExisting$((CanCreateDataFrame)this, (GenericSchema)writeSchema, (String)colName, (GenericDataType)dataType);
    }

    @Scaladoc(value="/**\n   * Configure a housekeeping mode to e.g cleanup, archive and compact partitions.\n   * Default is None.\n   */")
    public Option<HousekeepingMode> housekeepingMode() {
        return DataObject.housekeepingMode$((DataObject)this);
    }

    @Scaladoc(value="/**\n   * Runs operations before reading from [[DataObject]]\n   */")
    public void preRead(Seq<PartitionValues> partitionValues, ActionPipelineContext context) {
        DataObject.preRead$((DataObject)this, partitionValues, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Runs operations after reading from [[DataObject]]\n   */")
    public void postRead(Seq<PartitionValues> partitionValues, ActionPipelineContext context) {
        DataObject.postRead$((DataObject)this, partitionValues, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Runs operations before writing to [[DataObject]]\n   * Note: As the transformed SubFeed doesnt yet exist in Action.preWrite, no partition values can be passed as parameters as in preRead\n   */")
    public void preWrite(ActionPipelineContext context) {
        DataObject.preWrite$((DataObject)this, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Runs operations after writing to [[DataObject]]\n   */")
    public void postWrite(Seq<PartitionValues> partitionValues, ActionPipelineContext context) {
        DataObject.postWrite$((DataObject)this, partitionValues, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Handle class cast exception when getting objects from instance registry\n   *\n   * @param connectionId\n   * @param registry\n   * @return\n   */")
    public <T extends Connection> T getConnection(String connectionId, InstanceRegistry registry, ClassTag<T> ct, TypeTags.TypeTag<T> tt) {
        return (T)DataObject.getConnection$((DataObject)this, (String)connectionId, (InstanceRegistry)registry, ct, tt);
    }

    public <T extends Connection> T getConnectionReg(String connectionId, InstanceRegistry registry, ClassTag<T> ct, TypeTags.TypeTag<T> tt) {
        return (T)DataObject.getConnectionReg$((DataObject)this, (String)connectionId, (InstanceRegistry)registry, ct, tt);
    }

    public String toStringShort() {
        return DataObject.toStringShort$((DataObject)this);
    }

    public String atlasName() {
        return DataObject.atlasName$((DataObject)this);
    }

    public String atlasQualifiedName(String prefix) {
        return AtlasExportable.atlasQualifiedName$((AtlasExportable)this, (String)prefix);
    }

    public void logAndThrowException(String msg, Exception e) {
        SmartDataLakeLogger.logAndThrowException$((SmartDataLakeLogger)this, (String)msg, (Exception)e);
    }

    public Exception logException(Exception e) {
        return SmartDataLakeLogger.logException$((SmartDataLakeLogger)this, (Exception)e);
    }

    public void logWithSeverity(Level severity, String msg) {
        SmartDataLakeLogger.logWithSeverity$((SmartDataLakeLogger)this, (Level)severity, (String)msg);
    }

    private Logger logger$lzycompute() {
        SplunkDataObject splunkDataObject = this;
        synchronized (splunkDataObject) {
            if (!this.bitmap$trans$0) {
                this.logger = SmartDataLakeLogger.logger$((SmartDataLakeLogger)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String id() {
        return this.id;
    }

    public SplunkParams params() {
        return this.params;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public Option<DataObjectMetadata> metadata() {
        return this.metadata;
    }

    private SplunkConnection connection() {
        return this.connection;
    }

    private Encoder<Seq<Row>> rowSeqEncoder() {
        return this.rowSeqEncoder;
    }

    private Encoder<QueryTimeInterval> queryTimeIntervalEncoder() {
        return this.queryTimeIntervalEncoder;
    }

    public Dataset<Row> getSparkDataFrame(Seq<PartitionValues> partitionValues, ActionPipelineContext context) {
        return this.readFromSplunk(this.params(), context);
    }

    public Seq<PartitionValues> getSparkDataFrame$default$1() {
        return (Seq)Nil$.MODULE$;
    }

    public void prepare(ActionPipelineContext context) {
        try {
            this.connection().test();
        }
        catch (Throwable ex) {
            throw new ConnectionTestException(new StringBuilder(27).append("(").append(new SdlConfigObject.DataObjectId(this.id())).append(") Can not connect. Error: ").append(ex.getMessage()).toString(), ex);
        }
    }

    private Dataset<Row> readFromSplunk(SplunkParams params, ActionPipelineContext context) {
        SparkSession session = context.sparkSession();
        Dataset queryTimeIntervals = this.splitQueryTimes(params.queryFrom(), params.queryTo(), params.queryTimeInterval(), session).repartition(params.parallelRequests());
        RDD searchResultRdd = queryTimeIntervals.map((Function1 & Serializable & scala.Serializable)interval -> this.readRowsFromSplunk((QueryTimeInterval)interval, params), this.rowSeqEncoder()).as(this.rowSeqEncoder()).rdd();
        RDD searchResultRddFlattened = searchResultRdd.flatMap((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x), ClassTag$.MODULE$.apply(Row.class));
        Dataset searchResultDf = session.createDataFrame(searchResultRddFlattened, params.schema());
        return searchResultDf;
    }

    private Seq<Row> readRowsFromSplunk(QueryTimeInterval interval, SplunkParams params) {
        Seq<Row> seq;
        Service splunk = this.connection().connectToSplunk();
        try {
            Seq<Row> searchResultRows;
            String queryValidated = this.validateQuery(params.query());
            JobExportArgs searchArgs = this.createJobExportArgs(interval.from(), interval.to());
            Seq<Map<String, String>> searchResult = this.readFromSplunk(queryValidated, searchArgs, splunk);
            seq = searchResultRows = this.transformToRows(searchResult, params.schema());
        }
        finally {
            if (splunk != null) {
                splunk.logout();
            }
        }
        return seq;
    }

    private Seq<Row> transformToRows(Seq<Map<String, String>> searchResults, StructType schema) {
        return (Seq)((TraversableLike)searchResults.map((Function1 & Serializable & scala.Serializable)item -> schema.length() == 1 ? new .colon.colon((Object)item.toString(), (List)Nil$.MODULE$) : (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).foldRight((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(name, acc) -> {
            String string = (String)item.getOrElse(name, (Function0 & Serializable & scala.Serializable)() -> "");
            return acc.$colon$colon((Object)string);
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> Row$.MODULE$.fromSeq((Seq)x$2), Seq$.MODULE$.canBuildFrom());
    }

    public Dataset<QueryTimeInterval> splitQueryTimes(LocalDateTime from, LocalDateTime to, Duration interval, SparkSession spark) {
        Seq queryTimes = this.splitQueryTimesAccum$1(from, to, (Seq)Nil$.MODULE$, interval);
        return spark.implicits().localSeqToDatasetHolder(queryTimes, this.queryTimeIntervalEncoder()).toDS();
    }

    private String validateQuery(String query) {
        String string;
        String string2;
        String string3 = query;
        if (string3 != null && !(string2 = string3).contains("index=")) {
            throw new IllegalArgumentException("Splunk queries should define the index the search should work on.");
        }
        String string4 = string3 != null && !(string = string3).startsWith("search") ? new StringBuilder(7).append("search ").append(query).toString() : query;
        return string4;
    }

    public FromConfigFactory<DataObject> factory() {
        return SplunkDataObject$.MODULE$;
    }

    public SplunkDataObject copy(String id, SplunkParams params, String connectionId, Option<DataObjectMetadata> metadata, InstanceRegistry instanceRegistry) {
        return new SplunkDataObject(id, params, connectionId, metadata, instanceRegistry);
    }

    public String copy$default$1() {
        return this.id();
    }

    public SplunkParams copy$default$2() {
        return this.params();
    }

    public String copy$default$3() {
        return this.connectionId();
    }

    public Option<DataObjectMetadata> copy$default$4() {
        return this.metadata();
    }

    public String productPrefix() {
        return "SplunkDataObject";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = new SdlConfigObject.DataObjectId(this.id());
                break;
            }
            case 1: {
                object = this.params();
                break;
            }
            case 2: {
                object = new SdlConfigObject.ConnectionId(this.connectionId());
                break;
            }
            case 3: {
                object = this.metadata();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SplunkDataObject;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SplunkDataObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        SplunkDataObject splunkDataObject = (SplunkDataObject)x$1;
        String string = this.id();
        String string2 = splunkDataObject.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        SplunkParams splunkParams = this.params();
        SplunkParams splunkParams2 = splunkDataObject.params();
        if (splunkParams == null) {
            if (splunkParams2 != null) {
                return false;
            }
        } else if (!((Object)splunkParams).equals(splunkParams2)) return false;
        String string3 = this.connectionId();
        String string4 = splunkDataObject.connectionId();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<DataObjectMetadata> option = this.metadata();
        Option<DataObjectMetadata> option2 = splunkDataObject.metadata();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!splunkDataObject.canEqual(this)) return false;
        return true;
    }

    private final Seq splitQueryTimesAccum$1(LocalDateTime from, LocalDateTime to, Seq accum, Duration interval$1) {
        Seq seq;
        while (true) {
            if (from.isAfter(to)) {
                seq = accum;
                break;
            }
            if (from.plus(interval$1).isAfter(to) || from.plus(interval$1).isEqual(to)) {
                seq = (Seq)accum.$colon$plus((Object)new QueryTimeInterval(from, to), Seq$.MODULE$.canBuildFrom());
                break;
            }
            accum = (Seq)accum.$colon$plus((Object)new QueryTimeInterval(from, from.plus(interval$1)), Seq$.MODULE$.canBuildFrom());
            from = from.plus(interval$1);
        }
        return seq;
    }

    public SplunkDataObject(String id, SplunkParams params, String connectionId, Option<DataObjectMetadata> metadata, InstanceRegistry instanceRegistry) {
        this.id = id;
        this.params = params;
        this.connectionId = connectionId;
        this.metadata = metadata;
        SdlConfigObject.$init$((SdlConfigObject)this);
        SmartDataLakeLogger.$init$((SmartDataLakeLogger)this);
        AtlasExportable.$init$((AtlasExportable)this);
        DataObject.$init$((DataObject)this);
        CanCreateDataFrame.$init$((CanCreateDataFrame)this);
        CanCreateSparkDataFrame.$init$((CanCreateSparkDataFrame)this);
        SplunkService.$init$(this);
        Product.$init$((Product)this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SplunkDataObject.class.getClassLoader());
        public final class Io_smartdatalake_workflow_dataobject_SplunkDataObject$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("io.smartdatalake.workflow.connection.SplunkConnection").asType().toTypeConstructor();
            }

            public Io_smartdatalake_workflow_dataobject_SplunkDataObject$$typecreator1$1(SplunkDataObject $outer) {
            }
        }
        this.connection = (SplunkConnection)this.getConnection(connectionId, instanceRegistry, ClassTag$.MODULE$.apply(SplunkConnection.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_smartdatalake_workflow_dataobject_SplunkDataObject$$typecreator1$1(null)));
        this.rowSeqEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Seq.class));
        this.queryTimeIntervalEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(QueryTimeInterval.class));
    }
}

