/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeRational
extends FieldType {
    public FieldTypeRational(int type, String name) {
        super(type, name, 8);
    }

    @Override
    public Object getValue(TiffField entry) {
        boolean unsignedType;
        byte[] bytes = entry.getByteArrayValue();
        boolean bl = unsignedType = entry.getFieldType() != SRATIONAL;
        if (entry.getCount() == 1L) {
            return ByteConversions.toRational(bytes, entry.getByteOrder(), unsignedType);
        }
        return ByteConversions.toRationals(bytes, entry.getByteOrder(), unsignedType);
    }

    @Override
    public byte[] writeData(Object o, ByteOrder byteOrder) throws ImageWriteException {
        if (o instanceof RationalNumber) {
            return ByteConversions.toBytes((RationalNumber)o, byteOrder);
        }
        if (o instanceof RationalNumber[]) {
            return ByteConversions.toBytes((RationalNumber[])o, byteOrder);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return ByteConversions.toBytes(RationalNumber.valueOf(number.doubleValue()), byteOrder);
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            RationalNumber[] rationalNumbers = new RationalNumber[numbers.length];
            Arrays.setAll(rationalNumbers, RationalNumber::valueOf);
            return ByteConversions.toBytes(rationalNumbers, byteOrder);
        }
        if (!(o instanceof double[])) {
            throw new ImageWriteException("Invalid data", o);
        }
        double[] numbers = (double[])o;
        RationalNumber[] rationalNumbers = new RationalNumber[numbers.length];
        Arrays.setAll(rationalNumbers, RationalNumber::valueOf);
        return ByteConversions.toBytes(rationalNumbers, byteOrder);
    }
}

