/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultShader
implements Shader {
    private static final int BUFFER_SIZE = 32768;
    private final Logger logger;

    public DefaultShader() {
        this(LoggerFactory.getLogger(DefaultShader.class));
    }

    public DefaultShader(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public void shade(ShadeRequest shadeRequest) throws IOException, MojoExecutionException {
        HashSet<String> resources = new HashSet<String>();
        ManifestResourceTransformer manifestTransformer = null;
        ArrayList<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>(shadeRequest.getResourceTransformers());
        Iterator it = transformers.iterator();
        while (it.hasNext()) {
            ResourceTransformer transformer = (ResourceTransformer)it.next();
            if (!(transformer instanceof ManifestResourceTransformer)) continue;
            manifestTransformer = (ManifestResourceTransformer)transformer;
            it.remove();
        }
        RelocatorRemapper remapper = new RelocatorRemapper(shadeRequest.getRelocators());
        shadeRequest.getUberJar().getParentFile().mkdirs();
        try (JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(shadeRequest.getUberJar())));){
            this.goThroughAllJarEntriesForManifestTransformer(shadeRequest, resources, manifestTransformer, out);
            HashSetValuedHashMap duplicates = new HashSetValuedHashMap(10000, 3);
            this.shadeJars(shadeRequest, resources, transformers, remapper, out, (MultiValuedMap<String, File>)duplicates);
            HashSetValuedHashMap overlapping = new HashSetValuedHashMap(20, 15);
            for (String clazz : duplicates.keySet()) {
                Collection jarz = duplicates.get((Object)clazz);
                if (jarz.size() <= 1) continue;
                overlapping.put((Object)jarz, (Object)clazz);
            }
            this.logSummaryOfDuplicates((MultiValuedMap<Collection<File>, String>)overlapping);
            if (overlapping.keySet().size() > 0) {
                this.showOverlappingWarning();
            }
            for (ResourceTransformer transformer : transformers) {
                if (!transformer.hasTransformedResource()) continue;
                transformer.modifyOutputStream(out);
            }
        }
        for (Filter filter : shadeRequest.getFilters()) {
            filter.finished();
        }
    }

    private void shadeJars(ShadeRequest shadeRequest, Set<String> resources, List<ResourceTransformer> transformers, RelocatorRemapper remapper, JarOutputStream jos, MultiValuedMap<String, File> duplicates) throws IOException, MojoExecutionException {
        for (File jar : shadeRequest.getJars()) {
            this.logger.debug("Processing JAR " + jar);
            List<Filter> jarFilters = this.getFilters(jar, shadeRequest.getFilters());
            JarFile jarFile = this.newJarFile(jar);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> j = jarFile.entries();
                while (j.hasMoreElements()) {
                    JarEntry entry = j.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || this.isFiltered(jarFilters, name) || "META-INF/INDEX.LIST".equals(name)) continue;
                    if ("module-info.class".equals(name)) {
                        this.logger.warn("Discovered module-info.class. Shading will break its strong encapsulation.");
                        continue;
                    }
                    try {
                        this.shadeSingleJar(shadeRequest, resources, transformers, remapper, jos, duplicates, jar, jarFile, entry, name);
                    }
                    catch (Exception e) {
                        throw new IOException(String.format("Problem shading JAR %s entry %s: %s", jar, name, e), e);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
    }

    private void shadeSingleJar(ShadeRequest shadeRequest, Set<String> resources, List<ResourceTransformer> transformers, RelocatorRemapper remapper, JarOutputStream jos, MultiValuedMap<String, File> duplicates, File jar, JarFile jarFile, JarEntry entry, String name) throws IOException, MojoExecutionException {
        try (InputStream in = jarFile.getInputStream(entry);){
            String dir;
            String mappedName = remapper.map(name);
            int idx = mappedName.lastIndexOf(47);
            if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                this.addDirectory(resources, jos, dir, entry.getTime());
            }
            duplicates.put((Object)name, (Object)jar);
            if (name.endsWith(".class")) {
                this.addRemappedClass(remapper, jos, jar, name, entry.getTime(), in);
            } else if (shadeRequest.isShadeSourcesContent() && name.endsWith(".java")) {
                if (resources.contains(mappedName)) {
                    return;
                }
                this.addJavaSource(resources, jos, mappedName, entry.getTime(), in, shadeRequest.getRelocators());
            } else if (!this.resourceTransformed(transformers, mappedName, in, shadeRequest.getRelocators(), entry.getTime())) {
                if (resources.contains(mappedName)) {
                    this.logger.debug("We have a duplicate " + name + " in " + jar);
                    return;
                }
                this.addResource(resources, jos, mappedName, entry, jarFile);
            } else {
                duplicates.removeMapping((Object)name, (Object)jar);
            }
        }
    }

    private void goThroughAllJarEntriesForManifestTransformer(ShadeRequest shadeRequest, Set<String> resources, ManifestResourceTransformer manifestTransformer, JarOutputStream jos) throws IOException {
        if (manifestTransformer != null) {
            block18: for (File jar : shadeRequest.getJars()) {
                JarFile jarFile = this.newJarFile(jar);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> en = jarFile.entries();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String resource = entry.getName();
                        if (!manifestTransformer.canTransformResource(resource)) continue;
                        resources.add(resource);
                        InputStream inputStream = jarFile.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            manifestTransformer.processResource(resource, inputStream, shadeRequest.getRelocators(), entry.getTime());
                            continue block18;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (inputStream == null) continue block18;
                            if (throwable2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue block18;
                            }
                            inputStream.close();
                            continue block18;
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            if (manifestTransformer.hasTransformedResource()) {
                manifestTransformer.modifyOutputStream(jos);
            }
        }
    }

    private void showOverlappingWarning() {
        this.logger.warn("maven-shade-plugin has detected that some class files are");
        this.logger.warn("present in two or more JARs. When this happens, only one");
        this.logger.warn("single version of the class is copied to the uber jar.");
        this.logger.warn("Usually this is not harmful and you can skip these warnings,");
        this.logger.warn("otherwise try to manually exclude artifacts based on");
        this.logger.warn("mvn dependency:tree -Ddetail=true and the above output.");
        this.logger.warn("See http://maven.apache.org/plugins/maven-shade-plugin/");
    }

    private void logSummaryOfDuplicates(MultiValuedMap<Collection<File>, String> overlapping) {
        for (Collection jarz : overlapping.keySet()) {
            ArrayList<String> jarzS = new ArrayList<String>();
            for (File jjar : jarz) {
                jarzS.add(jjar.getName());
            }
            Collections.sort(jarzS);
            LinkedList<String> classes = new LinkedList<String>();
            LinkedList<String> resources = new LinkedList<String>();
            for (String name : overlapping.get((Object)jarz)) {
                if (name.endsWith(".class")) {
                    classes.add(name.replace(".class", "").replace("/", "."));
                    continue;
                }
                resources.add(name);
            }
            ArrayList<String> overlaps = new ArrayList<String>();
            if (!classes.isEmpty()) {
                if (resources.size() == 1) {
                    overlaps.add("class");
                } else {
                    overlaps.add("classes");
                }
            }
            if (!resources.isEmpty()) {
                if (resources.size() == 1) {
                    overlaps.add("resource");
                } else {
                    overlaps.add("resources");
                }
            }
            ArrayList<String> all = new ArrayList<String>(classes.size() + resources.size());
            all.addAll(classes);
            all.addAll(resources);
            this.logger.warn(StringUtils.join(jarzS, (String)", ") + " define " + all.size() + " overlapping " + StringUtils.join(overlaps, (String)" and ") + ": ");
            Collections.sort(all);
            int max = 10;
            for (int i = 0; i < Math.min(max, all.size()); ++i) {
                this.logger.warn("  - " + (String)all.get(i));
            }
            if (all.size() <= max) continue;
            this.logger.warn("  - " + (all.size() - max) + " more...");
        }
    }

    private JarFile newJarFile(File jar) throws IOException {
        try {
            return new JarFile(jar);
        }
        catch (ZipException zex) {
            throw new ZipException("error in opening zip file " + jar);
        }
    }

    private List<Filter> getFilters(File jar, List<Filter> filters) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter filter : filters) {
            if (!filter.canFilter(jar)) continue;
            list.add(filter);
        }
        return list;
    }

    private void addDirectory(Set<String> resources, JarOutputStream jos, String name, long time) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent, time);
        }
        JarEntry entry = new JarEntry(name + "/");
        entry.setTime(time);
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addRemappedClass(RelocatorRemapper remapper, JarOutputStream jos, File jar, String name, long time, InputStream is) throws IOException, MojoExecutionException {
        if (!remapper.hasRelocators()) {
            try {
                JarEntry entry = new JarEntry(name);
                entry.setTime(time);
                jos.putNextEntry(entry);
                IOUtil.copy((InputStream)is, (OutputStream)jos);
            }
            catch (ZipException e) {
                this.logger.debug("We have a duplicate " + name + " in " + jar);
            }
            return;
        }
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(0);
        final String pkg = name.substring(0, name.lastIndexOf(47) + 1);
        ClassRemapper cv = new ClassRemapper((ClassVisitor)cw, remapper){

            public void visitSource(String source, String debug) {
                if (source == null) {
                    super.visitSource(source, debug);
                } else {
                    String fqSource = pkg + source;
                    String mappedSource = this.remapper.map(fqSource);
                    String filename = mappedSource.substring(mappedSource.lastIndexOf(47) + 1);
                    super.visitSource(filename, debug);
                }
            }
        };
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable ise) {
            throw new MojoExecutionException("Error in ASM processing class " + name, ise);
        }
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        try {
            JarEntry entry = new JarEntry(mappedName + ".class");
            entry.setTime(time);
            jos.putNextEntry(entry);
            jos.write(renamedClass);
        }
        catch (ZipException e) {
            this.logger.debug("We have a duplicate " + mappedName + " in " + jar);
        }
    }

    private boolean isFiltered(List<Filter> filters, String name) {
        for (Filter filter : filters) {
            if (!filter.isFiltered(name)) continue;
            return true;
        }
        return false;
    }

    private boolean resourceTransformed(List<ResourceTransformer> resourceTransformers, String name, InputStream is, List<Relocator> relocators, long time) throws IOException {
        boolean resourceTransformed = false;
        for (ResourceTransformer transformer : resourceTransformers) {
            if (!transformer.canTransformResource(name)) continue;
            this.logger.debug("Transforming " + name + " using " + transformer.getClass().getName());
            if (transformer instanceof ReproducibleResourceTransformer) {
                ((ReproducibleResourceTransformer)transformer).processResource(name, is, relocators, time);
            } else {
                transformer.processResource(name, is, relocators);
            }
            resourceTransformed = true;
            break;
        }
        return resourceTransformed;
    }

    private void addJavaSource(Set<String> resources, JarOutputStream jos, String name, long time, InputStream is, List<Relocator> relocators) throws IOException {
        JarEntry entry = new JarEntry(name);
        entry.setTime(time);
        jos.putNextEntry(entry);
        String sourceContent = IOUtil.toString((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        for (Relocator relocator : relocators) {
            sourceContent = relocator.applyToSourceContent(sourceContent);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, StandardCharsets.UTF_8);
        writer.write(sourceContent);
        ((Writer)writer).flush();
        resources.add(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(Set<String> resources, JarOutputStream jos, String name, JarEntry originalEntry, JarFile jarFile) throws IOException {
        try (ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(originalEntry));){
            JarEntry entry = new JarEntry(name);
            if (inputStream.hasZipHeader() && originalEntry.getMethod() == 0) {
                new CrcAndSize(inputStream).setupStoredEntry(entry);
                inputStream.close();
                inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(originalEntry));
            }
            entry.setTime(originalEntry.getTime());
            jos.putNextEntry(entry);
            IOUtil.copy((InputStream)inputStream, (OutputStream)jos);
            resources.add(name);
        }
    }

    static class RelocatorRemapper
    extends Remapper {
        private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+);");
        List<Relocator> relocators;

        RelocatorRemapper(List<Relocator> relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = this.classPattern.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocator r : this.relocators) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = this.classPattern.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocator r : this.relocators) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                break;
            }
            return value;
        }
    }

    private static class CrcAndSize {
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(InputStream inputStream) throws IOException {
            this.load(inputStream);
        }

        private void load(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                this.size += (long)bytesRead;
            }
        }

        public void setupStoredEntry(JarEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
        }
    }

    private static class ZipHeaderPeekInputStream
    extends PushbackInputStream {
        private static final byte[] ZIP_HEADER = new byte[]{80, 75, 3, 4};
        private static final int HEADER_LEN = 4;

        protected ZipHeaderPeekInputStream(InputStream in) {
            super(in, 4);
        }

        public boolean hasZipHeader() throws IOException {
            byte[] header = new byte[4];
            super.read(header, 0, 4);
            super.unread(header);
            return Arrays.equals(header, ZIP_HEADER);
        }
    }
}

