/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.drools.core.base.FieldFactory;
import org.drools.core.base.ValueType;
import org.drools.core.spi.FieldValue;
import org.junit.Assert;
import org.junit.Test;

public class FieldFactoryTest {
    @Test
    public void testBigDecimal() {
        FieldValue val = FieldFactory.getInstance().getFieldValue((Object)"42.42", ValueType.BIG_DECIMAL_TYPE);
        Assert.assertEquals(BigDecimal.class, val.getValue().getClass());
        Assert.assertTrue((boolean)val.getValue().equals(new BigDecimal("42.42")));
    }

    @Test
    public void testBigInteger() {
        FieldValue val = FieldFactory.getInstance().getFieldValue((Object)"424242", ValueType.BIG_INTEGER_TYPE);
        Assert.assertEquals(BigInteger.class, val.getValue().getClass());
        Assert.assertTrue((boolean)val.getValue().equals(new BigInteger("424242")));
    }

    @Test
    public void testDate() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        String s = df.format(df.parse("10-Jul-1974"));
        FieldValue val = FieldFactory.getInstance().getFieldValue((Object)s, ValueType.DATE_TYPE);
        Assert.assertEquals(Date.class, val.getValue().getClass());
        Date dt = (Date)val.getValue();
        Assert.assertEquals((Object)s, (Object)df.format(dt));
    }
}

