/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplateImpl;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.core.facttemplates.FieldTemplateImpl;
import org.junit.Assert;
import org.junit.Test;

public class FactTemplateTest {
    @Test
    public void testFieldsAndGetters() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields);
        Assert.assertEquals((Object)"org.store", (Object)cheese.getPackage().getName());
        Assert.assertEquals((Object)"Cheese", (Object)cheese.getName());
        Assert.assertEquals((long)2L, (long)cheese.getNumberOfFields());
        Assert.assertSame((Object)fields, (Object)cheese.getAllFieldTemplates());
        Assert.assertSame((Object)cheeseName, (Object)cheese.getFieldTemplate(0));
        Assert.assertSame((Object)cheesePrice, (Object)cheese.getFieldTemplate(1));
        Assert.assertSame((Object)cheeseName, (Object)cheese.getFieldTemplate("name"));
        Assert.assertSame((Object)cheesePrice, (Object)cheese.getFieldTemplate("price"));
        Assert.assertEquals((long)0L, (long)cheese.getFieldTemplateIndex("name"));
        Assert.assertEquals((long)1L, (long)cheese.getFieldTemplateIndex("price"));
    }

    @Test
    public void testEqualsAndHashCode() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields1 = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese1 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields1);
        FieldTemplateImpl cheeseType = new FieldTemplateImpl("type", 0, String.class);
        FieldTemplate[] fields2 = new FieldTemplate[]{cheeseType, cheesePrice};
        FactTemplateImpl cheese2 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields2);
        Assert.assertNotSame((Object)cheese1, (Object)cheese2);
        Assert.assertFalse((boolean)cheese1.equals(cheese2));
        Assert.assertFalse((cheese1.hashCode() == cheese2.hashCode() ? 1 : 0) != 0);
        FieldTemplateImpl cheeseName2 = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice2 = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields3 = new FieldTemplate[]{cheeseName2, cheesePrice2};
        FactTemplateImpl cheese3 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields3);
        Assert.assertNotSame((Object)cheese1, (Object)cheese3);
        Assert.assertNotSame((Object)cheese1.getAllFieldTemplates(), (Object)cheese3.getAllFieldTemplates());
        Assert.assertEquals((Object)cheese1, (Object)cheese3);
        Assert.assertEquals((long)cheese1.hashCode(), (long)cheese3.hashCode());
    }

    @Test
    public void testFacts() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields1 = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese1 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields1);
        Fact stilton1 = cheese1.createFact(10L);
        stilton1.setFieldValue("name", (Object)"stilton");
        stilton1.setFieldValue("price", (Object)new Integer(200));
        Fact stilton2 = cheese1.createFact(11L);
        stilton2.setFieldValue(0, (Object)"stilton");
        stilton2.setFieldValue(1, (Object)new Integer(200));
        Assert.assertEquals((Object)stilton1, (Object)stilton2);
        Assert.assertEquals((long)stilton1.hashCode(), (long)stilton2.hashCode());
        Fact brie = cheese1.createFact(12L);
        brie.setFieldValue("name", (Object)"brie");
        brie.setFieldValue("price", (Object)new Integer(55));
        Assert.assertFalse((boolean)stilton1.equals(brie));
        Assert.assertFalse((stilton1.hashCode() == brie.hashCode() ? 1 : 0) != 0);
    }
}

