/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedListTest {
    LinkedList list = null;
    LinkedListNode node1 = null;
    LinkedListNode node2 = null;
    LinkedListNode node3 = null;

    @Before
    public void setUp() throws Exception {
        this.list = new LinkedList();
        this.node1 = new AbstractBaseLinkedListNodeMock();
        this.node2 = new AbstractBaseLinkedListNodeMock();
        this.node3 = new AbstractBaseLinkedListNodeMock();
    }

    @Test
    public void testAdd() {
        this.list.add(this.node1);
        Assert.assertNull((String)"Node1 previous should be null", (Object)this.node1.getPrevious());
        Assert.assertNull((String)"Node1 next should be null", (Object)this.node1.getNext());
        Assert.assertSame((String)"First node should be node1", (Object)this.list.getFirst(), (Object)this.node1);
        Assert.assertSame((String)"Last node should be node1", (Object)this.list.getLast(), (Object)this.node1);
        this.list.add(this.node2);
        Assert.assertSame((String)"node1 next should be node2", (Object)this.node1.getNext(), (Object)this.node2);
        Assert.assertSame((String)"node2 previous should be node1", (Object)this.node2.getPrevious(), (Object)this.node1);
        Assert.assertSame((String)"First node should be node1", (Object)this.list.getFirst(), (Object)this.node1);
        Assert.assertSame((String)"Last node should be node2", (Object)this.list.getLast(), (Object)this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"node2 next should be node3", (Object)this.node2.getNext(), (Object)this.node3);
        Assert.assertSame((String)"node3 previous should be node2", (Object)this.node3.getPrevious(), (Object)this.node2);
        Assert.assertEquals((String)"LinkedList should have 3 nodes", (long)this.list.size(), (long)3L);
        Assert.assertSame((String)"First node should be node1", (Object)this.list.getFirst(), (Object)this.node1);
        Assert.assertSame((String)"Last node should be node3", (Object)this.list.getLast(), (Object)this.node3);
    }

    @Test
    public void testRemove() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"Node2 previous should be node1", (Object)this.node2.getPrevious(), (Object)this.node1);
        Assert.assertSame((String)"Node2 next should be node3", (Object)this.node2.getNext(), (Object)this.node3);
        this.list.remove(this.node2);
        Assert.assertNull((String)"Node2 previous should be null", (Object)this.node2.getPrevious());
        Assert.assertNull((String)"Node2 next should be null", (Object)this.node2.getNext());
        Assert.assertNull((String)"Node1 previous should be null", (Object)this.node1.getPrevious());
        Assert.assertSame((String)"Node1 next should be node3", (Object)this.node1.getNext(), (Object)this.node3);
        this.list.remove(this.node1);
        Assert.assertNull((String)"Node1 previous should be null", (Object)this.node1.getPrevious());
        Assert.assertNull((String)"Node1 next should be null", (Object)this.node1.getNext());
        Assert.assertNull((String)"Node3 previous should be null", (Object)this.node3.getPrevious());
        Assert.assertNull((String)"Node3 next should be null", (Object)this.node3.getNext());
        this.list.remove(this.node3);
        Assert.assertNull((String)"Node3 previous should be null", (Object)this.node3.getPrevious());
        Assert.assertNull((String)"Node3 next should be null", (Object)this.node3.getNext());
    }

    @Test
    public void testGetFirst() {
        Assert.assertNull((String)"Empty list should return null on getFirst()", (Object)this.list.getFirst());
        this.list.add(this.node1);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
        this.list.add(this.node2);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
    }

    @Test
    public void testGetLast() {
        Assert.assertNull((String)"Empty list should return null on getLast()", (Object)this.list.getLast());
        this.list.add(this.node1);
        Assert.assertSame((String)"List should return node1 on getLast()", (Object)this.list.getLast(), (Object)this.node1);
        this.list.add(this.node2);
        Assert.assertSame((String)"List should return node2 on getLast()", (Object)this.list.getLast(), (Object)this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node3 on getLast()", (Object)this.list.getLast(), (Object)this.node3);
    }

    @Test
    public void testRemoveFirst() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
        this.list.removeFirst();
        Assert.assertSame((String)"List should return node2 on getFirst()", (Object)this.list.getFirst(), (Object)this.node2);
        this.list.removeFirst();
        Assert.assertSame((String)"List should return node3 on getFirst()", (Object)this.list.getFirst(), (Object)this.node3);
        this.list.removeFirst();
        Assert.assertNull((String)"Empty list should return null on getFirst()", (Object)this.list.getFirst());
    }

    @Test
    public void testRemoveLast() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node1 on getLast()", (Object)this.list.getLast(), (Object)this.node3);
        this.list.removeLast();
        Assert.assertSame((String)"List should return node2 on getLast()", (Object)this.list.getLast(), (Object)this.node2);
        this.list.removeLast();
        Assert.assertSame((String)"List should return node3 on getLast()", (Object)this.list.getLast(), (Object)this.node1);
        this.list.removeLast();
        Assert.assertNull((String)"Empty list should return null on getLast()", (Object)this.list.getLast());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((String)"Empty list should return true on isEmpty()", (boolean)this.list.isEmpty());
        this.list.add(this.node1);
        Assert.assertFalse((String)"Not empty list should return false on isEmpty()", (boolean)this.list.isEmpty());
    }

    @Test
    public void testClear() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertEquals((String)"List size should be 3", (long)this.list.size(), (long)3L);
        this.list.clear();
        Assert.assertEquals((String)"Empty list should have size 0", (long)this.list.size(), (long)0L);
    }

    @Test
    public void testSize() {
        this.list.add(this.node1);
        Assert.assertEquals((String)"LinkedList should have 1 node", (long)this.list.size(), (long)1L);
        this.list.add(this.node2);
        Assert.assertEquals((String)"LinkedList should have 2 nodes", (long)this.list.size(), (long)2L);
        this.list.add(this.node3);
        Assert.assertEquals((String)"LinkedList should have 3 nodes", (long)this.list.size(), (long)3L);
    }

    @Test
    public void testInsertAfter() {
        try {
            this.list.insertAfter(null, this.node1);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Assert.fail((String)"Should NOT raise NPE!");
        }
    }

    private static class AbstractBaseLinkedListNodeMock
    extends AbstractBaseLinkedListNode<AbstractBaseLinkedListNodeMock> {
        private AbstractBaseLinkedListNodeMock() {
        }
    }
}

