/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.drools.template.model.DRLOutput;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DefaultGenerator;
import org.drools.template.parser.DefaultTemplateContainer;
import org.drools.template.parser.Generator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateContainer;

public class TemplateDataListener
implements DataListener {
    private int startRow = -1;
    private boolean tableFinished = false;
    private Row currentRow;
    private Column[] columns;
    private TemplateContainer templateContainer;
    private int startCol;
    private Generator generator;
    private boolean checkEmptyRows = true;

    public TemplateDataListener(TemplateContainer tc) {
        this(1, 1, tc, true);
    }

    public TemplateDataListener(TemplateContainer tc, boolean checkEmptyRows) {
        this(1, 1, tc, checkEmptyRows);
    }

    public TemplateDataListener(int startRow, int startCol, String template) {
        this(startRow, startCol, new DefaultTemplateContainer(template));
    }

    public TemplateDataListener(int startRow, int startCol, InputStream templateStream) {
        this(startRow, startCol, new DefaultTemplateContainer(templateStream));
    }

    public TemplateDataListener(int startRow, int startCol, TemplateContainer tc) {
        this(startRow, startCol, tc, true);
    }

    public TemplateDataListener(int startRow, int startCol, TemplateContainer tc, boolean checkEmptyRows) {
        this(startRow, startCol, tc, new DefaultGenerator(tc.getTemplates()), checkEmptyRows);
    }

    public TemplateDataListener(int startRow, int startCol, TemplateContainer tc, Generator generator) {
        this(startRow, startCol, tc, generator, true);
    }

    public TemplateDataListener(int startRow, int startCol, TemplateContainer tc, Generator generator, boolean checkEmptyRows) {
        this.startRow = startRow - 1;
        this.startCol = startCol - 1;
        this.columns = tc.getColumns();
        this.templateContainer = tc;
        this.generator = generator;
        this.checkEmptyRows = checkEmptyRows;
    }

    @Override
    public void finishSheet() {
        if (this.currentRow != null) {
            this.generateDRLForTemplates(this.currentRow);
        }
    }

    @Override
    public void newCell(int row, int column, String value, int mergedColStart) {
        int columnIndex;
        if (this.currentRow != null && column >= this.startCol && value != null && value.trim().length() > 0 && (columnIndex = column - this.startCol) < this.columns.length) {
            Cell cell = this.currentRow.getCell(columnIndex);
            cell.setValue(value);
        }
    }

    @Override
    public void newRow(int rowNumber, int columnCount) {
        if (!this.tableFinished && rowNumber >= this.startRow) {
            if (this.currentRow != null && this.checkEmptyRows && this.currentRow.isEmpty()) {
                this.currentRow = null;
                this.tableFinished = true;
            } else {
                if (this.currentRow != null) {
                    this.generateDRLForTemplates(this.currentRow);
                }
                this.currentRow = new Row(rowNumber, this.columns);
            }
        }
    }

    @Override
    public void startSheet(String name) {
    }

    public String renderDRL() {
        DRLOutput out = new DRLOutput();
        out.writeLine(this.templateContainer.getHeader());
        out.writeLine(this.generator.getDrl());
        return out.getDRL();
    }

    private void generateDRLForTemplates(Row row) {
        Map<String, RuleTemplate> ruleTemplates = this.templateContainer.getTemplates();
        if (Objects.nonNull(ruleTemplates)) {
            ruleTemplates.forEach((name, rc) -> this.generator.generate((String)name, row));
        }
    }
}

