/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.prototype;

import java.util.Collection;
import java.util.function.Function;
import org.kie.api.prototype.PrototypeFactInstance;

public interface Prototype {
    public static final Object UNDEFINED_VALUE = UndefinedValue.INSTANCE;

    public String getPackage();

    public String getName();

    default public String getFullName() {
        return this.getPackage() + "." + this.getName();
    }

    public Collection<String> getFieldNames();

    public Field getField(String var1);

    public int getFieldIndex(String var1);

    default public Function<PrototypeFactInstance, Object> getFieldValueExtractor(String name) {
        Field field = this.getField(name);
        return field != null ? field.getExtractor() : p -> p.has(name) ? p.get(name) : UNDEFINED_VALUE;
    }

    public boolean isEvent();

    public static interface Field {
        public String getName();

        public Function<PrototypeFactInstance, Object> getExtractor();

        public boolean isTyped();

        public Class<?> getType();
    }

    public static class UndefinedValue {
        static final UndefinedValue INSTANCE = new UndefinedValue();
        static final UnsupportedOperationException HASHCODE_EXCEPTION = new UnsupportedOperationException();

        public int hashCode() {
            throw HASHCODE_EXCEPTION;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public String toString() {
            return "$UndefinedValue$";
        }
    }
}

