/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dmg.pmml.Field;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.tree.Node;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.tree.compiler.utils.KiePMMLTreeModelUtils;
import org.kie.pmml.models.tree.model.KiePMMLNode;
import org.kie.pmml.models.tree.model.KiePMMLScoreDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLNodeFactory {
    static final String KIE_PMML_NODE_TEMPLATE_JAVA = "KiePMMLNodeTemplate.tmpl";
    static final String KIE_PMML_NODE_TEMPLATE = "KiePMMLNodeTemplate";
    static final String EVALUATE_NODE = "evaluateNode";
    static final String PREDICATE = "predicate";
    static final String SCORE = "score";
    static final String SCORE_DISTRIBUTIONS = "scoreDistributions";
    static final String MISSING_VALUE_PENALTY = "missingValuePenalty";
    static final String NODE_FUNCTIONS = "nodeFunctions";
    static final String EMPTY_LIST = "emptyList";
    static final String AS_LIST = "asList";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLNodeFactory.class.getName());

    private KiePMMLNodeFactory() {
    }

    public static KiePMMLNode getKiePMMLNode(Node node, List<Field<?>> fields, String packageName, Double missingValuePenalty, HasClassLoader hasClassLoader) {
        logger.trace("getKiePMMLTreeNode {} {}", (Object)packageName, (Object)node);
        NodeNamesDTO nodeNamesDTO = new NodeNamesDTO(node, KiePMMLTreeModelUtils.createNodeClassName(), null, missingValuePenalty);
        Map<String, String> sourcesMap = KiePMMLNodeFactory.getKiePMMLNodeSourcesMap(nodeNamesDTO, fields, packageName);
        String fullClassName = packageName + "." + nodeNamesDTO.nodeClassName;
        try {
            Class kiePMMLNodeClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLNode)kiePMMLNodeClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLNodeSourcesMap(NodeNamesDTO nodeNamesDTO, List<Field<?>> fields, String packageName) {
        logger.trace("getKiePMMLNodeSourcesMap {} {}", (Object)nodeNamesDTO, (Object)packageName);
        JavaParserDTO javaParserDTO = new JavaParserDTO(nodeNamesDTO, packageName);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        KiePMMLNodeFactory.populateJavaParserDTOAndSourcesMap(javaParserDTO, toReturn, nodeNamesDTO, fields, true);
        return toReturn;
    }

    static void populateJavaParserDTOAndSourcesMap(JavaParserDTO toPopulate, Map<String, String> sourcesMap, NodeNamesDTO nodeNamesDTO, List<Field<?>> fields, boolean isRoot) {
        KiePMMLNodeFactory.populateEvaluateNode(toPopulate, nodeNamesDTO, fields, isRoot);
        KiePMMLNodeFactory.populatedNestedNodes(toPopulate, sourcesMap, fields, nodeNamesDTO);
        sourcesMap.put(toPopulate.fullNodeClassName, toPopulate.getSource());
    }

    static void populatedNestedNodes(JavaParserDTO toPopulate, Map<String, String> sourcesMap, List<Field<?>> fields, NodeNamesDTO nodeNamesDTO) {
        Node node = nodeNamesDTO.node;
        if (node.hasNodes()) {
            for (Node nestedNode : node.getNodes()) {
                NodeNamesDTO nestedNodeNamesDTO = new NodeNamesDTO(nestedNode, nodeNamesDTO.getNestedNodeClassName(nestedNode), nodeNamesDTO.nodeClassName, nodeNamesDTO.missingValuePenalty);
                if (toPopulate.limitReach()) {
                    sourcesMap.put(toPopulate.fullNodeClassName, toPopulate.getSource());
                    JavaParserDTO javaParserDTO = new JavaParserDTO(nestedNodeNamesDTO, toPopulate.packageName);
                    KiePMMLNodeFactory.populateJavaParserDTOAndSourcesMap(javaParserDTO, sourcesMap, nestedNodeNamesDTO, fields, true);
                    continue;
                }
                KiePMMLNodeFactory.populateEvaluateNode(toPopulate, nestedNodeNamesDTO, fields, false);
                KiePMMLNodeFactory.mergeNode(toPopulate, nestedNodeNamesDTO);
                KiePMMLNodeFactory.populatedNestedNodes(toPopulate, sourcesMap, fields, nestedNodeNamesDTO);
            }
        }
    }

    static void mergeNode(JavaParserDTO toPopulate, NodeNamesDTO nestedNodeNamesDTO) {
        MethodCallExpr evaluateNodeInitializer;
        if (Objects.equals(toPopulate.nodeClassName, nestedNodeNamesDTO.parentNodeClassName)) {
            evaluateNodeInitializer = ((Expression)toPopulate.evaluateRootNodeReferencesDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", NODE_FUNCTIONS, toPopulate.evaluateRootNodeReferencesDeclarator)))).asMethodCallExpr();
        } else {
            String expected = EVALUATE_NODE + nestedNodeNamesDTO.parentNodeClassName;
            MethodDeclaration evaluateNestedNodeMethod = (MethodDeclaration)toPopulate.nodeTemplate.getMethodsByName(expected).get(0);
            BlockStmt evaluateNestedNodeBody = (BlockStmt)evaluateNestedNodeMethod.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected body in method %s", expected)));
            VariableDeclarator nestedNodeVariableDeclarator = evaluateNestedNodeBody.findAll(VariableDeclarator.class).stream().filter(variableDeclarator -> variableDeclarator.getName().asString().equals(NODE_FUNCTIONS)).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", expected, evaluateNestedNodeBody)));
            evaluateNodeInitializer = ((Expression)nestedNodeVariableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", NODE_FUNCTIONS, nestedNodeVariableDeclarator)))).asMethodCallExpr();
        }
        KiePMMLNodeFactory.mergeNodeReferences(toPopulate, nestedNodeNamesDTO, evaluateNodeInitializer);
    }

    static void mergeNodeReferences(JavaParserDTO toPopulate, NodeNamesDTO nestedNodeNamesDTO, MethodCallExpr evaluateNodeInitializer) {
        NodeList evaluateNodeReferences = evaluateNodeInitializer.getArguments();
        String expectedReference = String.format("%s.%s", toPopulate.packageName, nestedNodeNamesDTO.nodeClassName);
        Optional<Object> found = Optional.empty();
        for (Expression expression : evaluateNodeReferences) {
            if (!expectedReference.equals(expression.asMethodReferenceExpr().getScope().toString())) continue;
            found = Optional.of(expression.asMethodReferenceExpr());
            break;
        }
        MethodReferenceExpr evaluateNodeReference = (MethodReferenceExpr)found.orElseThrow(() -> new KiePMMLException(String.format("Missing method reference '%s' in %s", expectedReference, evaluateNodeInitializer)));
        String identifier = EVALUATE_NODE + nestedNodeNamesDTO.nodeClassName;
        evaluateNodeReference.setScope((Expression)new NameExpr(toPopulate.nodeClassName));
        evaluateNodeReference.setIdentifier(identifier);
    }

    static void populateEvaluateNode(JavaParserDTO toPopulate, NodeNamesDTO nodeNamesDTO, List<Field<?>> fields, boolean isRoot) {
        String nodeClassName = nodeNamesDTO.nodeClassName;
        BlockStmt evaluateNodeBody = isRoot ? toPopulate.evaluateRootNodeBody : (BlockStmt)toPopulate.getEvaluateNestedNodeMethodDeclaration(nodeClassName).getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", EVALUATE_NODE + nodeClassName)));
        KiePMMLNodeFactory.populateEvaluateNodeWithPredicate(evaluateNodeBody, nodeNamesDTO.node.getPredicate(), fields);
        List<String> nestedNodesFullClasses = nodeNamesDTO.getNestedNodesFullClassNames(toPopulate.packageName);
        KiePMMLNodeFactory.populateEvaluateNodeWithNodeFunctions(evaluateNodeBody, nestedNodesFullClasses);
        KiePMMLNodeFactory.populateEvaluateNodeWithScore(evaluateNodeBody, nodeNamesDTO.node.getScore());
        if (nodeNamesDTO.node.hasScoreDistributions()) {
            KiePMMLNodeFactory.populateEvaluateNodeWithScoreDistributions(evaluateNodeBody, nodeNamesDTO.node.getScoreDistributions());
        }
        if (nodeNamesDTO.missingValuePenalty != null) {
            KiePMMLNodeFactory.populateEvaluateNodeWithMissingValuePenalty(evaluateNodeBody, nodeNamesDTO.missingValuePenalty);
        }
    }

    static void populateEvaluateNodeWithNodeFunctions(BlockStmt toPopulate, List<String> nestedNodesFullClasses) {
        MethodCallExpr valuesInit = new MethodCallExpr();
        if (nestedNodesFullClasses.isEmpty()) {
            valuesInit.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Collections.class.getName())));
            valuesInit.setName(EMPTY_LIST);
        } else {
            NodeList methodReferenceExprs = NodeList.nodeList((Collection)nestedNodesFullClasses.stream().map(KiePMMLNodeFactory::getEvaluateNodeMethodReference).collect(Collectors.toList()));
            valuesInit.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
            valuesInit.setName(AS_LIST);
            valuesInit.setArguments(methodReferenceExprs);
        }
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)toPopulate, (String)NODE_FUNCTIONS, (Expression)valuesInit);
    }

    static MethodReferenceExpr getEvaluateNodeMethodReference(String fullNodeClassName) {
        MethodReferenceExpr toAdd = new MethodReferenceExpr();
        toAdd.setScope((Expression)new NameExpr(fullNodeClassName));
        toAdd.setIdentifier(EVALUATE_NODE);
        return toAdd;
    }

    static void populateEvaluateNodeWithScore(BlockStmt toPopulate, Object scoreParam) {
        NullLiteralExpr scoreExpression;
        if (scoreParam == null) {
            scoreExpression = new NullLiteralExpr();
        } else {
            String scoreParamExpr = scoreParam instanceof String ? String.format("\"%s\"", scoreParam) : scoreParam.toString();
            scoreExpression = new NameExpr(scoreParamExpr);
        }
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)toPopulate, (String)SCORE, (Expression)scoreExpression);
    }

    static void populateEvaluateNodeWithScoreDistributions(BlockStmt toPopulate, List<ScoreDistribution> scoreDistributionsParam) {
        NullLiteralExpr scoreDistributionsExpression;
        if (scoreDistributionsParam == null) {
            scoreDistributionsExpression = new NullLiteralExpr();
        } else {
            int counter = 0;
            NodeList scoreDistributionsArguments = new NodeList();
            for (ScoreDistribution scoreDistribution : scoreDistributionsParam) {
                String nestedVariableName = String.format("scoreDistribution_%s", counter);
                scoreDistributionsArguments.add((com.github.javaparser.ast.Node)KiePMMLNodeFactory.getKiePMMLScoreDistribution(nestedVariableName, scoreDistribution));
                ++counter;
            }
            scoreDistributionsExpression = new MethodCallExpr();
            ((MethodCallExpr)scoreDistributionsExpression).setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
            ((MethodCallExpr)scoreDistributionsExpression).setName(AS_LIST);
            ((MethodCallExpr)scoreDistributionsExpression).setArguments(scoreDistributionsArguments);
        }
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)toPopulate, (String)SCORE_DISTRIBUTIONS, (Expression)scoreDistributionsExpression);
    }

    static void populateEvaluateNodeWithMissingValuePenalty(BlockStmt toPopulate, Double missingValuePenalty) {
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)toPopulate, (String)MISSING_VALUE_PENALTY, (Expression)CommonCodegenUtils.getExpressionForObject((Object)missingValuePenalty));
    }

    static ObjectCreationExpr getKiePMMLScoreDistribution(String variableName, ScoreDistribution scoreDistribution) {
        NodeList scoreDistributionsArguments = new NodeList();
        scoreDistributionsArguments.add((com.github.javaparser.ast.Node)CommonCodegenUtils.getExpressionForObject((Object)variableName));
        scoreDistributionsArguments.add((com.github.javaparser.ast.Node)new NullLiteralExpr());
        scoreDistributionsArguments.add((com.github.javaparser.ast.Node)CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getValue().toString()));
        scoreDistributionsArguments.add((com.github.javaparser.ast.Node)CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getRecordCount().intValue()));
        NullLiteralExpr confidenceExpression = scoreDistribution.getConfidence() != null ? CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getConfidence().doubleValue()) : new NullLiteralExpr();
        scoreDistributionsArguments.add((com.github.javaparser.ast.Node)confidenceExpression);
        NullLiteralExpr probabilityExpression = scoreDistribution.getProbability() != null ? CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getProbability().doubleValue()) : new NullLiteralExpr();
        scoreDistributionsArguments.add((com.github.javaparser.ast.Node)probabilityExpression);
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLScoreDistribution.class.getCanonicalName()), scoreDistributionsArguments);
    }

    static void populateEvaluateNodeWithPredicate(BlockStmt toPopulate, Predicate predicate, List<Field<?>> fields) {
        BlockStmt toAdd = KiePMMLPredicateFactory.getKiePMMLPredicate((String)PREDICATE, (Predicate)predicate, fields);
        NodeList predicateStatements = toAdd.getStatements();
        for (int i = 0; i < predicateStatements.size(); ++i) {
            toPopulate.addStatement(i, (Statement)predicateStatements.get(i));
        }
    }

    static class NodeNamesDTO {
        final Node node;
        final String nodeClassName;
        final String nodeName;
        final Map<Node, String> childrenNodes;
        final String parentNodeClassName;
        final Double missingValuePenalty;

        public NodeNamesDTO(Node node, String nodeClassName, String parentNodeClassName, Double missingValuePenalty) {
            this.node = node;
            this.parentNodeClassName = parentNodeClassName;
            this.nodeClassName = nodeClassName;
            String string = this.nodeName = node.getId() != null ? node.getId().toString() : nodeClassName;
            if (node.hasNodes()) {
                this.childrenNodes = new LinkedHashMap<Node, String>();
                for (Node nestedNode : node.getNodes()) {
                    this.childrenNodes.put(nestedNode, KiePMMLTreeModelUtils.createNodeClassName());
                }
            } else {
                this.childrenNodes = Collections.emptyMap();
            }
            this.missingValuePenalty = missingValuePenalty;
        }

        String getNestedNodeClassName(Node nestedNode) {
            if (!this.childrenNodes.containsKey(nestedNode)) {
                throw new KiePMMLException("Missing expected nested node " + nestedNode);
            }
            return this.childrenNodes.get(nestedNode);
        }

        List<String> getNestedNodesFullClassNames(String packageName) {
            ArrayList<String> toReturn = new ArrayList<String>();
            for (String nestedNodeClassName : this.childrenNodes.values()) {
                toReturn.add(String.format("%s.%s", packageName, nestedNodeClassName));
            }
            return toReturn;
        }
    }

    static class JavaParserDTO {
        final String nodeClassName;
        final String packageName;
        final String nodeName;
        final String fullNodeClassName;
        final CompilationUnit cloneCU;
        final ClassOrInterfaceDeclaration nodeTemplate;
        final ConstructorDeclaration constructorDeclaration;
        final MethodDeclaration evaluateRootNodeMethod;
        final BlockStmt evaluateRootNodeBody;
        final BlockStmt evaluateRootNodeBodyClone;
        final VariableDeclarator evaluateRootNodeReferencesDeclarator;

        JavaParserDTO(NodeNamesDTO nodeNamesDTO, String packageName) {
            this.nodeClassName = nodeNamesDTO.nodeClassName;
            this.packageName = packageName;
            this.nodeName = nodeNamesDTO.nodeName;
            this.fullNodeClassName = String.format("%s.%s", packageName, this.nodeClassName);
            this.cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)this.nodeClassName, (String)packageName, (String)KiePMMLNodeFactory.KIE_PMML_NODE_TEMPLATE_JAVA, (String)KiePMMLNodeFactory.KIE_PMML_NODE_TEMPLATE);
            this.nodeTemplate = (ClassOrInterfaceDeclaration)this.cloneCU.getClassByName(this.nodeClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + this.nodeClassName));
            this.constructorDeclaration = (ConstructorDeclaration)this.nodeTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", this.nodeTemplate.getName())));
            KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)this.nodeClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)this.nodeName);
            this.evaluateRootNodeMethod = (MethodDeclaration)this.nodeTemplate.getMethodsByName(KiePMMLNodeFactory.EVALUATE_NODE).get(0);
            this.evaluateRootNodeBody = (BlockStmt)this.evaluateRootNodeMethod.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected body in method %s", KiePMMLNodeFactory.EVALUATE_NODE)));
            this.evaluateRootNodeBodyClone = this.evaluateRootNodeBody.clone();
            this.evaluateRootNodeReferencesDeclarator = this.evaluateRootNodeBody.findAll(VariableDeclarator.class).stream().filter(variableDeclarator -> variableDeclarator.getName().asString().equals(KiePMMLNodeFactory.NODE_FUNCTIONS)).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", KiePMMLNodeFactory.EVALUATE_NODE, this.evaluateRootNodeBody)));
        }

        boolean limitReach() {
            return this.nodeTemplate.findAll(MethodDeclaration.class).size() > 1000;
        }

        String getSource() {
            return this.cloneCU.toString();
        }

        MethodDeclaration getEvaluateNestedNodeMethodDeclaration(String nodeClassNameParam) {
            String methodName = KiePMMLNodeFactory.EVALUATE_NODE + nodeClassNameParam;
            MethodDeclaration toReturn = this.nodeTemplate.addMethod(methodName, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC});
            toReturn.setType(this.evaluateRootNodeMethod.getType());
            toReturn.setParameters(this.evaluateRootNodeMethod.getParameters());
            BlockStmt blockStmt = this.evaluateRootNodeBodyClone.clone();
            MethodCallExpr valuesInit = new MethodCallExpr();
            valuesInit.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
            valuesInit.setName(KiePMMLNodeFactory.AS_LIST);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)blockStmt, (String)KiePMMLNodeFactory.NODE_FUNCTIONS, (Expression)valuesInit);
            toReturn.setBody(blockStmt);
            return toReturn;
        }
    }
}

