/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.File;
import java.net.URI;

public enum URIContentLoaderType {
    CLASSPATH(new char[0]),
    FILE(File.separatorChar),
    HTTP(new char[0]);

    private final char[] additionalSeparators;

    private URIContentLoaderType(char ... additionalSeparators) {
        this.additionalSeparators = additionalSeparators;
    }

    public static URIContentLoaderType from(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return FILE;
        }
        switch (uri.getScheme().toLowerCase()) {
            case "file": {
                return FILE;
            }
            case "classpath": {
                return CLASSPATH;
            }
            case "http": 
            case "https": {
                return HTTP;
            }
        }
        throw new IllegalArgumentException("Unrecognized uri protocol " + uri);
    }

    public boolean isAbsolutePath(String path) {
        if (!path.isBlank()) {
            char firstChar = path.trim().charAt(0);
            boolean result = firstChar == '/';
            for (int i = 0; !result && i < this.additionalSeparators.length; ++i) {
                result = firstChar == this.additionalSeparators[i];
            }
            return result;
        }
        return false;
    }

    public String concat(String basePath, String additionalPath) {
        char separator = this.separator();
        if (!((String)basePath).isBlank() && !this.isAbsolutePath((String)basePath)) {
            basePath = separator + (String)basePath;
        }
        return (String)basePath + separator + additionalPath;
    }

    public String trimLast(String path) {
        int indexOf = this.lastIndexOf(path);
        return indexOf != -1 ? path.substring(0, indexOf) : "";
    }

    public String lastPart(String path) {
        int indexOf = this.lastIndexOf(path);
        return indexOf != -1 ? path.substring(indexOf + 1) : path;
    }

    private int lastIndexOf(String path) {
        int indexOf = path.lastIndexOf(47);
        int i = 0;
        while (indexOf == -1 && i < this.additionalSeparators.length) {
            indexOf = path.lastIndexOf(this.additionalSeparators[i++]);
        }
        return indexOf;
    }

    private char separator() {
        return this.additionalSeparators.length > 0 ? this.additionalSeparators[0] : (char)'/';
    }
}

