/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionRef;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.jackson.utils.JsonNodeVisitor;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.process.workitems.WorkParametersFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionParametersFactorySupplier;
import org.kie.kogito.serverless.workflow.suppliers.ObjectResolverSupplier;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public abstract class WorkItemBuilder {
    private static final String RESULT = "Result";

    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> addFunctionArgs(Workflow workflow, WorkItemNodeFactory<T> node, FunctionRef functionRef) {
        JsonNode functionArgs = functionRef.getArguments();
        if (functionArgs != null) {
            this.processArgs(workflow, node, functionArgs, "Parameter");
        }
        return node;
    }

    protected void validateArgs(FunctionRef ref) {
        this.validateArgs(ref.getArguments());
    }

    protected void validateArgs(JsonNode args) {
    }

    protected WorkItemNodeFactory<?> buildWorkItem(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, ParserContext parserContext, String inputVar, String outputVar) {
        return (WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(parserContext.newId()).inMapping(inputVar, "Parameter")).outMapping(RESULT, outputVar);
    }

    protected final void processArgs(Workflow workflow, WorkItemNodeFactory<?> workItemFactory, JsonNode functionArgs, String paramName) {
        if (functionArgs.isObject()) {
            this.functionsToMap(workflow, functionArgs).forEach((key, value) -> this.processArg(workflow, (String)key, value, workItemFactory, paramName));
        } else {
            Object object = this.functionReference(workflow, JsonObjectUtils.simpleToJavaValue((JsonNode)functionArgs));
            boolean isExpr = this.isExpression(workflow, object);
            if (isExpr) {
                workItemFactory.workParameterFactory((WorkParametersFactory)new ExpressionParametersFactorySupplier(workflow.getExpressionLang(), object, paramName));
            } else {
                workItemFactory.workParameter("ContentData", object);
            }
            workItemFactory.workParameterDefinition("ContentData", this.getDataType(object, isExpr));
        }
    }

    private Map<String, Object> functionsToMap(Workflow workflow, JsonNode jsonNode) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (jsonNode != null) {
            Iterator iter = jsonNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                map.put((String)entry.getKey(), this.functionReference(workflow, JsonObjectUtils.simpleToJavaValue((JsonNode)((JsonNode)entry.getValue()))));
            }
        }
        return map;
    }

    private Object functionReference(Workflow workflow, Object object) {
        if (object instanceof JsonNode) {
            return JsonNodeVisitor.transformTextNode((JsonNode)((JsonNode)object), node -> JsonObjectUtils.fromValue((Object)ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)node.asText())));
        }
        if (object instanceof CharSequence) {
            return ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)object.toString());
        }
        return object;
    }

    private void processArg(Workflow workflow, String key, Object value, WorkItemNodeFactory<?> workItemFactory, String paramName) {
        boolean isExpr = this.isExpression(workflow, value);
        ((WorkItemNodeFactory)workItemFactory.workParameter(key, isExpr ? new ObjectResolverSupplier(workflow.getExpressionLang(), value, paramName) : value)).workParameterDefinition(key, this.getDataType(value, isExpr));
    }

    DataType getDataType(Object object, boolean isExpr) {
        if (object instanceof ObjectNode) {
            return DataTypeResolver.fromClass(Map.class);
        }
        if (object instanceof ArrayNode) {
            return DataTypeResolver.fromClass(Collection.class);
        }
        return DataTypeResolver.fromObject((Object)object, (boolean)isExpr);
    }

    private boolean isExpression(Workflow workflow, Object value) {
        return value instanceof CharSequence && ExpressionHandlerFactory.get((String)workflow.getExpressionLang(), (String)value.toString()).isValid() || value instanceof JsonNode;
    }
}

