/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.states.EventState;
import java.util.List;
import java.util.function.BiFunction;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.CompositeContextNodeHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.utils.TimeoutsConfigResolver;

public class EventHandler
extends CompositeContextNodeHandler<EventState> {
    protected EventHandler(EventState state, Workflow workflow, ParserContext parserContext) {
        super(state, workflow, parserContext);
    }

    @Override
    public void handleStart() {
    }

    @Override
    public MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        return this.joinNodes(factory, ((EventState)this.state).getOnEvents(), this::processOnEvent);
    }

    private MakeNodeResult processOnEvent(RuleFlowNodeContainerFactory<?, ?> factory, OnEvents onEvent) {
        if (this.isStartState) {
            MakeNodeResult result = this.joinNodes(factory, onEvent.getEventRefs(), (fact, onEventRef) -> this.filterAndMergeNode((RuleFlowNodeContainerFactory<?, ?>)fact, onEvent.getEventDataFilter(), "workflowdata", (f, inputVar, outputVar) -> this.buildEventNode((RuleFlowNodeContainerFactory<?, ?>)f, (String)onEventRef, inputVar, outputVar)));
            CompositeContextNodeFactory<?> embeddedSubProcess = this.handleActions(this.makeCompositeNode(factory), onEvent.getActions());
            this.connect(result.getOutgoingNode(), (NodeFactory<?, ?>)embeddedSubProcess);
            return new MakeNodeResult(result.getIncomingNode(), (NodeFactory<?, ?>)embeddedSubProcess);
        }
        String varName = this.getVarName();
        CompositeContextNodeFactory<?> embeddedSubProcess = this.makeCompositeNode(factory);
        NodeFactory<?, ?> startNode = embeddedSubProcess.startNode(this.parserContext.newId()).name("EmbeddedStart");
        JoinFactory joinNode = null;
        String eventTimeout = TimeoutsConfigResolver.resolveEventTimeout(this.state, this.workflow);
        if (eventTimeout != null) {
            SplitFactory splitNode = NodeFactoryUtils.eventBasedSplitNode(embeddedSubProcess.splitNode(this.parserContext.newId()), 4);
            joinNode = NodeFactoryUtils.joinExclusiveNode(embeddedSubProcess.joinNode(this.parserContext.newId()));
            startNode = this.connect(startNode, (NodeFactory<?, ?>)splitNode);
            this.createTimerNode((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, splitNode, joinNode, eventTimeout);
        }
        MakeNodeResult result = this.joinNodes((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, onEvent.getEventRefs(), (BiFunction)(fact, onEventRef) -> this.filterAndMergeNode((RuleFlowNodeContainerFactory<?, ?>)fact, onEvent.getEventDataFilter(), varName, (f, inputVar, outputVar) -> this.buildEventNode((RuleFlowNodeContainerFactory<?, ?>)f, (String)onEventRef, inputVar, outputVar)));
        this.connect(startNode, result.getIncomingNode());
        NodeFactory<?, ?> currentNode = result.getOutgoingNode();
        for (Action action : onEvent.getActions()) {
            currentNode = this.connect(currentNode, this.getActionNode((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, action, varName, true));
        }
        if (joinNode != null) {
            currentNode = this.connect(currentNode, (NodeFactory<?, ?>)joinNode);
        }
        this.connect(currentNode, (NodeFactory<?, ?>)((EndNodeFactory)embeddedSubProcess.endNode(this.parserContext.newId()).name("EmbeddedEnd")).terminate(true)).done();
        this.handleErrors((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), (RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess);
        return new MakeNodeResult((NodeFactory<?, ?>)embeddedSubProcess);
    }

    private <T> MakeNodeResult joinNodes(RuleFlowNodeContainerFactory<?, ?> factory, List<T> events, BiFunction<RuleFlowNodeContainerFactory<?, ?>, T, MakeNodeResult> function) {
        int joinType;
        int splitType;
        if (events.size() == 1) {
            return function.apply(factory, (RuleFlowNodeContainerFactory<?, ?>)events.get(0));
        }
        if (((EventState)this.state).isExclusive()) {
            splitType = 4;
            joinType = 2;
        } else {
            splitType = 1;
            joinType = 1;
        }
        if (this.isStartState) {
            JoinFactory<?> joinFactory = this.joinFactory(factory, joinType);
            for (T event : events) {
                this.connect(function.apply(factory, (RuleFlowNodeContainerFactory<?, ?>)event).getOutgoingNode(), (NodeFactory<?, ?>)joinFactory);
            }
            return new MakeNodeResult((NodeFactory<?, ?>)joinFactory);
        }
        CompositeContextNodeFactory<?> compositeNode = this.makeCompositeNode(factory);
        SplitFactory splitFactory = ((SplitFactory)compositeNode.splitNode(this.parserContext.newId()).name(((EventState)this.state).getName() + "Split")).type(splitType);
        this.connect((NodeFactory<?, ?>)compositeNode.startNode(this.parserContext.newId()), (NodeFactory<?, ?>)splitFactory);
        JoinFactory<?> joinFactory = this.joinFactory((RuleFlowNodeContainerFactory<?, ?>)compositeNode, joinType);
        for (T event : events) {
            MakeNodeResult node = function.apply((RuleFlowNodeContainerFactory<?, ?>)compositeNode, (RuleFlowNodeContainerFactory<?, ?>)event);
            this.connect((NodeFactory<?, ?>)splitFactory, node.getIncomingNode());
            this.connect(node.getOutgoingNode(), (NodeFactory<?, ?>)joinFactory);
        }
        this.connect((NodeFactory<?, ?>)joinFactory, (NodeFactory<?, ?>)compositeNode.endNode(this.parserContext.newId()));
        return new MakeNodeResult((NodeFactory<?, ?>)compositeNode);
    }

    private JoinFactory<?> joinFactory(RuleFlowNodeContainerFactory<?, ?> factory, int joinType) {
        return factory.joinNode(this.parserContext.newId()).name(((EventState)this.state).getName() + "Join").type(joinType);
    }

    private NodeFactory<?, ?> buildEventNode(RuleFlowNodeContainerFactory<?, ?> factory, String eventRef, String inputVar, String outputVar) {
        return this.isStartState ? this.messageStartNode(factory, eventRef, inputVar, outputVar) : this.consumeEventNode(factory, eventRef, inputVar, outputVar);
    }

    private StartNodeFactory<?> messageStartNode(RuleFlowNodeContainerFactory<?, ?> factory, String eventRef, String inputVar, String outputVar) {
        return NodeFactoryUtils.startMessageNode(factory.startNode(this.parserContext.newId()), this.eventDefinition(eventRef), inputVar, outputVar);
    }
}

