/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.util;

import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.services.taskassigning.core.model.Group;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.User;
import org.kie.server.services.taskassigning.planning.data.LabelValueExtractorRegistry;
import org.kie.server.services.taskassigning.planning.util.UserUtil;

public class TaskUtil {
    private TaskUtil() {
    }

    public static Task fromTaskData(TaskData taskData) {
        Task task = new Task(taskData.getTaskId().longValue(), taskData.getProcessInstanceId().longValue(), taskData.getProcessId(), taskData.getContainerId(), taskData.getName(), taskData.getPriority().intValue(), taskData.getStatus(), taskData.getInputData());
        if (taskData.getPotentialOwners() != null) {
            taskData.getPotentialOwners().forEach(potentialOwner -> {
                if (UserUtil.isUser(potentialOwner.getType())) {
                    task.getPotentialOwners().add(new User((long)potentialOwner.getName().hashCode(), potentialOwner.getName()));
                } else {
                    task.getPotentialOwners().add(new Group((long)potentialOwner.getName().hashCode(), potentialOwner.getName()));
                }
            });
        }
        LabelValueExtractorRegistry.getInstance().applyLabelValueExtractors(TaskData.class, taskData, (arg_0, arg_1) -> ((Task)task).setLabelValues(arg_0, arg_1));
        return task;
    }
}

