package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIEffect;

public class HtmlEffect extends UIEffect{

public final static  String COMPONENT_FAMILY = "org.richfaces.Effect";

public final static  String COMPONENT_TYPE = "org.richfaces.Effect";

/*
* Disable default action for target event ( append "return false;" to JavaScript ). Default value is "false".
*/
private  boolean _disableDefault = false;

private  boolean _disableDefaultSet = false;

/*
* Event on the component or html tag the effect is attached to
*/
private  String _event = "";

/*
* Id of the target component.
*/
private  String _for = null;

/*
* Generated JavaScript name.
*/
private  String _name = null;

/*
* onsubmit
*/
private  String _onsubmit = null;

/*
* Parameters passed to the effect function.
			  Example params="{duration:0.2,from:1.0,to:0.1}"
*/
private  String _params = null;

/*
* The id of the element the effect apply to. Might be component id
			  or client id of jsf component or html tag. If targetId is not defined
			  the value of the attribute 'for' or the 'targetId' option effect
			  play its role
*/
private  String _targetId = null;

/*
* Defines the type of effect. Possible values: "Fade", "Blind", "Opacity".
*/
private  String _type = null;


public HtmlEffect(){
setRendererType("org.richfaces.EffectRenderer");
}

public boolean isDisableDefault(){
	if (this._disableDefaultSet) {
	    return (this._disableDefault);
	}
	ValueExpression ve = getValueExpression("disableDefault");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disableDefault);
	    }
	    
	    return value;
	} else {
	    return (this._disableDefault);
	}

}

public void setDisableDefault(boolean _disableDefault){
this._disableDefault = _disableDefault;
this._disableDefaultSet = true;
}

public String getEvent(){
return _event;
}

public void setEvent(String _event){
this._event = _event;
}

public String getFor(){
	if (this._for != null) {
		return this._for;
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setFor(String _for){
this._for = _for;
}

public String getName(){
	if (this._name != null) {
		return this._name;
	}
	ValueExpression ve = getValueExpression("name");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setName(String _name){
this._name = _name;
}

public String getOnsubmit(){
	if (this._onsubmit != null) {
		return this._onsubmit;
	}
	ValueExpression ve = getValueExpression("onsubmit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsubmit(String _onsubmit){
this._onsubmit = _onsubmit;
}

public String getParams(){
	if (this._params != null) {
		return this._params;
	}
	ValueExpression ve = getValueExpression("params");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setParams(String _params){
this._params = _params;
}

public String getTargetId(){
	if (this._targetId != null) {
		return this._targetId;
	}
	ValueExpression ve = getValueExpression("targetId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTargetId(String _targetId){
this._targetId = _targetId;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setType(String _type){
this._type = _type;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[10];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_disableDefault);
state[2] = Boolean.valueOf(_disableDefaultSet);
state[3] = _event;
state[4] = _for;
state[5] = _name;
state[6] = _onsubmit;
state[7] = _params;
state[8] = _targetId;
state[9] = _type;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_disableDefault = ((Boolean)states[1]).booleanValue();
		_disableDefaultSet = ((Boolean)states[2]).booleanValue();
		_event = (String)states[3];;
		_for = (String)states[4];;
		_name = (String)states[5];;
		_onsubmit = (String)states[6];;
		_params = (String)states[7];;
		_targetId = (String)states[8];;
		_type = (String)states[9];;
	
}

}
