/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2;

import com.box.boxjavalibv2.BoxConfig;
import com.box.boxjavalibv2.BoxRESTClient;
import com.box.boxjavalibv2.authorization.OAuthAuthorization;
import com.box.boxjavalibv2.authorization.OAuthDataController;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.authorization.SharedLinkAuthorization;
import com.box.boxjavalibv2.dao.BoxBase;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.events.OAuthEvent;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.interfaces.IAuthData;
import com.box.boxjavalibv2.interfaces.IAuthDataController;
import com.box.boxjavalibv2.interfaces.IAuthEvent;
import com.box.boxjavalibv2.interfaces.IAuthFlowListener;
import com.box.boxjavalibv2.interfaces.IAuthFlowMessage;
import com.box.boxjavalibv2.interfaces.IAuthFlowUI;
import com.box.boxjavalibv2.interfaces.IAuthSecureStorage;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.interfaces.IPluginResourceManagerBuilder;
import com.box.boxjavalibv2.jsonparsing.BoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.BoxResourceHub;
import com.box.boxjavalibv2.resourcemanagers.BoxCollaborationsManager;
import com.box.boxjavalibv2.resourcemanagers.BoxCommentsManager;
import com.box.boxjavalibv2.resourcemanagers.BoxEventsManager;
import com.box.boxjavalibv2.resourcemanagers.BoxFilesManager;
import com.box.boxjavalibv2.resourcemanagers.BoxFoldersManager;
import com.box.boxjavalibv2.resourcemanagers.BoxGroupsManager;
import com.box.boxjavalibv2.resourcemanagers.BoxOAuthManager;
import com.box.boxjavalibv2.resourcemanagers.BoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.BoxSearchManager;
import com.box.boxjavalibv2.resourcemanagers.BoxSharedItemsManager;
import com.box.boxjavalibv2.resourcemanagers.BoxUsersManager;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class BoxClient
extends BoxBase
implements IAuthFlowListener {
    private static final boolean DEFAULT_AUTO_REFRESH = true;
    private final IAuthDataController authController;
    private final IBoxRequestAuth auth;
    private final IBoxResourceHub resourceHub;
    private final IBoxJSONParser jsonParser;
    private final IBoxRESTClient restClient;
    private final BoxFilesManager filesManager;
    private final BoxFoldersManager foldersManager;
    private final BoxSearchManager searchManager;
    private final BoxEventsManager eventsManager;
    private final BoxCollaborationsManager collaborationsManager;
    private final BoxCommentsManager commentsManager;
    private final BoxUsersManager usersManager;
    private final BoxOAuthManager oauthManager;
    private final BoxGroupsManager groupsManager;
    private IAuthFlowListener mAuthListener;
    private final Map<String, BoxResourceManager> pluginResourceManagers = new HashMap<String, BoxResourceManager>();

    public BoxClient(String clientId, String clientSecret, IBoxResourceHub hub, IBoxJSONParser parser, int maxConnection, int maxConnectionPerRoute, long timePeriodCleanUpIdleConnection, long idleTimeThreshold) {
        this(clientId, clientSecret, hub, parser, BoxClient.createMonitoredRestClient(maxConnection, maxConnectionPerRoute, timePeriodCleanUpIdleConnection, idleTimeThreshold));
    }

    public BoxClient(String clientId, String clientSecret, IBoxResourceHub hub, IBoxJSONParser parser) {
        this(clientId, clientSecret, hub, parser, BoxClient.createRestClient());
    }

    public BoxClient(String clientId, String clientSecret, IBoxResourceHub hub, IBoxJSONParser parser, IBoxRESTClient restClient) {
        this.resourceHub = hub == null ? this.createResourceHub() : hub;
        this.jsonParser = parser == null ? this.createJSONParser(this.resourceHub) : parser;
        this.restClient = restClient;
        this.authController = this.createAuthDataController(clientId, clientSecret);
        this.auth = this.createAuthorization(this.authController);
        this.filesManager = new BoxFilesManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.foldersManager = new BoxFoldersManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.searchManager = new BoxSearchManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.eventsManager = new BoxEventsManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.collaborationsManager = new BoxCollaborationsManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.commentsManager = new BoxCommentsManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.usersManager = new BoxUsersManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.oauthManager = new BoxOAuthManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getRestClient());
        this.groupsManager = new BoxGroupsManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
    }

    @Deprecated
    public BoxClient(String clientId, String clientSecret) {
        this(clientId, clientSecret, null, null);
    }

    public BoxResourceManager pluginResourceManager(String key, IPluginResourceManagerBuilder builder) {
        BoxResourceManager manager = builder.build(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.pluginResourceManagers.put(key, manager);
        return manager;
    }

    public boolean isAuthenticated() {
        try {
            return this.getOAuthDataController().getTokenState() != OAuthDataController.OAuthTokenState.FAIL && this.getAuthData() != null;
        }
        catch (AuthFatalFailureException e) {
            return false;
        }
    }

    public void setAutoRefreshOAuth(boolean autoRefresh) {
        this.getOAuthDataController().setAutoRefreshOAuth(autoRefresh);
    }

    public void setConnectionOpen(boolean connectionOpen) {
        ((BoxRESTClient)this.getRestClient()).setConnectionOpen(connectionOpen);
    }

    public void setConnectionTimeOut(int timeOut) {
        ((BoxRESTClient)this.getRestClient()).setConnectionTimeOut(timeOut);
    }

    public OAuthDataController getOAuthDataController() {
        return (OAuthDataController)this.authController;
    }

    public void addOAuthRefreshListener(OAuthRefreshListener listener) {
        this.getOAuthDataController().addOAuthRefreshListener(listener);
    }

    public BoxOAuthToken getAuthData() throws AuthFatalFailureException {
        return this.getOAuthDataController().getAuthData();
    }

    public void saveAuth(IAuthSecureStorage storage) throws AuthFatalFailureException {
        storage.saveAuth(this.getAuthData());
    }

    public void authenticateFromSecureStorage(IAuthSecureStorage storage) {
        this.authenticate(storage.getAuth());
    }

    public BoxFilesManager getFilesManager() {
        return this.filesManager;
    }

    public BoxOAuthManager getOAuthManager() {
        return this.oauthManager;
    }

    public BoxGroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    public BoxSharedItemsManager getSharedItemsManager(String sharedLink, String password) {
        return new BoxSharedItemsManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public BoxFilesManager getSharedFilesManager(String sharedLink, String password) {
        return new BoxFilesManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public BoxFoldersManager getSharedFoldersManager(String sharedLink, String password) {
        return new BoxFoldersManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public BoxCommentsManager getSharedCommentsManager(String sharedLink, String password) {
        return new BoxCommentsManager(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public BoxResourceManager getResourceManagerWithSharedLinkAuth(BoxResourceType type, String sharedLink, String password) {
        switch (type) {
            case FILE: {
                return this.getSharedFilesManager(sharedLink, password);
            }
            case FOLDER: {
                return this.getSharedFoldersManager(sharedLink, password);
            }
            case COMMENT: {
                return this.getSharedCommentsManager(sharedLink, password);
            }
        }
        throw new NotImplementedException();
    }

    public BoxResourceManager getPluginManager(String pluginManagerKey) {
        return this.pluginResourceManagers.get(pluginManagerKey);
    }

    public BoxFoldersManager getFoldersManager() {
        return this.foldersManager;
    }

    public BoxSearchManager getSearchManager() {
        return this.searchManager;
    }

    public BoxEventsManager getEventsManager() {
        return this.eventsManager;
    }

    public BoxCollaborationsManager getCollaborationsManager() {
        return this.collaborationsManager;
    }

    public BoxCommentsManager getCommentsManager() {
        return this.commentsManager;
    }

    public BoxUsersManager getUsersManager() {
        return this.usersManager;
    }

    public void authenticate(IAuthData authData) {
        OAuthDataController con = this.getOAuthDataController();
        con.setOAuthData((BoxOAuthToken)authData);
        if (authData != null) {
            con.setTokenState(OAuthDataController.OAuthTokenState.AVAILABLE);
        } else {
            con.setTokenState(OAuthDataController.OAuthTokenState.PRE_CREATION);
        }
    }

    public void authenticate(IAuthFlowUI authFlowUI, boolean autoRefreshOAuth, IAuthFlowListener listener) {
        this.mAuthListener = listener;
        authFlowUI.authenticate(this);
    }

    @Override
    public void onAuthFlowEvent(IAuthEvent event, IAuthFlowMessage message) {
        OAuthEvent oe = (OAuthEvent)event;
        if (oe == OAuthEvent.OAUTH_CREATED) {
            ((OAuthAuthorization)this.getAuth()).setOAuthData(this.getOAuthTokenFromMessage(message));
        }
        if (this.mAuthListener != null) {
            this.mAuthListener.onAuthFlowEvent(event, message);
        }
    }

    public OAuthDataController.OAuthTokenState getAuthState() {
        return this.getOAuthDataController().getTokenState();
    }

    public IBoxConfig getConfig() {
        return BoxConfig.getInstance();
    }

    protected IBoxResourceHub createResourceHub() {
        return new BoxResourceHub();
    }

    protected IBoxJSONParser createJSONParser(IBoxResourceHub resourceHub) {
        return new BoxJSONParser(resourceHub);
    }

    public IBoxResourceHub getResourceHub() {
        return this.resourceHub;
    }

    public IBoxJSONParser getJSONParser() {
        return this.jsonParser;
    }

    protected IBoxRESTClient getRestClient() {
        return this.restClient;
    }

    protected static IBoxRESTClient createRestClient() {
        return new BoxRESTClient();
    }

    protected static IBoxRESTClient createMonitoredRestClient(int maxConnection, int maxConnectionPerRoute, long timePeriodCleanUpIdleConnection, long idleTimeThreshold) {
        return new BoxRESTClient(maxConnection, maxConnectionPerRoute, timePeriodCleanUpIdleConnection, idleTimeThreshold);
    }

    public IBoxRequestAuth getSharedItemAuth(String sharedLink, String password) {
        return new SharedLinkAuthorization((OAuthAuthorization)this.getAuth(), sharedLink, password);
    }

    public IAuthDataController createAuthDataController(String clientId, String clientSecret) {
        return new OAuthDataController(this, clientId, clientSecret, true);
    }

    public IBoxRequestAuth createAuthorization(IAuthDataController controller) {
        return new OAuthAuthorization((OAuthDataController)this.authController);
    }

    public IBoxRequestAuth getAuth() {
        return this.auth;
    }

    @Override
    public void onAuthFlowMessage(IAuthFlowMessage message) {
        if (this.mAuthListener != null) {
            this.mAuthListener.onAuthFlowMessage(message);
        }
    }

    @Override
    public void onAuthFlowException(Exception e) {
        if (this.mAuthListener != null) {
            this.mAuthListener.onAuthFlowException(e);
        }
    }

    protected BoxOAuthToken getOAuthTokenFromMessage(IAuthFlowMessage message) {
        return (BoxOAuthToken)message.getData();
    }
}

