/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2;

import com.box.boxjavalibv2.authorization.OAuthAuthorization;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedHttpStatusException;
import com.box.boxjavalibv2.utils.Utils;
import com.box.restclientv2.BoxBasicRestClient;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxRequest;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import com.box.restclientv2.interfaces.IBoxResponse;
import com.box.restclientv2.interfaces.IBoxRestVisitor;
import com.box.restclientv2.responses.DefaultBoxResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class BoxRESTClient
extends BoxBasicRestClient {
    public static final String ENTITY_CANNOT_BE_RETRIED = "OAuth token expired, failed to re-send request after refreshing OAuth, the entity in the request cannot be reused, please retry manually";
    private static AtomicInteger apiSequenceId = new AtomicInteger(0);
    public static final String OAUTH_ERROR_HEADER = "error";
    public static final String OAUTH_INVALID_TOKEN = "invalid_token";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private final List<IBoxRestVisitor> visitors = new ArrayList<IBoxRestVisitor>();
    private boolean keepConnectionOpen = true;
    private int clientTimeOut = -1;

    public BoxRESTClient() {
    }

    public BoxRESTClient(int maxConnection, int maxConnectionPerRoute, long timePeriodCleanUpIdleConnection, long idleTimeThreshold) {
        super(maxConnection, maxConnectionPerRoute, timePeriodCleanUpIdleConnection, idleTimeThreshold);
    }

    public void acceptRestVisitor(IBoxRestVisitor visitor) {
        this.visitors.add(visitor);
    }

    public void setConnectionOpen(boolean connectionOpen) {
        this.keepConnectionOpen = connectionOpen;
    }

    @Override
    public IBoxResponse execute(IBoxRequest boxRequest) throws BoxRestException, AuthFatalFailureException {
        IBoxRequestAuth auth = boxRequest.getAuth();
        return this.execute(boxRequest, auth instanceof OAuthAuthorization);
    }

    private IBoxResponse execute(IBoxRequest boxRequest, boolean usingOAuth) throws BoxRestException, AuthFatalFailureException {
        HttpUriRequest httpRequest = boxRequest.prepareRequest();
        HttpResponse response = null;
        int sequenceId = apiSequenceId.incrementAndGet();
        for (IBoxRestVisitor v : this.visitors) {
            v.visitRequestBeforeSend((HttpRequest)httpRequest, sequenceId);
        }
        try {
            try {
                response = this.getResponse(httpRequest);
                for (IBoxRestVisitor v : this.visitors) {
                    v.visitResponseUponReceiving(response, sequenceId);
                }
                if (usingOAuth && this.oauthExpired(response)) {
                    Utils.consumeHttpEntityQuietly(response.getEntity());
                    try {
                        return this.handleOAuthTokenExpire((OAuthAuthorization)boxRequest.getAuth(), boxRequest);
                    }
                    catch (AuthFatalFailureException e) {
                        for (IBoxRestVisitor v : this.visitors) {
                            v.visitException(e, sequenceId);
                        }
                        throw e;
                    }
                }
            }
            catch (IOException e) {
                this.handleException(e, sequenceId);
            }
            catch (BoxUnexpectedHttpStatusException e) {
                this.handleException(e, sequenceId);
            }
        }
        catch (BoxRestException e) {
            if (response != null) {
                Utils.consumeHttpEntityQuietly(response.getEntity());
            }
            throw e;
        }
        DefaultBoxResponse boxResponse = new DefaultBoxResponse(response);
        boxResponse.setExpectedResponseCode(boxRequest.getExpectedResponseCode());
        return boxResponse;
    }

    public void setConnectionTimeOut(int timeOut) {
        this.clientTimeOut = timeOut;
    }

    protected HttpResponse getResponse(HttpUriRequest request) throws ClientProtocolException, IOException {
        HttpClient client = this.getRawHttpClient();
        if (this.clientTimeOut > 0) {
            HttpParams params = client.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.clientTimeOut);
        }
        request.addHeader("Connection", this.keepConnectionOpen ? "Keep-Alive" : "close");
        return client.execute(request);
    }

    private boolean oauthExpired(HttpResponse response) {
        if (401 != response.getStatusLine().getStatusCode()) {
            return false;
        }
        Header header = response.getFirstHeader(WWW_AUTHENTICATE);
        if (header != null) {
            String[] authStrs;
            String authStr = header.getValue();
            for (String str : authStrs = authStr.split(",")) {
                if (!this.isInvalidTokenError(str)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInvalidTokenError(String str) {
        String[] parts = str.split("=");
        return parts.length == 2 && parts[0] != null && parts[1] != null && OAUTH_ERROR_HEADER.equalsIgnoreCase(parts[0].trim()) && OAUTH_INVALID_TOKEN.equalsIgnoreCase(parts[1].replace("\"", "").trim());
    }

    private void handleException(Exception e, int sequenceId) throws BoxRestException {
        for (IBoxRestVisitor v : this.visitors) {
            v.visitException(e, sequenceId);
        }
        throw new BoxRestException(e);
    }

    private IBoxResponse handleOAuthTokenExpire(OAuthAuthorization auth, IBoxRequest boxRequest) throws AuthFatalFailureException, BoxRestException, BoxUnexpectedHttpStatusException {
        auth.refresh();
        HttpEntity entity = boxRequest.getRequestEntity();
        if (entity.isRepeatable()) {
            return this.execute(boxRequest, true);
        }
        throw new BoxRestException(ENTITY_CANNOT_BE_RETRIED);
    }
}

