/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class ConnectionMonitor {
    private static ClientConnectionManager connManager;
    private static int maxConnectionPerRoute;
    private static int maxConnection;
    private static long timePeriodCleanUpIdleConnection;
    private static long idleTimeThreshold;

    public static synchronized ClientConnectionManager getConnectionManagerInstance() {
        if (connManager == null) {
            SchemeRegistry schemeReg = new SchemeRegistry();
            schemeReg.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeReg.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            connManager = new ThreadSafeClientConnManager(ConnectionMonitor.getHttpParams(), schemeReg);
            ConnectionMonitor.monitorConnection(connManager);
        }
        return connManager;
    }

    public static HttpParams getHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)maxConnection);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute httpRoute) {
                return maxConnectionPerRoute;
            }
        });
        return params;
    }

    private static void monitorConnection(ClientConnectionManager connManager) {
        final WeakReference<ClientConnectionManager> ref = new WeakReference<ClientConnectionManager>(connManager);
        connManager = null;
        Thread monitorThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            ClientConnectionManager connMan = (ClientConnectionManager)ref.get();
                            if (connMan == null) {
                                return;
                            }
                            this.wait(timePeriodCleanUpIdleConnection);
                            connMan.closeExpiredConnections();
                            connMan.closeIdleConnections(idleTimeThreshold, TimeUnit.SECONDS);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        monitorThread.start();
    }

    public static void setMaxConnectionPerRoute(int maxConnectionPerRoute) {
        ConnectionMonitor.maxConnectionPerRoute = maxConnectionPerRoute;
    }

    public static void setMaxConnection(int maxConnection) {
        ConnectionMonitor.maxConnection = maxConnection;
    }

    public static void setTimePeriodCleanUpIdleConnection(long timePeriodCleanUpIdleConnection) {
        ConnectionMonitor.timePeriodCleanUpIdleConnection = timePeriodCleanUpIdleConnection;
    }

    public static void setIdleTimeThreshold(long idleTimeThreshold) {
        ConnectionMonitor.idleTimeThreshold = idleTimeThreshold;
    }

    static {
        maxConnectionPerRoute = 50;
        maxConnection = 1000;
        timePeriodCleanUpIdleConnection = 300000L;
        idleTimeThreshold = 60000L;
    }
}

