/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.interfaces.IAuthDataController;
import com.box.boxjavalibv2.requests.requestobjects.BoxOAuthRequestObject;

public class OAuthDataController
implements IAuthDataController {
    private static final int WAIT = 200;
    private static final int WAIT_TIME_OUT = 60000;
    private final BoxClient mClient;
    private final String mClientId;
    private final String mClientSecret;
    private String mDeviceId = null;
    private String mDeviceName = null;
    private volatile BoxOAuthToken mOAuthToken;
    private volatile OAuthTokenState mTokenState = OAuthTokenState.PRE_CREATION;
    private boolean mAutoRefresh;
    private int mWaitTimeOut = 60000;
    private Exception refreshFailException;
    private volatile boolean locked = false;
    private OAuthRefreshListener refreshListener;

    public OAuthDataController(BoxClient boxClient, String clientId, String clientSecret, boolean autoRefresh) {
        this.mClient = boxClient;
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mAutoRefresh = autoRefresh;
    }

    public void setAutoRefreshOAuth(boolean autoRefresh) {
        this.mAutoRefresh = autoRefresh;
    }

    public void setWaitTimeOut(int timeout) {
        this.mWaitTimeOut = timeout;
    }

    public String getScheme() {
        return this.mClient.getConfig().getOAuthUrlScheme();
    }

    public String getAuthority() {
        return this.mClient.getConfig().getOAuthUrlAuthority();
    }

    public String getUrlPath() {
        return this.mClient.getConfig().getOAuthWebUrlPath();
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public void setOAuthData(BoxOAuthToken token) {
        this.mOAuthToken = token;
    }

    public void setDeviceId(String deviceId) {
        this.mDeviceId = deviceId;
    }

    public void setDeviceName(String deviceName) {
        this.mDeviceName = deviceName;
    }

    public OAuthTokenState getTokenState() {
        return this.mTokenState;
    }

    public void setTokenState(OAuthTokenState tokenState) {
        this.mTokenState = tokenState;
    }

    public Exception getRefreshFailException() {
        return this.refreshFailException;
    }

    public void setRefreshFail(Exception refreshFailException) {
        this.refreshFailException = refreshFailException;
        if (refreshFailException != null) {
            this.setTokenState(OAuthTokenState.FAIL);
        }
    }

    public void initialize() {
        this.setTokenState(OAuthTokenState.AVAILABLE);
        this.setRefreshFail(null);
        this.unlock();
    }

    @Override
    public BoxOAuthToken getAuthData() throws AuthFatalFailureException {
        long num = 0L;
        while (num * 200L <= (long)this.mWaitTimeOut) {
            if (this.getAndSetLock(false)) {
                return this.mOAuthToken;
            }
            this.doWait();
            ++num;
        }
        throw new AuthFatalFailureException(this.getRefreshFailException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws AuthFatalFailureException {
        if (!this.getAndSetLock(true)) {
            this.getAuthData();
        } else {
            try {
                if (this.getTokenState() == OAuthTokenState.FAIL || !this.mAutoRefresh) {
                    this.setTokenState(OAuthTokenState.FAIL);
                    throw new AuthFatalFailureException(this.getRefreshFailException());
                }
                this.doRefresh();
            }
            finally {
                this.unlock();
            }
        }
    }

    public synchronized boolean getAndSetLock(boolean doLock) {
        boolean lockRetrieved = false;
        if (doLock) {
            if (this.locked) {
                lockRetrieved = false;
            } else {
                this.locked = true;
                lockRetrieved = true;
            }
        } else {
            lockRetrieved = !this.locked;
        }
        return lockRetrieved;
    }

    private void unlock() {
        this.locked = false;
    }

    private void doRefresh() throws AuthFatalFailureException {
        this.setTokenState(OAuthTokenState.REFRESHING);
        try {
            BoxOAuthRequestObject requestObj = BoxOAuthRequestObject.refreshOAuthRequestObject(this.mOAuthToken.getRefreshToken(), this.mClientId, this.mClientSecret);
            requestObj.put("device_id", this.mDeviceId);
            requestObj.put("device_name", this.mDeviceName);
            this.mOAuthToken = this.mClient.getOAuthManager().refreshOAuth(requestObj);
            this.setTokenState(OAuthTokenState.AVAILABLE);
            this.setRefreshFail(null);
            if (this.refreshListener != null) {
                this.refreshListener.onRefresh(this.mOAuthToken);
            }
        }
        catch (Exception e) {
            this.setRefreshFail(e);
            throw new AuthFatalFailureException(this.getRefreshFailException());
        }
    }

    private void doWait() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addOAuthRefreshListener(OAuthRefreshListener listener) {
        this.refreshListener = listener;
    }

    public static enum OAuthTokenState {
        PRE_CREATION,
        AVAILABLE,
        REFRESHING,
        FAIL;

    }
}

