/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.dao;

import com.box.boxjavalibv2.interfaces.IBoxType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum BoxResourceType implements IBoxType
{
    ITEM,
    ITEMS,
    FILE,
    FILES,
    WEB_LINK,
    WEB_LINKS,
    PREVIEW,
    FOLDER,
    USER,
    USERS,
    GROUP,
    GROUPS,
    COMMENT,
    COMMENTS,
    FILE_VERSION,
    FILE_VERSIONS,
    COLLABORATION,
    COLLABORATIONS,
    EMAIL_ALIAS,
    EMAIL_ALIASES,
    OAUTH_DATA,
    ERROR,
    EVENT,
    EVENTS,
    REALTIME_SERVER,
    LOCK,
    SERVICE_ACTION,
    GROUP_MEMBERSHIP,
    GROUP_MEMBERSHIPS;

    private static final Map<BoxResourceType, String> typeToLowercaseString;

    public String toString() {
        return typeToLowercaseString.get(this);
    }

    public String toPluralString() {
        return this.toString() + "s";
    }

    @Deprecated
    public static BoxResourceType getTypeFromLowercaseString(String string) {
        return Enum.valueOf(BoxResourceType.class, string.toUpperCase(Locale.US));
    }

    static {
        typeToLowercaseString = new HashMap<BoxResourceType, String>();
        for (BoxResourceType type : BoxResourceType.values()) {
            String str = type.name().toLowerCase(Locale.US);
            typeToLowercaseString.put(type, str);
        }
    }
}

