/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.requests;

import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.restclientv2.RestMethod;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.httpclientsupport.HttpClientURIBuilder;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRequest;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import com.box.restclientv2.interfaces.ICookie;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class DefaultBoxRequest
implements IBoxRequest {
    private static final String FIELDS = "fields";
    private static final String DELIMITER = ",";
    private WeakReference<IBoxRequestAuth> mAuth;
    private final IBoxConfig mConfig;
    private HttpEntity mEntity;
    private ICookie mCookie;
    private final RestMethod mRestMethod;
    private final String uriPath;
    private final HashMap<String, String> queryParams = new HashMap();
    private final HashMap<String, String> headers = new HashMap();
    private HttpRequestBase rawRequest;
    private final HttpParams httpParams = new BasicHttpParams();
    private int expectedResponseCode = 200;

    public DefaultBoxRequest(IBoxConfig config, IBoxJSONParser parser, String uriPath, RestMethod restMethod, BoxDefaultRequestObject requestObject) throws BoxRestException {
        this.mConfig = config;
        this.mRestMethod = restMethod;
        this.uriPath = uriPath;
        this.getHeaders().put("User-Agent", this.getConfig().getUserAgent());
        if (requestObject != null) {
            requestObject.setJSONParser(parser);
            this.setEntity(requestObject.getEntity());
            this.setRequestFields(requestObject.getFields());
            this.getQueryParams().putAll(requestObject.getQueryParams());
            this.getHeaders().putAll(requestObject.getHeaders());
        }
    }

    @Override
    public int getExpectedResponseCode() {
        return this.expectedResponseCode;
    }

    protected void setExpectedResponseCode(int code) {
        this.expectedResponseCode = code;
    }

    @Override
    public HttpParams getHttpParams() {
        return this.httpParams;
    }

    @Override
    public IBoxRequestAuth getAuth() {
        return this.mAuth != null ? (IBoxRequestAuth)this.mAuth.get() : null;
    }

    @Override
    public ICookie getCookie() {
        return this.mCookie;
    }

    @Override
    public HttpEntity getRequestEntity() {
        return this.mEntity;
    }

    @Override
    public RestMethod getRestMethod() {
        return this.mRestMethod;
    }

    public HttpRequestBase getRawRequest() {
        return this.rawRequest;
    }

    @Override
    public void setAuth(IBoxRequestAuth auth) {
        this.mAuth = new WeakReference<IBoxRequestAuth>(auth);
    }

    @Override
    public void setCookie(ICookie cookie) {
        this.mCookie = cookie;
    }

    public void setEntity(HttpEntity entity) {
        this.mEntity = entity;
    }

    @Override
    public void addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIfMatch(String ifMatch) {
        this.addHeader("If-Match", ifMatch);
    }

    public void setRequestFields(List<String> fields) {
        StringBuilder sbr = new StringBuilder();
        if (fields != null && !fields.isEmpty()) {
            int size = fields.size();
            for (int i = 0; i < size - 1; ++i) {
                sbr.append(fields.get(i)).append(DELIMITER);
            }
            sbr.append(fields.get(size - 1));
            this.addQueryParam(FIELDS, sbr.toString());
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHttpParam(String name, String value) {
        this.httpParams.setParameter(name, (Object)value);
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public HttpRequestBase prepareRequest() throws BoxRestException, AuthFatalFailureException {
        this.rawRequest = this.constructHttpUriRequest();
        try {
            HttpClientURIBuilder ub = new HttpClientURIBuilder();
            ub.setHost(this.getAuthority());
            ub.setScheme(this.getScheme());
            ub.setPath(this.getApiUrlPath().concat(this.uriPath).replaceAll("/{2,}", "/"));
            for (Map.Entry<String, String> entry : this.getQueryParams().entrySet()) {
                ub.addParameter(entry.getKey(), StringUtils.defaultIfEmpty((String)entry.getValue(), (String)""));
            }
            this.rawRequest.setURI(ub.build());
        }
        catch (URISyntaxException e) {
            throw new BoxRestException("URISyntaxException:" + e.getMessage());
        }
        if (this.getAuth() != null) {
            this.getAuth().setAuth(this);
        }
        if (this.getCookie() != null) {
            this.getCookie().setCookie(this);
        }
        if (this.getRequestEntity() != null && this.rawRequest instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)this.rawRequest).setEntity(this.getRequestEntity());
        }
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            this.rawRequest.addHeader(entry.getKey(), entry.getValue());
        }
        this.rawRequest.setParams(this.getHttpParams());
        return this.rawRequest;
    }

    public IBoxConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public String getScheme() {
        return this.mConfig.getApiUrlScheme();
    }

    @Override
    public String getAuthority() {
        return this.mConfig.getApiUrlAuthority();
    }

    @Override
    public String getApiUrlPath() {
        return this.mConfig.getApiUrlPath();
    }

    HttpRequestBase constructHttpUriRequest() throws BoxRestException {
        switch (this.getRestMethod()) {
            case GET: {
                return new HttpGet();
            }
            case PUT: {
                return new HttpPut();
            }
            case POST: {
                return new HttpPost();
            }
            case DELETE: {
                return new HttpDelete();
            }
            case OPTIONS: {
                return new HttpOptions();
            }
        }
        throw new BoxRestException("Method Not Implemented");
    }
}

