/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.responseparsers;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxResponse;
import com.box.restclientv2.interfaces.IBoxResponseParser;
import com.box.restclientv2.responses.DefaultBoxResponse;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;

public class DefaultBoxJSONResponseParser
implements IBoxResponseParser {
    private final Class objectClass;
    private final IBoxJSONParser mParser;

    public DefaultBoxJSONResponseParser(Class objectClass, IBoxJSONParser parser) {
        this.objectClass = objectClass;
        this.mParser = parser;
    }

    public IBoxJSONParser getParser() {
        return this.mParser;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    @Override
    public Object parse(IBoxResponse response) throws BoxRestException {
        if (!(response instanceof DefaultBoxResponse)) {
            throw new BoxRestException("class mismatch, expected:" + DefaultBoxResponse.class.getName() + ";current:" + response.getClass().getName());
        }
        HttpResponse httpResponse = ((DefaultBoxResponse)response).getHttpResponse();
        InputStream in = null;
        try {
            in = httpResponse.getEntity().getContent();
            if (in == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = this.parseInputStream(in);
            return object;
        }
        catch (Exception e) {
            throw new BoxRestException(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    protected Object parseInputStream(InputStream in) throws BoxRestException, BoxJSONException {
        return this.mParser.parseIntoBoxObject(in, this.objectClass);
    }
}

