/*
 * Decompiled with CFR 0.152.
 */
package com.readytalk.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.readytalk.metrics.StatsD;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StatsDReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(StatsDReporter.class);
    private final StatsD statsD;
    private final String prefix;

    private StatsDReporter(MetricRegistry registry, StatsD statsD, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "statsd-reporter", filter, rateUnit, durationUnit);
        this.statsD = statsD;
        this.prefix = prefix;
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.statsD.connect();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to report to StatsD", (Object)this.statsD, (Object)e);
        }
        finally {
            try {
                this.statsD.close();
            }
            catch (IOException e) {
                LOG.debug("Error disconnecting from StatsD", (Object)this.statsD, (Object)e);
            }
        }
    }

    private void reportTimer(String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.statsD.send(this.prefix(name, "max"), this.formatNumber(this.convertDuration(snapshot.getMax())));
        this.statsD.send(this.prefix(name, "mean"), this.formatNumber(this.convertDuration(snapshot.getMean())));
        this.statsD.send(this.prefix(name, "min"), this.formatNumber(this.convertDuration(snapshot.getMin())));
        this.statsD.send(this.prefix(name, "stddev"), this.formatNumber(this.convertDuration(snapshot.getStdDev())));
        this.statsD.send(this.prefix(name, "p50"), this.formatNumber(this.convertDuration(snapshot.getMedian())));
        this.statsD.send(this.prefix(name, "p75"), this.formatNumber(this.convertDuration(snapshot.get75thPercentile())));
        this.statsD.send(this.prefix(name, "p95"), this.formatNumber(this.convertDuration(snapshot.get95thPercentile())));
        this.statsD.send(this.prefix(name, "p98"), this.formatNumber(this.convertDuration(snapshot.get98thPercentile())));
        this.statsD.send(this.prefix(name, "p99"), this.formatNumber(this.convertDuration(snapshot.get99thPercentile())));
        this.statsD.send(this.prefix(name, "p999"), this.formatNumber(this.convertDuration(snapshot.get999thPercentile())));
        this.reportMetered(name, (Metered)timer);
    }

    private void reportMetered(String name, Metered meter) {
        this.statsD.send(this.prefix(name, "samples"), this.formatNumber(meter.getCount()));
        this.statsD.send(this.prefix(name, "m1_rate"), this.formatNumber(this.convertRate(meter.getOneMinuteRate())));
        this.statsD.send(this.prefix(name, "m5_rate"), this.formatNumber(this.convertRate(meter.getFiveMinuteRate())));
        this.statsD.send(this.prefix(name, "m15_rate"), this.formatNumber(this.convertRate(meter.getFifteenMinuteRate())));
        this.statsD.send(this.prefix(name, "mean_rate"), this.formatNumber(this.convertRate(meter.getMeanRate())));
    }

    private void reportHistogram(String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.statsD.send(this.prefix(name, "samples"), this.formatNumber(histogram.getCount()));
        this.statsD.send(this.prefix(name, "max"), this.formatNumber(snapshot.getMax()));
        this.statsD.send(this.prefix(name, "mean"), this.formatNumber(snapshot.getMean()));
        this.statsD.send(this.prefix(name, "min"), this.formatNumber(snapshot.getMin()));
        this.statsD.send(this.prefix(name, "stddev"), this.formatNumber(snapshot.getStdDev()));
        this.statsD.send(this.prefix(name, "p50"), this.formatNumber(snapshot.getMedian()));
        this.statsD.send(this.prefix(name, "p75"), this.formatNumber(snapshot.get75thPercentile()));
        this.statsD.send(this.prefix(name, "p95"), this.formatNumber(snapshot.get95thPercentile()));
        this.statsD.send(this.prefix(name, "p98"), this.formatNumber(snapshot.get98thPercentile()));
        this.statsD.send(this.prefix(name, "p99"), this.formatNumber(snapshot.get99thPercentile()));
        this.statsD.send(this.prefix(name, "p999"), this.formatNumber(snapshot.get999thPercentile()));
    }

    private void reportCounter(String name, Counter counter) {
        this.statsD.send(this.prefix(name), this.formatNumber(counter.getCount()));
    }

    private void reportGauge(String name, Gauge gauge) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            this.statsD.send(this.prefix(name), value);
        }
    }

    @Nullable
    private String format(Object o) {
        if (o instanceof Float) {
            return this.formatNumber(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.formatNumber((Double)o);
        }
        if (o instanceof Byte) {
            return this.formatNumber(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.formatNumber(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.formatNumber(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.formatNumber((Long)o);
        }
        if (o instanceof BigInteger) {
            return this.formatNumber((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return this.formatNumber(((BigDecimal)o).doubleValue());
        }
        return null;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    private String formatNumber(BigInteger n) {
        return String.valueOf(n);
    }

    private String formatNumber(long n) {
        return Long.toString(n);
    }

    private String formatNumber(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    @NotThreadSafe
    public static final class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder prefixedWith(@Nullable String _prefix) {
            this.prefix = _prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit _rateUnit) {
            this.rateUnit = _rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit _durationUnit) {
            this.durationUnit = _durationUnit;
            return this;
        }

        public Builder filter(MetricFilter _filter) {
            this.filter = _filter;
            return this;
        }

        public StatsDReporter build(String host, int port) {
            return this.build(new StatsD(host, port));
        }

        public StatsDReporter build(StatsD statsD) {
            return new StatsDReporter(this.registry, statsD, this.prefix, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

