/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace;

import com.sun.btrace.BTraceCollection;
import com.sun.btrace.BTraceDeque;
import com.sun.btrace.BTraceMBean;
import com.sun.btrace.BTraceMap;
import com.sun.btrace.BTraceUtils;
import com.sun.btrace.CommandListener;
import com.sun.btrace.DOTWriter;
import com.sun.btrace.ExitException;
import com.sun.btrace.MemoryClassLoader;
import com.sun.btrace.PerfReader;
import com.sun.btrace.Profiler;
import com.sun.btrace.RunnableGenerator;
import com.sun.btrace.ThreadEnteredMap;
import com.sun.btrace.XMLSerializer;
import com.sun.btrace.aggregation.Aggregation;
import com.sun.btrace.aggregation.AggregationFunction;
import com.sun.btrace.aggregation.AggregationKey;
import com.sun.btrace.annotations.OnError;
import com.sun.btrace.annotations.OnEvent;
import com.sun.btrace.annotations.OnExit;
import com.sun.btrace.annotations.OnLowMemory;
import com.sun.btrace.annotations.OnTimer;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.EventCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.comm.GridDataCommand;
import com.sun.btrace.comm.MessageCommand;
import com.sun.btrace.comm.NumberDataCommand;
import com.sun.btrace.comm.NumberMapDataCommand;
import com.sun.btrace.comm.StringMapDataCommand;
import com.sun.btrace.profiling.MethodInvocationProfiler;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.misc.Perf;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.security.action.GetPropertyAction;

public final class BTraceRuntime {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static Properties dotWriterProps;
    private static BTraceRuntime dummy;
    private static BTraceRuntime NULL;
    private static boolean dtraceEnabled;
    private static final boolean messageTimestamp = false;
    private static final String LINE_SEPARATOR;
    private static ThreadEnteredMap map;
    private static Map<String, BTraceRuntime> runtimes;
    private static volatile Perf perf;
    private static volatile PerfReader perfReader;
    private static Map<String, ByteBuffer> counters;
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;
    private static volatile MemoryMXBean memoryMBean;
    private static volatile RuntimeMXBean runtimeMBean;
    private static volatile ThreadMXBean threadMBean;
    private static volatile List<GarbageCollectorMXBean> gcBeanList;
    private static volatile List<MemoryPoolMXBean> memPoolList;
    private static RunnableGenerator runnableGenerator;
    private ThreadLocal<Throwable> currentException = new ThreadLocal();
    private String[] args;
    private volatile boolean disabled;
    private String className;
    private Class clazz;
    private Method exitHandler;
    private Method exceptionHandler;
    private Method[] timerHandlers;
    private Map<String, Method> eventHandlers;
    private Map<String, Method> lowMemHandlers;
    private volatile Timer timer;
    private volatile ExecutorService threadPool;
    private volatile NotificationListener memoryListener;
    private volatile LinkedBlockingQueue<Command> queue;
    private volatile SpeculativeQueueManager specQueueManager;
    private volatile Thread cmdThread;
    private volatile CommandListener cmdListener;
    private Instrumentation instrumentation;
    private static final int V_Variable = 3;
    private static final int V_None = 1;
    private static final int V_String = 5;
    private static final int PERF_STRING_LIMIT = 256;
    private static String INDENT;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    private BTraceRuntime() {
    }

    public BTraceRuntime(final String className, String[] args, final CommandListener cmdListener, Instrumentation inst) {
        this.args = args;
        this.queue = new LinkedBlockingQueue();
        this.specQueueManager = new SpeculativeQueueManager();
        this.cmdListener = cmdListener;
        this.className = className;
        this.instrumentation = inst;
        runtimes.put(className, this);
        this.cmdThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    BTraceRuntime.enter();
                    while (true) {
                        Command cmd = (Command)BTraceRuntime.this.queue.take();
                        cmdListener.onCommand(cmd);
                        if (cmd.getType() == 2) {
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                finally {
                    runtimes.put(className, null);
                    BTraceRuntime.this.queue.clear();
                    BTraceRuntime.this.specQueueManager.clear();
                    BTraceRuntime.leave();
                    BTraceRuntime.this.disabled = true;
                }
            }
        });
        this.cmdThread.setDaemon(true);
        this.cmdThread.start();
    }

    public static boolean classNameExists(String name) {
        return runtimes.containsKey(name);
    }

    public static void init(PerfReader perfRead, RunnableGenerator runGen) {
        Class caller = Reflection.getCallerClass((int)2);
        if (!caller.getName().equals("com.sun.btrace.agent.Client")) {
            throw new SecurityException("unsafe init");
        }
        perfReader = perfRead;
        runnableGenerator = runGen;
        BTraceRuntime.loadLibrary(perfRead.getClass().getClassLoader());
    }

    public Class defineClass(byte[] code) {
        Class caller = Reflection.getCallerClass((int)2);
        if (!caller.getName().equals("com.sun.btrace.agent.Client")) {
            throw new SecurityException("unsafe defineClass");
        }
        return this.defineClassImpl(code, true);
    }

    public Class defineClass(byte[] code, boolean mustBeBootstrap) {
        Class caller = Reflection.getCallerClass((int)2);
        if (!caller.getName().equals("com.sun.btrace.agent.Client")) {
            throw new SecurityException("unsafe defineClass");
        }
        return this.defineClassImpl(code, mustBeBootstrap);
    }

    public static boolean enter(BTraceRuntime current) {
        if (current.disabled) {
            return false;
        }
        return map.enter(current);
    }

    public static boolean enter() {
        return BTraceRuntime.enter(dummy);
    }

    public static void leave() {
        map.exit();
    }

    public static void start() {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        if (current != null) {
            current.startImpl();
        }
    }

    public void handleExit(int exitCode) {
        this.exitImpl(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(EventCommand ecmd) {
        String event;
        Method eventHandler;
        if (this.eventHandlers != null && (eventHandler = this.eventHandlers.get(event = ecmd.getEvent())) != null) {
            BTraceRuntime oldRuntime = (BTraceRuntime)map.get();
            BTraceRuntime.leave();
            try {
                eventHandler.invoke(null, (Object[])null);
            }
            catch (Throwable ignored) {
            }
            finally {
                if (oldRuntime != null) {
                    BTraceRuntime.enter(oldRuntime);
                }
            }
        }
    }

    public static BTraceRuntime forClass(Class cl) {
        BTraceRuntime runtime = runtimes.get(cl.getName());
        runtime.init(cl);
        return runtime;
    }

    public static ThreadLocal newThreadLocal(final Object initValue) {
        return new ThreadLocal(){

            protected Object initialValue() {
                if (initValue == null) {
                    return initValue;
                }
                if (initValue instanceof Cloneable) {
                    try {
                        Class<?> clz = initValue.getClass();
                        Method m = clz.getDeclaredMethod("clone", new Class[0]);
                        m.setAccessible(true);
                        return m.invoke(initValue, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return initValue;
            }
        };
    }

    public static void newPerfCounter(String name, String desc, Object value) {
        Perf perf = BTraceRuntime.getPerf();
        char tc = desc.charAt(0);
        switch (tc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                long initValue = value != null ? ((Number)value).longValue() : 0L;
                ByteBuffer b = perf.createLong(name, 3, 1, initValue);
                b.order(ByteOrder.nativeOrder());
                counters.put(name, b);
                break;
            }
            case '[': {
                break;
            }
            case 'L': {
                byte[] buf;
                if (!desc.equals("Ljava/lang/String;")) break;
                if (value != null) {
                    buf = BTraceRuntime.getStringBytes((String)value);
                } else {
                    buf = new byte[256];
                    buf[0] = 0;
                }
                ByteBuffer b = perf.createByteArray(name, 3, 5, buf, buf.length);
                counters.put(name, b);
            }
        }
    }

    public static int getPerfInt(String name) {
        return (int)BTraceRuntime.getPerfLong(name);
    }

    public static void putPerfInt(int value, String name) {
        long l = value;
        BTraceRuntime.putPerfLong(l, name);
    }

    public static float getPerfFloat(String name) {
        int val = BTraceRuntime.getPerfInt(name);
        return Float.intBitsToFloat(val);
    }

    public static void putPerfFloat(float value, String name) {
        int i = Float.floatToRawIntBits(value);
        BTraceRuntime.putPerfInt(i, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getPerfLong(String name) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = counters.get(name);
        synchronized (byteBuffer) {
            long l = b.getLong();
            b.rewind();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putPerfLong(long value, String name) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = counters.get(name);
        synchronized (byteBuffer) {
            b.putLong(value);
            b.rewind();
        }
    }

    public static double getPerfDouble(String name) {
        long val = BTraceRuntime.getPerfLong(name);
        return Double.longBitsToDouble(val);
    }

    public static void putPerfDouble(double value, String name) {
        long l = Double.doubleToRawLongBits(value);
        BTraceRuntime.putPerfLong(l, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPerfString(String name) {
        ByteBuffer b = counters.get(name);
        byte[] buf = new byte[b.limit()];
        byte t = 0;
        int i = 0;
        ByteBuffer byteBuffer = b;
        synchronized (byteBuffer) {
            while ((t = b.get()) != 0) {
                buf[i++] = t;
            }
            b.rewind();
        }
        try {
            return new String(buf, 0, i, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putPerfString(String value, String name) {
        ByteBuffer b = counters.get(name);
        byte[] v = BTraceRuntime.getStringBytes(value);
        ByteBuffer byteBuffer = b;
        synchronized (byteBuffer) {
            b.put(v);
            b.rewind();
        }
    }

    public static void handleException(Throwable th) {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        if (current != null) {
            current.handleExceptionImpl(th);
        } else {
            th.printStackTrace();
        }
    }

    static int speculation() {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        return current.specQueueManager.speculation();
    }

    static void speculate(int id) {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        current.specQueueManager.speculate(id);
    }

    static void discard(int id) {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        current.specQueueManager.discard(id);
    }

    static void commit(int id) {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        current.specQueueManager.commit(id, current.queue);
    }

    static boolean compare(Object obj1, Object obj2) {
        if (obj1 instanceof String) {
            return obj1.equals(obj2);
        }
        if (obj1.getClass().getClassLoader() == null && (obj2 == null || obj2.getClass().getClassLoader() == null)) {
            return obj1.equals(obj2);
        }
        return obj1 == obj2;
    }

    static <K, V> Map<K, V> newHashMap() {
        return new BTraceMap(new HashMap());
    }

    static <K, V> Map<K, V> newWeakMap() {
        return new BTraceMap(new WeakHashMap());
    }

    static <V> Deque<V> newDeque() {
        return new BTraceDeque(new ArrayDeque());
    }

    static Appendable newStringBuilder(boolean threadSafe) {
        return threadSafe ? new StringBuffer() : new StringBuilder();
    }

    static Appendable newStringBuilder() {
        return BTraceRuntime.newStringBuilder(false);
    }

    static <E> int size(Collection<E> coll) {
        if (coll instanceof BTraceCollection || coll.getClass().getClassLoader() == null) {
            return coll.size();
        }
        throw new IllegalArgumentException();
    }

    public static <E> boolean isEmpty(Collection<E> coll) {
        if (coll instanceof BTraceCollection || coll.getClass().getClassLoader() == null) {
            return coll.isEmpty();
        }
        throw new IllegalArgumentException();
    }

    static <E> boolean contains(Collection<E> coll, Object obj) {
        if (coll instanceof BTraceCollection || coll.getClass().getClassLoader() == null) {
            for (E e : coll) {
                if (!BTraceRuntime.compare(e, obj)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException();
    }

    static <E> Object[] toArray(Collection<E> collection) {
        if (collection == null) {
            return new Object[0];
        }
        return collection.toArray();
    }

    static <K, V> V get(Map<K, V> map, Object key) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.get(key);
        }
        throw new IllegalArgumentException();
    }

    static <K, V> boolean containsKey(Map<K, V> map, Object key) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.containsKey(key);
        }
        throw new IllegalArgumentException();
    }

    static <K, V> boolean containsValue(Map<K, V> map, Object value) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.containsValue(value);
        }
        throw new IllegalArgumentException();
    }

    static <K, V> V put(Map<K, V> map, K key, V value) {
        if (map instanceof BTraceMap) {
            return map.put(key, value);
        }
        throw new IllegalArgumentException("not a btrace map");
    }

    static <K, V> V remove(Map<K, V> map, Object key) {
        if (map instanceof BTraceMap) {
            return map.remove(key);
        }
        throw new IllegalArgumentException("not a btrace map");
    }

    static <K, V> void clear(Map<K, V> map) {
        if (!(map instanceof BTraceMap)) {
            throw new IllegalArgumentException("not a btrace map");
        }
        map.clear();
    }

    static <K, V> int size(Map<K, V> map) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.size();
        }
        throw new IllegalArgumentException();
    }

    static <K, V> boolean isEmpty(Map<K, V> map) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.isEmpty();
        }
        throw new IllegalArgumentException();
    }

    static <K, V> void putAll(Map<K, V> src, Map<K, V> dst) {
        dst.putAll(src);
    }

    static <K, V> void copy(Map<K, V> src, Map<K, V> dst) {
        dst.clear();
        dst.putAll(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printMap(Map map) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            Map map2 = map;
            synchronized (map2) {
                HashMap<String, String> m = new HashMap<String, String>();
                Set entries = map.entrySet();
                for (Map.Entry e : entries) {
                    m.put(BTraceUtils.Strings.str(e.getKey()), BTraceUtils.Strings.str(e.getValue()));
                }
                BTraceRuntime.printStringMap(null, m);
            }
        } else {
            BTraceRuntime.print(BTraceUtils.Strings.str(map));
        }
    }

    public static <V> void push(Deque<V> queue, V value) {
        if (!(queue instanceof BTraceDeque) && queue.getClass().getClassLoader() != null) {
            throw new IllegalArgumentException();
        }
        queue.push(value);
    }

    public static <V> void addLast(Deque<V> queue, V value) {
        if (!(queue instanceof BTraceDeque) && queue.getClass().getClassLoader() != null) {
            throw new IllegalArgumentException();
        }
        queue.addLast(value);
    }

    public static <V> V peekFirst(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.peekFirst();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V peekLast(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.peekLast();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V removeLast(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.removeLast();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V removeFirst(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.removeLast();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V poll(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.poll();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V peek(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.peek();
        }
        throw new IllegalArgumentException();
    }

    public static <V> void clear(Deque<V> queue) {
        if (!(queue instanceof BTraceDeque) && queue.getClass().getClassLoader() != null) {
            throw new IllegalArgumentException();
        }
        queue.clear();
    }

    public static Appendable append(Appendable buffer, String strToAppend) {
        try {
            if (buffer != null && strToAppend != null) {
                return buffer.append(strToAppend);
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int length(Appendable buffer) {
        if (buffer != null && buffer instanceof CharSequence) {
            return ((CharSequence)((Object)buffer)).length();
        }
        throw new IllegalArgumentException();
    }

    static void printNumber(String name, Number value) {
        BTraceRuntime.getCurrent().send(new NumberDataCommand(name, value));
    }

    static void printNumberMap(String name, Map<String, ? extends Number> data) {
        BTraceRuntime.getCurrent().send(new NumberMapDataCommand(name, data));
    }

    static void printStringMap(String name, Map<String, String> data) {
        BTraceRuntime.getCurrent().send(new StringMapDataCommand(name, data));
    }

    static void exit(int exitCode) {
        BTraceRuntime runtime = BTraceRuntime.getCurrent();
        if (runtime != null) {
            Throwable th = runtime.currentException.get();
            if (!(th instanceof ExitException)) {
                runtime.currentException.set(null);
            }
            throw new ExitException(exitCode);
        }
    }

    static long sizeof(Object obj) {
        BTraceRuntime runtime = BTraceRuntime.getCurrent();
        return runtime.instrumentation.getObjectSize(obj);
    }

    static int $length() {
        BTraceRuntime runtime = BTraceRuntime.getCurrent();
        return runtime.args == null ? 0 : runtime.args.length;
    }

    static String $(int n) {
        BTraceRuntime runtime = BTraceRuntime.getCurrent();
        if (runtime.args == null) {
            return null;
        }
        if (n >= 0 && n < runtime.args.length) {
            return runtime.args[n];
        }
        return null;
    }

    static AtomicInteger newAtomicInteger(int initVal) {
        return new BTraceAtomicInteger(initVal);
    }

    static int get(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger || ai.getClass().getClassLoader() == null) {
            return ai.get();
        }
        throw new IllegalArgumentException();
    }

    static void set(AtomicInteger ai, int i) {
        if (!(ai instanceof BTraceAtomicInteger)) {
            throw new IllegalArgumentException();
        }
        ai.set(i);
    }

    static void lazySet(AtomicInteger ai, int i) {
        if (!(ai instanceof BTraceAtomicInteger)) {
            throw new IllegalArgumentException();
        }
        ai.lazySet(i);
    }

    static boolean compareAndSet(AtomicInteger ai, int i, int j) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.compareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static boolean weakCompareAndSet(AtomicInteger ai, int i, int j) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.weakCompareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static int getAndIncrement(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndIncrement();
        }
        throw new IllegalArgumentException();
    }

    static int getAndDecrement(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndDecrement();
        }
        throw new IllegalArgumentException();
    }

    static int incrementAndGet(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.incrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static int decrementAndGet(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.decrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static int getAndAdd(AtomicInteger ai, int i) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndAdd(i);
        }
        throw new IllegalArgumentException();
    }

    static int addAndGet(AtomicInteger ai, int i) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.addAndGet(i);
        }
        throw new IllegalArgumentException();
    }

    static int getAndSet(AtomicInteger ai, int i) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndSet(i);
        }
        throw new IllegalArgumentException();
    }

    static AtomicLong newAtomicLong(long initVal) {
        return new BTraceAtomicLong(initVal);
    }

    static long get(AtomicLong al) {
        if (al instanceof BTraceAtomicLong || al.getClass().getClassLoader() == null) {
            return al.get();
        }
        throw new IllegalArgumentException();
    }

    static void set(AtomicLong al, long i) {
        if (!(al instanceof BTraceAtomicLong)) {
            throw new IllegalArgumentException();
        }
        al.set(i);
    }

    static void lazySet(AtomicLong al, long i) {
        if (!(al instanceof BTraceAtomicLong)) {
            throw new IllegalArgumentException();
        }
        al.lazySet(i);
    }

    static boolean compareAndSet(AtomicLong al, long i, long j) {
        if (al instanceof BTraceAtomicLong) {
            return al.compareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static boolean weakCompareAndSet(AtomicLong al, long i, long j) {
        if (al instanceof BTraceAtomicLong) {
            return al.weakCompareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static long getAndIncrement(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndIncrement();
        }
        throw new IllegalArgumentException();
    }

    static long getAndDecrement(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndDecrement();
        }
        throw new IllegalArgumentException();
    }

    static long incrementAndGet(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.incrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static long decrementAndGet(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.decrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static long getAndAdd(AtomicLong al, long i) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndAdd(i);
        }
        throw new IllegalArgumentException();
    }

    static long addAndGet(AtomicLong al, long i) {
        if (al instanceof BTraceAtomicLong) {
            return al.addAndGet(i);
        }
        throw new IllegalArgumentException();
    }

    static long getAndSet(AtomicLong al, long i) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndSet(i);
        }
        throw new IllegalArgumentException();
    }

    static int perfInt(String name) {
        return BTraceRuntime.getPerfReader().perfInt(name);
    }

    static long perfLong(String name) {
        return BTraceRuntime.getPerfReader().perfLong(name);
    }

    static String perfString(String name) {
        return BTraceRuntime.getPerfReader().perfString(name);
    }

    private static String stackTraceAllStr(int numFrames, boolean printWarning) {
        Set<Map.Entry<Thread, StackTraceElement[]>> traces = Thread.getAllStackTraces().entrySet();
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> t : traces) {
            buf.append(t.getKey().toString());
            buf.append(LINE_SEPARATOR);
            buf.append(LINE_SEPARATOR);
            StackTraceElement[] st = t.getValue();
            buf.append(BTraceRuntime.stackTraceStr("\t", st, 0, numFrames, printWarning));
            buf.append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    static String stackTraceAllStr(int numFrames) {
        return BTraceRuntime.stackTraceAllStr(numFrames, false);
    }

    static void stackTraceAll(int numFrames) {
        BTraceRuntime.getCurrent().send(BTraceRuntime.stackTraceAllStr(numFrames, true));
    }

    static String stackTraceStr(StackTraceElement[] st, int start, int numFrames) {
        return BTraceRuntime.stackTraceStr(null, st, start, numFrames, false);
    }

    static String stackTraceStr(String prefix, StackTraceElement[] st, int start, int numFrames) {
        return BTraceRuntime.stackTraceStr(prefix, st, start, numFrames, false);
    }

    private static String stackTraceStr(String prefix, StackTraceElement[] st, int start, int numFrames, boolean printWarning) {
        start = start > 0 ? start : 0;
        numFrames = numFrames > 0 ? numFrames : st.length - start;
        int limit = start + numFrames;
        int n = limit = limit <= st.length ? limit : st.length;
        if (prefix == null) {
            prefix = "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < limit; ++i) {
            if (prefix != null) {
                buf.append(prefix);
            }
            buf.append(st[i].toString());
            buf.append(LINE_SEPARATOR);
        }
        if (printWarning && limit < st.length) {
            if (prefix != null) {
                buf.append(prefix);
            }
            buf.append(st.length - limit);
            buf.append(" more frame(s) ...");
            buf.append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    static void stackTrace(StackTraceElement[] st, int start, int numFrames) {
        BTraceRuntime.stackTrace(null, st, start, numFrames);
    }

    static void stackTrace(String prefix, StackTraceElement[] st, int start, int numFrames) {
        BTraceRuntime.getCurrent().send(BTraceRuntime.stackTraceStr(prefix, st, start, numFrames, true));
    }

    static void print(String str) {
        BTraceRuntime.getCurrent().send(str);
    }

    static void println(String str) {
        BTraceRuntime.getCurrent().send(str + LINE_SEPARATOR);
    }

    static void println() {
        BTraceRuntime.getCurrent().send(LINE_SEPARATOR);
    }

    static String property(String name) {
        return AccessController.doPrivileged(new GetPropertyAction(name));
    }

    static Properties properties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    static String getenv(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(name);
            }
        });
    }

    static Map<String, String> getenv() {
        return AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return System.getenv();
            }
        });
    }

    static MemoryUsage heapUsage() {
        BTraceRuntime.initMemoryMBean();
        return memoryMBean.getHeapMemoryUsage();
    }

    static MemoryUsage nonHeapUsage() {
        BTraceRuntime.initMemoryMBean();
        return memoryMBean.getNonHeapMemoryUsage();
    }

    static long finalizationCount() {
        BTraceRuntime.initMemoryMBean();
        return memoryMBean.getObjectPendingFinalizationCount();
    }

    static long vmStartTime() {
        BTraceRuntime.initRuntimeMBean();
        return runtimeMBean.getStartTime();
    }

    static long vmUptime() {
        BTraceRuntime.initRuntimeMBean();
        return runtimeMBean.getUptime();
    }

    static List<String> getInputArguments() {
        BTraceRuntime.initRuntimeMBean();
        return runtimeMBean.getInputArguments();
    }

    static String getVmVersion() {
        BTraceRuntime.initRuntimeMBean();
        return runtimeMBean.getVmVersion();
    }

    static boolean isBootClassPathSupported() {
        BTraceRuntime.initRuntimeMBean();
        return runtimeMBean.isBootClassPathSupported();
    }

    static String getBootClassPath() {
        BTraceRuntime.initRuntimeMBean();
        return runtimeMBean.getBootClassPath();
    }

    static long getThreadCount() {
        BTraceRuntime.initThreadMBean();
        return threadMBean.getThreadCount();
    }

    static long getPeakThreadCount() {
        BTraceRuntime.initThreadMBean();
        return threadMBean.getPeakThreadCount();
    }

    static long getTotalStartedThreadCount() {
        BTraceRuntime.initThreadMBean();
        return threadMBean.getTotalStartedThreadCount();
    }

    static long getDaemonThreadCount() {
        BTraceRuntime.initThreadMBean();
        return threadMBean.getDaemonThreadCount();
    }

    static long getCurrentThreadCpuTime() {
        BTraceRuntime.initThreadMBean();
        threadMBean.setThreadCpuTimeEnabled(true);
        return threadMBean.getCurrentThreadCpuTime();
    }

    static long getCurrentThreadUserTime() {
        BTraceRuntime.initThreadMBean();
        threadMBean.setThreadCpuTimeEnabled(true);
        return threadMBean.getCurrentThreadUserTime();
    }

    static void dumpHeap(String fileName, boolean live) {
        BTraceRuntime.initHotspotMBean();
        try {
            String name = BTraceRuntime.resolveFileName(fileName);
            hotspotMBean.dumpHeap(name, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    static long getTotalGcTime() {
        BTraceRuntime.initGarbageCollectionBeans();
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeanList) {
            totalGcTime += gcBean.getCollectionTime();
        }
        return totalGcTime;
    }

    static String getMemoryPoolUsage(String poolFormat) {
        if (poolFormat == null) {
            poolFormat = "%1$s;%2$d;%3$d;%4$d;%5$d";
        }
        Object[][] poolOutput = new Object[memPoolList.size()][5];
        StringBuilder membuffer = new StringBuilder();
        for (int i = 0; i < memPoolList.size(); ++i) {
            MemoryPoolMXBean memPool = memPoolList.get(i);
            poolOutput[i][0] = memPool.getName();
            poolOutput[i][1] = new Long(memPool.getUsage().getMax());
            poolOutput[i][2] = new Long(memPool.getUsage().getUsed());
            poolOutput[i][3] = new Long(memPool.getUsage().getCommitted());
            poolOutput[i][4] = new Long(memPool.getUsage().getInit());
        }
        for (Object[] memPoolOutput : poolOutput) {
            membuffer.append(String.format(poolFormat, memPoolOutput)).append("\n");
        }
        return membuffer.toString();
    }

    static void serialize(Object obj, String fileName) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(BTraceRuntime.resolveFileName(fileName)));
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    static String toXML(Object obj) {
        try {
            return XMLSerializer.toXML(obj);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    static void writeXML(Object obj, String fileName) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(BTraceRuntime.resolveFileName(fileName)));
            XMLSerializer.write(obj, bw);
            bw.close();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static synchronized void initDOTWriterProps() {
        if (dotWriterProps == null) {
            dotWriterProps = new Properties();
            InputStream is = BTraceRuntime.class.getResourceAsStream("resources/btrace.dotwriter.properties");
            if (is != null) {
                try {
                    dotWriterProps.load(is);
                }
                catch (IOException ioExp) {
                    ioExp.printStackTrace();
                }
            }
            try {
                String home = System.getProperty("user.home");
                File file = new File(home, "btrace.dotwriter.properties");
                if (file.exists() && file.isFile() && (is = new BufferedInputStream(new FileInputStream(file))) != null) {
                    dotWriterProps.load(is);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    static void writeDOT(Object obj, String fileName) {
        DOTWriter writer = new DOTWriter(BTraceRuntime.resolveFileName(fileName));
        BTraceRuntime.initDOTWriterProps();
        writer.customize(dotWriterProps);
        writer.addNode(null, obj);
        writer.close();
    }

    static void deadlocks(boolean stackTrace) {
        long[] tids;
        BTraceRuntime.initThreadMBean();
        if (threadMBean.isSynchronizerUsageSupported() && (tids = threadMBean.findDeadlockedThreads()) != null && tids.length > 0) {
            ThreadInfo[] infos = threadMBean.getThreadInfo(tids, true, true);
            StringBuilder sb = new StringBuilder();
            for (ThreadInfo ti : infos) {
                sb.append("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
                if (ti.getLockName() != null) {
                    sb.append(" on lock=" + ti.getLockName());
                }
                if (ti.isSuspended()) {
                    sb.append(" (suspended)");
                }
                if (ti.isInNative()) {
                    sb.append(" (running in native)");
                }
                if (ti.getLockOwnerName() != null) {
                    sb.append(INDENT + " owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
                    sb.append(LINE_SEPARATOR);
                }
                if (stackTrace) {
                    StackTraceElement[] stacktrace = ti.getStackTrace();
                    MonitorInfo[] monitors = ti.getLockedMonitors();
                    for (int i = 0; i < stacktrace.length; ++i) {
                        StackTraceElement ste = stacktrace[i];
                        sb.append(INDENT + "at " + ste.toString());
                        sb.append(LINE_SEPARATOR);
                        for (MonitorInfo mi : monitors) {
                            if (mi.getLockedStackDepth() != i) continue;
                            sb.append(INDENT + "  - locked " + mi);
                            sb.append(LINE_SEPARATOR);
                        }
                    }
                    sb.append(LINE_SEPARATOR);
                }
                LockInfo[] locks = ti.getLockedSynchronizers();
                sb.append(INDENT + "Locked synchronizers: count = " + locks.length);
                sb.append(LINE_SEPARATOR);
                for (LockInfo li : locks) {
                    sb.append(INDENT + "  - " + li);
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(LINE_SEPARATOR);
            }
            BTraceRuntime.getCurrent().send(sb.toString());
        }
    }

    static int dtraceProbe(String s1, String s2, int i1, int i2) {
        if (dtraceEnabled) {
            return BTraceRuntime.dtraceProbe0(s1, s2, i1, i2);
        }
        return 0;
    }

    static Aggregation newAggregation(AggregationFunction type) {
        return new Aggregation(type);
    }

    static AggregationKey newAggregationKey(Object ... elements) {
        return new AggregationKey(elements);
    }

    static void addToAggregation(Aggregation aggregation, long value) {
        aggregation.add(value);
    }

    static void addToAggregation(Aggregation aggregation, AggregationKey key, long value) {
        aggregation.add(key, value);
    }

    static void clearAggregation(Aggregation aggregation) {
        aggregation.clear();
    }

    static void truncateAggregation(Aggregation aggregation, int count) {
        aggregation.truncate(count);
    }

    static void printAggregation(String name, Aggregation aggregation) {
        BTraceRuntime.getCurrent().send(new GridDataCommand(name, aggregation.getData()));
    }

    static void printSnapshot(String name, Profiler.Snapshot snapshot) {
        BTraceRuntime.getCurrent().send(new GridDataCommand(name, snapshot.getGridData()));
    }

    static void printSnapshot(String name, Profiler.Snapshot snapshot, String format) {
        BTraceRuntime.getCurrent().send(new GridDataCommand(name, snapshot.getGridData(), format));
    }

    static void printAggregation(String name, String format, Aggregation[] aggregationArray) {
        if (aggregationArray.length > 1 && aggregationArray[0].getKeyData().size() > 1) {
            int aggregationDataSize = aggregationArray[0].getKeyData().get(0).getElements().length + aggregationArray.length;
            ArrayList<Object[]> aggregationData = new ArrayList<Object[]>();
            for (AggregationKey aggKey : aggregationArray[0].getKeyData()) {
                int aggDataIndex = 0;
                Object[] currAggregationData = new Object[aggregationDataSize];
                Object[] arr$ = aggKey.getElements();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Object obj;
                    currAggregationData[aggDataIndex] = obj = arr$[i$];
                    ++aggDataIndex;
                }
                for (Aggregation agg : aggregationArray) {
                    currAggregationData[aggDataIndex] = agg.getValueForKey(aggKey);
                    ++aggDataIndex;
                }
                aggregationData.add(currAggregationData);
            }
            BTraceRuntime.getCurrent().send(new GridDataCommand(name, aggregationData, format));
        }
    }

    static void printAggregation(String name, Aggregation aggregation, String format) {
        BTraceRuntime.getCurrent().send(new GridDataCommand(name, aggregation.getData(), format));
    }

    static Profiler newProfiler() {
        return new MethodInvocationProfiler(600);
    }

    static Profiler newProfiler(int expectedMethodCnt) {
        return new MethodInvocationProfiler(expectedMethodCnt);
    }

    static void recordEntry(Profiler profiler, String methodName) {
        profiler.recordEntry(methodName);
    }

    static void recordExit(Profiler profiler, String methodName, long duration) {
        profiler.recordExit(methodName, duration);
    }

    static Profiler.Snapshot snapshot(Profiler profiler) {
        return profiler.snapshot();
    }

    static Profiler.Snapshot snapshotAndReset(Profiler profiler) {
        return profiler.snapshot(true);
    }

    static void resetProfiler(Profiler profiler) {
        profiler.reset();
    }

    private static native int dtraceProbe0(String var0, String var1, int var2, int var3);

    private static BTraceRuntime getCurrent() {
        BTraceRuntime current = (BTraceRuntime)map.get();
        assert (current != null) : "BTraceRuntime is null!";
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThreadPool() {
        if (this.threadPool == null) {
            BTraceRuntime bTraceRuntime = this;
            synchronized (bTraceRuntime) {
                if (this.threadPool == null) {
                    this.threadPool = Executors.newFixedThreadPool(1, new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread th = new Thread(r);
                            th.setDaemon(true);
                            return th;
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = BTraceRuntime.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<HotSpotDiagnosticMXBean>(){

                @Override
                public HotSpotDiagnosticMXBean run() throws Exception {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Set<ObjectName> s = server.queryNames(new ObjectName(BTraceRuntime.HOTSPOT_BEAN_NAME), null);
                    Iterator<ObjectName> itr = s.iterator();
                    if (itr.hasNext()) {
                        ObjectName name = itr.next();
                        HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), HotSpotDiagnosticMXBean.class);
                        return bean;
                    }
                    return null;
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initMemoryMBean() {
        if (memoryMBean != null) return;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (memoryMBean != null) return;
            memoryMBean = BTraceRuntime.getMemoryMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void initMemoryListener() {
        this.initThreadPool();
        this.memoryListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notif, Object handback) {
                String notifType = notif.getType();
                if (notifType.equals("java.management.memory.threshold.exceeded")) {
                    CompositeData cd = (CompositeData)notif.getUserData();
                    final MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
                    String name = info.getPoolName();
                    final Method handler = (Method)BTraceRuntime.this.lowMemHandlers.get(name);
                    if (handler != null) {
                        BTraceRuntime.this.threadPool.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (handler.getParameterTypes().length == 1) {
                                        handler.invoke(null, info.getUsage());
                                    } else {
                                        handler.invoke(null, (Object[])null);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
            }
        };
    }

    private static MemoryMXBean getMemoryMBean() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<MemoryMXBean>(){

                @Override
                public MemoryMXBean run() throws Exception {
                    return ManagementFactory.getMemoryMXBean();
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initRuntimeMBean() {
        if (runtimeMBean != null) return;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (runtimeMBean != null) return;
            runtimeMBean = BTraceRuntime.getRuntimeMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static RuntimeMXBean getRuntimeMBean() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RuntimeMXBean>(){

                @Override
                public RuntimeMXBean run() throws Exception {
                    return ManagementFactory.getRuntimeMXBean();
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initThreadMBean() {
        if (threadMBean != null) return;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (threadMBean != null) return;
            threadMBean = BTraceRuntime.getThreadMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static ThreadMXBean getThreadMBean() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ThreadMXBean>(){

                @Override
                public ThreadMXBean run() throws Exception {
                    return ManagementFactory.getThreadMXBean();
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    private static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<List<MemoryPoolMXBean>>(){

                @Override
                public List<MemoryPoolMXBean> run() throws Exception {
                    return ManagementFactory.getMemoryPoolMXBeans();
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    private static List<GarbageCollectorMXBean> getGarbageCollectionMBeans() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<List<GarbageCollectorMXBean>>(){

                @Override
                public List<GarbageCollectorMXBean> run() throws Exception {
                    return ManagementFactory.getGarbageCollectorMXBeans();
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initGarbageCollectionBeans() {
        if (gcBeanList != null) return;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (gcBeanList != null) return;
            gcBeanList = BTraceRuntime.getGarbageCollectionMBeans();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initMemoryPoolList() {
        if (memPoolList != null) return;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (memPoolList != null) return;
            memPoolList = BTraceRuntime.getMemoryPoolMXBeans();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static PerfReader getPerfReader() {
        if (perfReader == null) {
            throw new UnsupportedOperationException();
        }
        return perfReader;
    }

    private static RunnableGenerator getRunnableGenerator() {
        return runnableGenerator;
    }

    private void send(String msg) {
        this.send(new MessageCommand(0L, msg));
    }

    public void send(Command cmd) {
        try {
            boolean speculated = this.specQueueManager.send(cmd);
            if (!speculated) {
                this.queue.put(cmd);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptionImpl(Throwable th) {
        if (this.currentException.get() != null) {
            return;
        }
        BTraceRuntime.leave();
        this.currentException.set(th);
        try {
            if (th instanceof ExitException) {
                this.exitImpl(((ExitException)th).exitCode());
            } else if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.invoke(null, th);
                }
                catch (Throwable ignored) {}
            } else {
                try {
                    this.queue.put(new ErrorCommand(th));
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
        finally {
            this.currentException.set(null);
        }
    }

    private void startImpl() {
        if (this.timerHandlers != null && this.timerHandlers.length != 0) {
            this.timer = new Timer(true);
            RunnableGenerator gen = BTraceRuntime.getRunnableGenerator();
            Runnable[] runnables = new Runnable[this.timerHandlers.length];
            if (gen != null) {
                this.generateRunnables(gen, runnables);
            } else {
                this.wrapToRunnables(runnables);
            }
            for (int index = 0; index < this.timerHandlers.length; ++index) {
                Method m = this.timerHandlers[index];
                OnTimer tp = m.getAnnotation(OnTimer.class);
                long period = tp.value();
                final Runnable r = runnables[index];
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        r.run();
                    }
                }, period, period);
            }
        }
        if (!this.lowMemHandlers.isEmpty()) {
            BTraceRuntime.initMemoryMBean();
            this.initMemoryListener();
            NotificationEmitter emitter = (NotificationEmitter)((Object)memoryMBean);
            emitter.addNotificationListener(this.memoryListener, null, null);
        }
        BTraceRuntime.leave();
    }

    private void generateRunnables(RunnableGenerator gen, Runnable[] runnables) {
        final MemoryClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<MemoryClassLoader>(){

            @Override
            public MemoryClassLoader run() {
                return new MemoryClassLoader(BTraceRuntime.this.clazz.getClassLoader());
            }
        });
        for (int index = 0; index < this.timerHandlers.length; ++index) {
            Method m = this.timerHandlers[index];
            try {
                final String className = "com/sun/btrace/BTraceRunnable$" + index;
                final byte[] buf = gen.generate(m, className);
                Class cls = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws Exception {
                        return loader.loadClass(className.replace('/', '.'), buf);
                    }
                });
                runnables[index] = (Runnable)cls.newInstance();
                continue;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exp) {
                throw new RuntimeException(exp);
            }
        }
    }

    private void wrapToRunnables(Runnable[] runnables) {
        for (int index = 0; index < this.timerHandlers.length; ++index) {
            final Method m = this.timerHandlers[index];
            runnables[index] = new Runnable(){

                @Override
                public void run() {
                    try {
                        m.invoke(null, (Object[])null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
    }

    private synchronized void exitImpl(int exitCode) {
        if (this.exitHandler != null) {
            try {
                this.exitHandler.invoke(null, exitCode);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        this.disabled = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.memoryListener != null && memoryMBean != null) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)memoryMBean);
            try {
                emitter.removeNotificationListener(this.memoryListener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                // empty catch block
            }
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        this.send(new ExitCommand(exitCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Perf getPerf() {
        if (perf != null) return perf;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (perf != null) return perf;
            perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());
            // ** MonitorExit[var0] (shouldn't be in output)
            return perf;
        }
    }

    private static byte[] getStringBytes(String value) {
        byte[] v = null;
        try {
            v = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return v1;
    }

    private Class defineClassImpl(byte[] code, boolean mustBeBootstrap) {
        ClassLoader loader = null;
        if (!mustBeBootstrap) {
            loader = new ClassLoader(null){};
        }
        Class cl = unsafe.defineClass(this.className, code, 0, code.length, loader, null);
        unsafe.ensureClassInitialized(cl);
        return cl;
    }

    private void init(Class cl) {
        Method[] methods;
        if (this.clazz != null) {
            return;
        }
        this.clazz = cl;
        ArrayList<Method> timersList = new ArrayList<Method>();
        this.eventHandlers = new HashMap<String, Method>();
        this.lowMemHandlers = new HashMap<String, Method>();
        for (Method m : methods = this.clazz.getMethods()) {
            Class<?>[] argTypes;
            OnLowMemory olm;
            OnTimer ot;
            Class<?>[] argTypes2;
            OnExit oex;
            Class<?>[] argTypes3;
            OnError oer;
            int modifiers = m.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            OnEvent oev = m.getAnnotation(OnEvent.class);
            if (oev != null && m.getParameterTypes().length == 0) {
                this.eventHandlers.put(oev.value(), m);
            }
            if ((oer = m.getAnnotation(OnError.class)) != null && (argTypes3 = m.getParameterTypes()).length == 1 && argTypes3[0] == Throwable.class) {
                this.exceptionHandler = m;
            }
            if ((oex = m.getAnnotation(OnExit.class)) != null && (argTypes2 = m.getParameterTypes()).length == 1 && argTypes2[0] == Integer.TYPE) {
                this.exitHandler = m;
            }
            if ((ot = m.getAnnotation(OnTimer.class)) != null && m.getParameterTypes().length == 0) {
                timersList.add(m);
            }
            if ((olm = m.getAnnotation(OnLowMemory.class)) == null || (argTypes = m.getParameterTypes()).length != 0 && (argTypes.length != 1 || argTypes[0] != MemoryUsage.class)) continue;
            this.lowMemHandlers.put(olm.pool(), m);
        }
        BTraceRuntime.initMemoryPoolList();
        for (MemoryPoolMXBean mpoolBean : memPoolList) {
            Method m;
            String name = mpoolBean.getName();
            if (!this.lowMemHandlers.containsKey(name)) continue;
            m = this.lowMemHandlers.get(name);
            OnLowMemory olm = m.getAnnotation(OnLowMemory.class);
            if (!mpoolBean.isUsageThresholdSupported()) continue;
            mpoolBean.setUsageThreshold(olm.threshold());
        }
        this.timerHandlers = new Method[timersList.size()];
        timersList.toArray(this.timerHandlers);
        BTraceMBean.registerMBean(this.clazz);
    }

    private static String resolveFileName(String name) {
        if (name.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("directories are not allowed");
        }
        StringBuilder buf = new StringBuilder();
        buf.append('.');
        buf.append(File.separatorChar);
        BTraceRuntime runtime = BTraceRuntime.getCurrent();
        buf.append("btrace");
        if (runtime.args != null && runtime.args.length > 0) {
            buf.append(runtime.args[0]);
        }
        buf.append(File.separatorChar);
        buf.append(runtime.className);
        new File(buf.toString()).mkdirs();
        buf.append(File.separatorChar);
        buf.append(name);
        return buf.toString();
    }

    private static void loadLibrary(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BTraceRuntime.loadBTraceLibrary(cl);
                return null;
            }
        });
    }

    private static void loadBTraceLibrary(ClassLoader loader) {
        boolean isSolaris = System.getProperty("os.name").equals("SunOS");
        if (isSolaris) {
            try {
                System.loadLibrary("btrace");
                dtraceEnabled = true;
            }
            catch (LinkageError le) {
                if (loader == null || loader.getResource("com/sun/btrace") == null) {
                    System.err.println("cannot load libbtrace.so, will miss DTrace probes from BTrace");
                    return;
                }
                String path = loader.getResource("com/sun/btrace").toString();
                path = path.substring(0, path.indexOf("!"));
                path = path.substring("jar:".length(), path.lastIndexOf(47));
                String cpu = System.getProperty("os.arch");
                if (cpu.equals("x86")) {
                    cpu = "i386";
                }
                path = path + "/" + cpu + "/libbtrace.so";
                try {
                    path = new File(new URI(path)).getAbsolutePath();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    System.load(path);
                    dtraceEnabled = true;
                }
                catch (LinkageError le1) {
                    System.err.println("cannot load libbtrace.so, will miss DTrace probes from BTrace");
                }
            }
        }
    }

    static {
        dummy = new BTraceRuntime();
        NULL = new BTraceRuntime();
        LINE_SEPARATOR = System.getProperty("line.separator");
        map = new ThreadEnteredMap(NULL);
        runtimes = Collections.synchronizedMap(new HashMap());
        counters = new HashMap<String, ByteBuffer>();
        INDENT = "    ";
    }

    private static final class BTraceAtomicInteger
    extends AtomicInteger {
        BTraceAtomicInteger(int initVal) {
            super(initVal);
        }
    }

    private static final class BTraceAtomicLong
    extends AtomicLong {
        BTraceAtomicLong(long initVal) {
            super(initVal);
        }
    }

    private static class SpeculativeQueueManager {
        private static final int MAX_SPECULATIVE_BUFFERS = Short.MAX_VALUE;
        private static final int MAX_SPECULATIVE_MSG_LIMIT = Short.MAX_VALUE;
        private int nextSpeculationId;
        private ConcurrentHashMap<Integer, LinkedBlockingQueue<Command>> speculativeQueues = new ConcurrentHashMap();
        private ThreadLocal<Integer> currentSpeculationId = new ThreadLocal();

        SpeculativeQueueManager() {
        }

        void clear() {
            this.speculativeQueues.clear();
            this.speculativeQueues = null;
            this.currentSpeculationId.remove();
            this.currentSpeculationId = null;
        }

        int speculation() {
            int nextId = this.getNextSpeculationId();
            if (nextId != -1) {
                this.speculativeQueues.put(nextId, new LinkedBlockingQueue(Short.MAX_VALUE));
            }
            return nextId;
        }

        boolean send(Command cmd) {
            LinkedBlockingQueue<Command> sb;
            Integer curId = this.currentSpeculationId.get();
            if (curId != null && cmd.getType() != 2 && (sb = this.speculativeQueues.get(curId)) != null) {
                try {
                    sb.add(cmd);
                }
                catch (IllegalStateException ise) {
                    sb.clear();
                    sb.add(new MessageCommand("speculative buffer overflow: " + curId));
                }
                return true;
            }
            return false;
        }

        void speculate(int id) {
            this.validateId(id);
            this.currentSpeculationId.set(id);
        }

        void commit(int id, LinkedBlockingQueue<Command> result) {
            this.validateId(id);
            this.currentSpeculationId.set(null);
            LinkedBlockingQueue<Command> sb = this.speculativeQueues.get(id);
            if (sb != null) {
                result.addAll(sb);
                sb.clear();
            }
        }

        void discard(int id) {
            this.validateId(id);
            this.currentSpeculationId.set(null);
            this.speculativeQueues.get(id).clear();
        }

        private synchronized int getNextSpeculationId() {
            if (this.nextSpeculationId == Short.MAX_VALUE) {
                return -1;
            }
            return this.nextSpeculationId++;
        }

        private void validateId(int id) {
            if (!this.speculativeQueues.containsKey(id)) {
                throw new RuntimeException("invalid speculative buffer id: " + id);
            }
        }
    }
}

